/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.iceberg.Schema;
import org.apache.iceberg.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.shaded.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.shaded.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;

public class PruneColumnsWithReordering
extends TypeUtil.CustomOrderSchemaVisitor<Type> {
    private final StructType requestedType;
    private final Set<Integer> filterRefs;
    private DataType current = null;
    private static final Map<Type.TypeID, Class<? extends DataType>> TYPES = ImmutableMap.builder().put(Type.TypeID.BOOLEAN, BooleanType.class).put(Type.TypeID.INTEGER, IntegerType.class).put(Type.TypeID.LONG, LongType.class).put(Type.TypeID.FLOAT, FloatType.class).put(Type.TypeID.DOUBLE, DoubleType.class).put(Type.TypeID.DATE, DateType.class).put(Type.TypeID.TIMESTAMP, TimestampType.class).put(Type.TypeID.DECIMAL, DecimalType.class).put(Type.TypeID.UUID, StringType.class).put(Type.TypeID.STRING, StringType.class).put(Type.TypeID.FIXED, BinaryType.class).put(Type.TypeID.BINARY, BinaryType.class).build();

    PruneColumnsWithReordering(StructType requestedType, Set<Integer> filterRefs) {
        this.requestedType = requestedType;
        this.filterRefs = filterRefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type schema(Schema schema, Supplier<Type> structResult) {
        this.current = this.requestedType;
        try {
            Type type = structResult.get();
            return type;
        }
        finally {
            this.current = null;
        }
    }

    @Override
    public Type struct(Types.StructType struct, Iterable<Type> fieldResults) {
        Preconditions.checkNotNull(struct, "Cannot prune null struct. Pruning must start with a schema.");
        Preconditions.checkArgument(this.current instanceof StructType, "Not a struct: %s", (Object)this.current);
        StructType requestedStruct = (StructType)this.current;
        List<Types.NestedField> fields = struct.fields();
        ArrayList<Type> types = Lists.newArrayList(fieldResults);
        boolean changed = false;
        LinkedHashMap<String, Types.NestedField> projectedFields = Maps.newLinkedHashMap();
        for (int i = 0; i < fields.size(); ++i) {
            Types.NestedField field = fields.get(i);
            Type type = (Type)types.get(i);
            if (type == null) {
                changed = true;
                continue;
            }
            if (field.type() == type) {
                projectedFields.put(field.name(), field);
                continue;
            }
            if (field.isOptional()) {
                changed = true;
                projectedFields.put(field.name(), Types.NestedField.optional(field.fieldId(), field.name(), type));
                continue;
            }
            changed = true;
            projectedFields.put(field.name(), Types.NestedField.required(field.fieldId(), field.name(), type));
        }
        boolean reordered = false;
        StructField[] requestedFields = requestedStruct.fields();
        ArrayList<Types.NestedField> newFields = Lists.newArrayListWithExpectedSize(requestedFields.length);
        for (int i = 0; i < requestedFields.length; ++i) {
            String name = requestedFields[i].name();
            if (!fields.get(i).name().equals(name)) {
                reordered = true;
            }
            newFields.add((Types.NestedField)projectedFields.remove(name));
        }
        if (!projectedFields.isEmpty()) {
            newFields.addAll(projectedFields.values());
            changed = true;
        }
        if (reordered || changed) {
            return Types.StructType.of(newFields);
        }
        return struct;
    }

    @Override
    public Type field(Types.NestedField field, Supplier<Type> fieldResult) {
        Preconditions.checkArgument(this.current instanceof StructType, "Not a struct: %s", (Object)this.current);
        StructType requestedStruct = (StructType)this.current;
        if (requestedStruct.getFieldIndex(field.name()).isEmpty()) {
            if (this.filterRefs.contains(field.fieldId())) {
                return field.type();
            }
            return null;
        }
        int fieldIndex = requestedStruct.fieldIndex(field.name());
        StructField requestedField = requestedStruct.fields()[fieldIndex];
        Preconditions.checkArgument(requestedField.nullable() || field.isRequired(), "Cannot project an optional field as non-null: %s", (Object)field.name());
        this.current = requestedField.dataType();
        try {
            Type type = fieldResult.get();
            return type;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid projection for field " + field.name() + ": " + e.getMessage(), e);
        }
        finally {
            this.current = requestedStruct;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type list(Types.ListType list, Supplier<Type> elementResult) {
        Preconditions.checkArgument(this.current instanceof ArrayType, "Not an array: %s", (Object)this.current);
        ArrayType requestedArray = (ArrayType)this.current;
        Preconditions.checkArgument(requestedArray.containsNull() || !list.isElementOptional(), "Cannot project an array of optional elements as required elements: %s", (Object)requestedArray);
        this.current = requestedArray.elementType();
        try {
            Type elementType = elementResult.get();
            if (list.elementType() == elementType) {
                Types.ListType listType = list;
                return listType;
            }
            if (list.isElementOptional()) {
                Types.ListType listType = Types.ListType.ofOptional(list.elementId(), elementType);
                return listType;
            }
            Types.ListType listType = Types.ListType.ofRequired(list.elementId(), elementType);
            return listType;
        }
        finally {
            this.current = requestedArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type map(Types.MapType map, Supplier<Type> keyResult, Supplier<Type> valueResult) {
        Preconditions.checkArgument(this.current instanceof MapType, "Not a map: %s", (Object)this.current);
        MapType requestedMap = (MapType)this.current;
        Preconditions.checkArgument(requestedMap.valueContainsNull() || !map.isValueOptional(), "Cannot project a map of optional values as required values: %s", (Object)map);
        Preconditions.checkArgument(StringType.class.isInstance(requestedMap.keyType()), "Invalid map key type (not string): %s", (Object)requestedMap.keyType());
        this.current = requestedMap.valueType();
        try {
            Type valueType = valueResult.get();
            if (map.valueType() == valueType) {
                Types.MapType mapType = map;
                return mapType;
            }
            if (map.isValueOptional()) {
                Types.MapType mapType = Types.MapType.ofOptional(map.keyId(), map.valueId(), map.keyType(), valueType);
                return mapType;
            }
            Types.MapType mapType = Types.MapType.ofRequired(map.keyId(), map.valueId(), map.keyType(), valueType);
            return mapType;
        }
        finally {
            this.current = requestedMap;
        }
    }

    @Override
    public Type primitive(Type.PrimitiveType primitive) {
        Class<? extends DataType> expectedType = TYPES.get((Object)primitive.typeId());
        Preconditions.checkArgument(expectedType != null && expectedType.isInstance(this.current), "Cannot project %s to incompatible type: %s", (Object)primitive, (Object)this.current);
        switch (primitive.typeId()) {
            case DECIMAL: {
                Types.DecimalType decimal = (Types.DecimalType)primitive;
                DecimalType requestedDecimal = (DecimalType)this.current;
                Preconditions.checkArgument(requestedDecimal.scale() == decimal.scale(), "Cannot project decimal with incompatible scale: %s != %s", requestedDecimal.scale(), decimal.scale());
                Preconditions.checkArgument(requestedDecimal.precision() >= decimal.precision(), "Cannot project decimal with incompatible precision: %s < %s", requestedDecimal.precision(), decimal.precision());
                break;
            }
            case TIMESTAMP: {
                Types.TimestampType timestamp = (Types.TimestampType)primitive;
                Preconditions.checkArgument(timestamp.shouldAdjustToUTC(), "Cannot project timestamp (without time zone) as timestamptz (with time zone)");
                break;
            }
        }
        return primitive;
    }
}

