/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Map;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.shaded.com.google.common.collect.ImmutableMap;
import org.apache.spark.sql.catalyst.util.DateTimeUtils;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringStartsWith;

public class SparkFilters {
    private static final Map<Class<? extends Filter>, Expression.Operation> FILTERS = ImmutableMap.builder().put(EqualTo.class, Expression.Operation.EQ).put(EqualNullSafe.class, Expression.Operation.EQ).put(GreaterThan.class, Expression.Operation.GT).put(GreaterThanOrEqual.class, Expression.Operation.GT_EQ).put(LessThan.class, Expression.Operation.LT).put(LessThanOrEqual.class, Expression.Operation.LT_EQ).put(In.class, Expression.Operation.IN).put(IsNull.class, Expression.Operation.IS_NULL).put(IsNotNull.class, Expression.Operation.NOT_NULL).put(And.class, Expression.Operation.AND).put(Or.class, Expression.Operation.OR).put(Not.class, Expression.Operation.NOT).put(StringStartsWith.class, Expression.Operation.STARTS_WITH).build();

    private SparkFilters() {
    }

    public static Expression convert(Filter filter) {
        Expression.Operation op = FILTERS.get(filter.getClass());
        if (op != null) {
            switch (op) {
                case IS_NULL: {
                    IsNull isNullFilter = (IsNull)filter;
                    return Expressions.isNull(isNullFilter.attribute());
                }
                case NOT_NULL: {
                    IsNotNull notNullFilter = (IsNotNull)filter;
                    return Expressions.notNull(notNullFilter.attribute());
                }
                case LT: {
                    LessThan lt = (LessThan)filter;
                    return Expressions.lessThan(lt.attribute(), SparkFilters.convertLiteral(lt.value()));
                }
                case LT_EQ: {
                    LessThanOrEqual ltEq = (LessThanOrEqual)filter;
                    return Expressions.lessThanOrEqual(ltEq.attribute(), SparkFilters.convertLiteral(ltEq.value()));
                }
                case GT: {
                    GreaterThan gt = (GreaterThan)filter;
                    return Expressions.greaterThan(gt.attribute(), SparkFilters.convertLiteral(gt.value()));
                }
                case GT_EQ: {
                    GreaterThanOrEqual gtEq = (GreaterThanOrEqual)filter;
                    return Expressions.greaterThanOrEqual(gtEq.attribute(), SparkFilters.convertLiteral(gtEq.value()));
                }
                case EQ: {
                    if (filter instanceof EqualTo) {
                        EqualTo eq = (EqualTo)filter;
                        Preconditions.checkNotNull(eq.value(), "Expression is always false (eq is not null-safe): %s", (Object)filter);
                        return Expressions.equal(eq.attribute(), SparkFilters.convertLiteral(eq.value()));
                    }
                    EqualNullSafe eq = (EqualNullSafe)filter;
                    if (eq.value() == null) {
                        return Expressions.isNull(eq.attribute());
                    }
                    return Expressions.equal(eq.attribute(), SparkFilters.convertLiteral(eq.value()));
                }
                case IN: {
                    In inFilter = (In)filter;
                    Expression in = Expressions.alwaysFalse();
                    for (Object value : inFilter.values()) {
                        in = Expressions.or(in, Expressions.equal(inFilter.attribute(), SparkFilters.convertLiteral(value)));
                    }
                    return in;
                }
                case NOT: {
                    Not notFilter = (Not)filter;
                    Expression child = SparkFilters.convert(notFilter.child());
                    if (child != null) {
                        return Expressions.not(child);
                    }
                    return null;
                }
                case AND: {
                    And andFilter = (And)filter;
                    Expression left = SparkFilters.convert(andFilter.left());
                    Expression right = SparkFilters.convert(andFilter.right());
                    if (left != null && right != null) {
                        return Expressions.and(left, right);
                    }
                    return null;
                }
                case OR: {
                    Or orFilter = (Or)filter;
                    Expression left = SparkFilters.convert(orFilter.left());
                    Expression right = SparkFilters.convert(orFilter.right());
                    if (left != null && right != null) {
                        return Expressions.or(left, right);
                    }
                    return null;
                }
                case STARTS_WITH: {
                    StringStartsWith stringStartsWith = (StringStartsWith)filter;
                    return Expressions.startsWith(stringStartsWith.attribute(), stringStartsWith.value());
                }
            }
        }
        return null;
    }

    private static Object convertLiteral(Object value) {
        if (value instanceof Timestamp) {
            return DateTimeUtils.fromJavaTimestamp((Timestamp)((Timestamp)value));
        }
        if (value instanceof Date) {
            return DateTimeUtils.fromJavaDate((Date)((Date)value));
        }
        return value;
    }
}

