/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.shaded.com.google.common.base.Splitter;
import org.apache.iceberg.shaded.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.shaded.com.google.common.collect.Lists;
import org.apache.iceberg.spark.FixupTypes;
import org.apache.iceberg.spark.PruneColumnsWithoutReordering;
import org.apache.iceberg.spark.SparkTypeToType;
import org.apache.iceberg.spark.SparkTypeVisitor;
import org.apache.iceberg.spark.TypeToSparkType;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalog.Column;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;

public class SparkSchemaUtil {
    private SparkSchemaUtil() {
    }

    public static Schema schemaForTable(SparkSession spark, String name) {
        StructType sparkType = spark.table(name).schema();
        Type converted = SparkTypeVisitor.visit((DataType)sparkType, new SparkTypeToType(sparkType));
        return new Schema(converted.asNestedType().asStructType().fields());
    }

    public static PartitionSpec specForTable(SparkSession spark, String name) throws AnalysisException {
        ArrayList<String> parts = Lists.newArrayList(Splitter.on('.').limit(2).split(name));
        String db = parts.size() == 1 ? "default" : (String)parts.get(0);
        String table = (String)parts.get(parts.size() == 1 ? 0 : 1);
        PartitionSpec spec = SparkSchemaUtil.identitySpec(SparkSchemaUtil.schemaForTable(spark, name), spark.catalog().listColumns(db, table).collectAsList());
        return spec == null ? PartitionSpec.unpartitioned() : spec;
    }

    public static StructType convert(Schema schema) {
        return (StructType)TypeUtil.visit(schema, new TypeToSparkType());
    }

    public static DataType convert(Type type) {
        return TypeUtil.visit(type, new TypeToSparkType());
    }

    public static Schema convert(StructType sparkType) {
        Type converted = SparkTypeVisitor.visit((DataType)sparkType, new SparkTypeToType(sparkType));
        return new Schema(converted.asNestedType().asStructType().fields());
    }

    public static Type convert(DataType sparkType) {
        return SparkTypeVisitor.visit(sparkType, new SparkTypeToType());
    }

    public static Schema convert(Schema baseSchema, StructType sparkType) {
        Types.StructType struct = SparkTypeVisitor.visit((DataType)sparkType, new SparkTypeToType(sparkType)).asStructType();
        Schema schema = TypeUtil.reassignIds(new Schema(struct.fields()), baseSchema);
        return FixupTypes.fixup(schema, baseSchema);
    }

    public static Schema prune(Schema schema, StructType requestedType) {
        return new Schema(TypeUtil.visit(schema, new PruneColumnsWithoutReordering(requestedType, ImmutableSet.of())).asNestedType().asStructType().fields());
    }

    public static Schema prune(Schema schema, StructType requestedType, List<Expression> filters) {
        Set<Integer> filterRefs = Binder.boundReferences(schema.asStruct(), filters, true);
        return new Schema(TypeUtil.visit(schema, new PruneColumnsWithoutReordering(requestedType, filterRefs)).asNestedType().asStructType().fields());
    }

    public static Schema prune(Schema schema, StructType requestedType, Expression filter, boolean caseSensitive) {
        Set<Integer> filterRefs = Binder.boundReferences(schema.asStruct(), Collections.singletonList(filter), caseSensitive);
        return new Schema(TypeUtil.visit(schema, new PruneColumnsWithoutReordering(requestedType, filterRefs)).asNestedType().asStructType().fields());
    }

    private static PartitionSpec identitySpec(Schema schema, Collection<Column> columns) {
        ArrayList<String> names = Lists.newArrayList();
        for (Column column : columns) {
            if (!column.isPartition()) continue;
            names.add(column.name());
        }
        return SparkSchemaUtil.identitySpec(schema, names);
    }

    private static PartitionSpec identitySpec(Schema schema, String ... partitionNames) {
        return SparkSchemaUtil.identitySpec(schema, Lists.newArrayList(partitionNames));
    }

    private static PartitionSpec identitySpec(Schema schema, List<String> partitionNames) {
        if (partitionNames == null || partitionNames.isEmpty()) {
            return null;
        }
        PartitionSpec.Builder builder = PartitionSpec.builderFor(schema);
        for (String partitionName : partitionNames) {
            builder.identity(partitionName);
        }
        return builder.build();
    }
}

