/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.shaded.com.google.common.collect.Lists;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;

class SparkTypeVisitor<T> {
    SparkTypeVisitor() {
    }

    static <T> T visit(DataType type, SparkTypeVisitor<T> visitor) {
        if (type instanceof StructType) {
            StructField[] fields = ((StructType)type).fields();
            ArrayList<T> fieldResults = Lists.newArrayListWithExpectedSize(fields.length);
            for (StructField field : fields) {
                fieldResults.add(visitor.field(field, SparkTypeVisitor.visit(field.dataType(), visitor)));
            }
            return visitor.struct((StructType)type, fieldResults);
        }
        if (type instanceof MapType) {
            return visitor.map((MapType)type, SparkTypeVisitor.visit(((MapType)type).keyType(), visitor), SparkTypeVisitor.visit(((MapType)type).valueType(), visitor));
        }
        if (type instanceof ArrayType) {
            return visitor.array((ArrayType)type, SparkTypeVisitor.visit(((ArrayType)type).elementType(), visitor));
        }
        if (type instanceof UserDefinedType) {
            throw new UnsupportedOperationException("User-defined types are not supported");
        }
        return visitor.atomic(type);
    }

    public T struct(StructType struct, List<T> fieldResults) {
        return null;
    }

    public T field(StructField field, T typeResult) {
        return null;
    }

    public T array(ArrayType array, T elementResult) {
        return null;
    }

    public T map(MapType map, T keyResult, T valueResult) {
        return null;
    }

    public T atomic(DataType atomic) {
        return null;
    }
}

