/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.AvroSchemaVisitor;
import org.apache.iceberg.avro.ValueWriter;
import org.apache.iceberg.avro.ValueWriters;
import org.apache.iceberg.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.shaded.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.org.apache.avro.LogicalType;
import org.apache.iceberg.shaded.org.apache.avro.LogicalTypes;
import org.apache.iceberg.shaded.org.apache.avro.Schema;
import org.apache.iceberg.shaded.org.apache.avro.io.DatumWriter;
import org.apache.iceberg.shaded.org.apache.avro.io.Encoder;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.data.SparkValueWriters;
import org.apache.iceberg.types.Type;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;

public class SparkAvroWriter
implements DatumWriter<InternalRow> {
    private final Schema schema;
    private ValueWriter<InternalRow> writer = null;

    public SparkAvroWriter(Schema schema) {
        this.schema = schema;
    }

    @Override
    public void setSchema(org.apache.iceberg.shaded.org.apache.avro.Schema schema) {
        this.writer = (ValueWriter)AvroSchemaVisitor.visit(schema, new WriteBuilder(this.schema));
    }

    @Override
    public void write(InternalRow datum, Encoder out) throws IOException {
        this.writer.write(datum, out);
    }

    private static class WriteBuilder
    extends AvroSchemaVisitor<ValueWriter<?>> {
        private final Schema schema;

        private WriteBuilder(Schema schema) {
            this.schema = schema;
        }

        @Override
        public ValueWriter<?> record(org.apache.iceberg.shaded.org.apache.avro.Schema record, List<String> names, List<ValueWriter<?>> fields) {
            ArrayList<DataType> types = Lists.newArrayList();
            for (Schema.Field field : record.getFields()) {
                int fieldId = AvroSchemaUtil.getFieldId(field);
                Type fieldType = this.schema.findType(fieldId);
                types.add(SparkSchemaUtil.convert(fieldType));
            }
            return SparkValueWriters.struct(fields, types);
        }

        @Override
        public ValueWriter<?> union(org.apache.iceberg.shaded.org.apache.avro.Schema union, List<ValueWriter<?>> options) {
            Preconditions.checkArgument(options.contains(ValueWriters.nulls()), "Cannot create writer for non-option union: %s", (Object)union);
            Preconditions.checkArgument(options.size() == 2, "Cannot create writer for non-option union: %s", (Object)union);
            if (union.getTypes().get(0).getType() == Schema.Type.NULL) {
                return ValueWriters.option(0, options.get(1));
            }
            return ValueWriters.option(1, options.get(0));
        }

        @Override
        public ValueWriter<?> array(org.apache.iceberg.shaded.org.apache.avro.Schema array, ValueWriter<?> elementWriter) {
            LogicalType logical = array.getLogicalType();
            if (logical != null && "map".equals(logical.getName())) {
                int keyFieldId = AvroSchemaUtil.getFieldId(array.getElementType().getField("key"));
                Type keyType = this.schema.findType(keyFieldId);
                int valueFieldId = AvroSchemaUtil.getFieldId(array.getElementType().getField("value"));
                Type valueType = this.schema.findType(valueFieldId);
                ValueWriter<?>[] writers = ((SparkValueWriters.StructWriter)elementWriter).writers();
                return SparkValueWriters.arrayMap(writers[0], SparkSchemaUtil.convert(keyType), writers[1], SparkSchemaUtil.convert(valueType));
            }
            Type elementType = this.schema.findType(AvroSchemaUtil.getElementId(array));
            return SparkValueWriters.array(elementWriter, SparkSchemaUtil.convert(elementType));
        }

        @Override
        public ValueWriter<?> map(org.apache.iceberg.shaded.org.apache.avro.Schema map, ValueWriter<?> valueReader) {
            Type keyType = this.schema.findType(AvroSchemaUtil.getKeyId(map));
            Type valueType = this.schema.findType(AvroSchemaUtil.getValueId(map));
            ValueWriter<UTF8String> writer = SparkValueWriters.strings();
            return SparkValueWriters.map(writer, SparkSchemaUtil.convert(keyType), valueReader, SparkSchemaUtil.convert(valueType));
        }

        @Override
        public ValueWriter<?> primitive(org.apache.iceberg.shaded.org.apache.avro.Schema primitive) {
            LogicalType logicalType = primitive.getLogicalType();
            if (logicalType != null) {
                switch (logicalType.getName()) {
                    case "date": {
                        return ValueWriters.ints();
                    }
                    case "timestamp-micros": {
                        return ValueWriters.longs();
                    }
                    case "decimal": {
                        LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                        return SparkValueWriters.decimal(decimal.getPrecision(), decimal.getScale());
                    }
                    case "uuid": {
                        return ValueWriters.uuids();
                    }
                }
                throw new IllegalArgumentException("Unsupported logical type: " + logicalType);
            }
            switch (primitive.getType()) {
                case NULL: {
                    return ValueWriters.nulls();
                }
                case BOOLEAN: {
                    return ValueWriters.booleans();
                }
                case INT: {
                    return ValueWriters.ints();
                }
                case LONG: {
                    return ValueWriters.longs();
                }
                case FLOAT: {
                    return ValueWriters.floats();
                }
                case DOUBLE: {
                    return ValueWriters.doubles();
                }
                case STRING: {
                    return SparkValueWriters.strings();
                }
                case FIXED: {
                    return ValueWriters.fixed(primitive.getFixedSize());
                }
                case BYTES: {
                    return ValueWriters.bytes();
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + primitive);
        }
    }
}

