/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.sql.Timestamp;
import java.util.List;
import org.apache.iceberg.Schema;
import org.apache.iceberg.orc.ColumnIdMap;
import org.apache.iceberg.orc.OrcValueReader;
import org.apache.iceberg.orc.TypeConversion;
import org.apache.iceberg.shaded.org.apache.orc.TypeDescription;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.BytesColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.DecimalColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.DoubleColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.ListColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.LongColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.MapColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.StructColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.TimestampColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;
import org.apache.iceberg.shaded.org.apache.orc.storage.serde2.io.DateWritable;
import org.apache.iceberg.shaded.org.apache.orc.storage.serde2.io.HiveDecimalWritable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeArrayWriter;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowWriter;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeWriter;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.Platform;
import scala.math.BigDecimal;

public class SparkOrcReader
implements OrcValueReader<InternalRow> {
    private static final int INITIAL_SIZE = 131072;
    private final int numFields;
    private final TypeDescription readSchema;
    private final Converter[] converters;

    public SparkOrcReader(Schema readSchema) {
        this.readSchema = TypeConversion.toOrc(readSchema, new ColumnIdMap());
        this.numFields = readSchema.columns().size();
        this.converters = this.buildConverters();
    }

    private Converter[] buildConverters() {
        Converter[] newConverters = new Converter[this.numFields];
        for (int c = 0; c < this.numFields; ++c) {
            newConverters[c] = SparkOrcReader.buildConverter(this.readSchema.getChildren().get(c));
        }
        return newConverters;
    }

    @Override
    public InternalRow read(VectorizedRowBatch batch, int row) {
        UnsafeRowWriter rowWriter = new UnsafeRowWriter(this.numFields, 131072);
        rowWriter.reset();
        rowWriter.zeroOutNullBytes();
        for (int c = 0; c < batch.cols.length; ++c) {
            this.converters[c].convert(rowWriter, c, batch.cols[c], row);
        }
        return rowWriter.getRow();
    }

    private static String rowToString(SpecializedGetters row, TypeDescription schema) {
        List<TypeDescription> children = schema.getChildren();
        StringBuilder rowBuilder = new StringBuilder("{");
        for (int c = 0; c < children.size(); ++c) {
            rowBuilder.append("\"");
            rowBuilder.append(schema.getFieldNames().get(c));
            rowBuilder.append("\": ");
            rowBuilder.append(SparkOrcReader.rowEntryToString(row, c, children.get(c)));
            if (c == children.size() - 1) continue;
            rowBuilder.append(", ");
        }
        rowBuilder.append("}");
        return rowBuilder.toString();
    }

    private static String rowEntryToString(SpecializedGetters row, int ord, TypeDescription schema) {
        switch (schema.getCategory()) {
            case BOOLEAN: {
                return Boolean.toString(row.getBoolean(ord));
            }
            case BYTE: {
                return Byte.toString(row.getByte(ord));
            }
            case SHORT: {
                return Short.toString(row.getShort(ord));
            }
            case INT: {
                return Integer.toString(row.getInt(ord));
            }
            case LONG: {
                return Long.toString(row.getLong(ord));
            }
            case FLOAT: {
                return Float.toString(row.getFloat(ord));
            }
            case DOUBLE: {
                return Double.toString(row.getDouble(ord));
            }
            case CHAR: 
            case VARCHAR: 
            case STRING: {
                return "\"" + row.getUTF8String(ord) + "\"";
            }
            case BINARY: {
                StringBuilder binStr;
                byte[] bin = row.getBinary(ord);
                if (bin == null) {
                    binStr = new StringBuilder("null");
                } else {
                    binStr = new StringBuilder("[");
                    for (int i = 0; i < bin.length; ++i) {
                        int value;
                        if (i != 0) {
                            binStr.append(", ");
                        }
                        if ((value = bin[i] & 0xFF) < 16) {
                            binStr.append("0");
                            binStr.append(Integer.toHexString(value));
                            continue;
                        }
                        binStr.append(Integer.toHexString(value));
                    }
                    binStr.append("]");
                }
                return binStr.toString();
            }
            case DECIMAL: {
                return row.getDecimal(ord, schema.getPrecision(), schema.getScale()).toString();
            }
            case DATE: {
                return "\"" + new DateWritable(row.getInt(ord)) + "\"";
            }
            case TIMESTAMP: {
                return "\"" + new Timestamp(row.getLong(ord)) + "\"";
            }
            case STRUCT: {
                return SparkOrcReader.rowToString((SpecializedGetters)row.getStruct(ord, schema.getChildren().size()), schema);
            }
            case LIST: {
                TypeDescription child = schema.getChildren().get(0);
                StringBuilder listStr = new StringBuilder("[");
                ArrayData list = row.getArray(ord);
                for (int e = 0; e < list.numElements(); ++e) {
                    if (e != 0) {
                        listStr.append(", ");
                    }
                    listStr.append(SparkOrcReader.rowEntryToString((SpecializedGetters)list, e, child));
                }
                listStr.append("]");
                return listStr.toString();
            }
            case MAP: {
                TypeDescription keyType = schema.getChildren().get(0);
                TypeDescription valueType = schema.getChildren().get(1);
                MapData map = row.getMap(ord);
                ArrayData keys = map.keyArray();
                ArrayData values = map.valueArray();
                StringBuilder mapStr = new StringBuilder("[");
                for (int e = 0; e < map.numElements(); ++e) {
                    if (e != 0) {
                        mapStr.append(", ");
                    }
                    mapStr.append(SparkOrcReader.rowEntryToString((SpecializedGetters)keys, e, keyType));
                    mapStr.append(": ");
                    mapStr.append(SparkOrcReader.rowEntryToString((SpecializedGetters)values, e, valueType));
                }
                mapStr.append("]");
                return mapStr.toString();
            }
        }
        throw new IllegalArgumentException("Unhandled type " + schema);
    }

    private static int getArrayElementSize(TypeDescription type) {
        switch (type.getCategory()) {
            case BOOLEAN: 
            case BYTE: {
                return 1;
            }
            case SHORT: {
                return 2;
            }
            case INT: 
            case FLOAT: {
                return 4;
            }
        }
        return 8;
    }

    static Converter buildConverter(TypeDescription schema) {
        switch (schema.getCategory()) {
            case BOOLEAN: {
                return new BooleanConverter();
            }
            case BYTE: {
                return new ByteConverter();
            }
            case SHORT: {
                return new ShortConverter();
            }
            case INT: 
            case DATE: {
                return new IntConverter();
            }
            case LONG: {
                return new LongConverter();
            }
            case FLOAT: {
                return new FloatConverter();
            }
            case DOUBLE: {
                return new DoubleConverter();
            }
            case TIMESTAMP: {
                return new TimestampConverter();
            }
            case DECIMAL: {
                if (schema.getPrecision() <= Decimal.MAX_LONG_DIGITS()) {
                    return new Decimal18Converter(schema.getPrecision(), schema.getScale());
                }
                return new Decimal38Converter(schema.getPrecision(), schema.getScale());
            }
            case CHAR: 
            case VARCHAR: 
            case STRING: 
            case BINARY: {
                return new BinaryConverter();
            }
            case STRUCT: {
                return new StructConverter(schema);
            }
            case LIST: {
                return new ListConverter(schema);
            }
            case MAP: {
                return new MapConverter(schema);
            }
        }
        throw new IllegalArgumentException("Unhandled type " + schema);
    }

    private static class MapConverter
    implements Converter {
        private static final int KEY_SIZE_BYTES = 8;
        private final Converter keyConvert;
        private final Converter valueConvert;
        private final int keySize;
        private final int valueSize;

        MapConverter(TypeDescription schema) {
            TypeDescription keyType = schema.getChildren().get(0);
            TypeDescription valueType = schema.getChildren().get(1);
            this.keyConvert = SparkOrcReader.buildConverter(keyType);
            this.keySize = SparkOrcReader.getArrayElementSize(keyType);
            this.valueConvert = SparkOrcReader.buildConverter(valueType);
            this.valueSize = SparkOrcReader.getArrayElementSize(valueType);
        }

        int writeMap(UnsafeWriter parentWriter, MapColumnVector vector, int row) {
            int offset = (int)vector.offsets[row];
            int length = (int)vector.lengths[row];
            UnsafeArrayWriter keyWriter = new UnsafeArrayWriter(parentWriter, this.keySize);
            int start = keyWriter.cursor();
            keyWriter.grow(8);
            keyWriter.increaseCursor(8);
            keyWriter.initialize(length);
            for (int c = 0; c < length; ++c) {
                this.keyConvert.convert(keyWriter, c, vector.keys, offset + c);
            }
            Platform.putLong((Object)keyWriter.getBuffer(), (long)start, (long)(keyWriter.cursor() - start - 8));
            UnsafeArrayWriter valueWriter = new UnsafeArrayWriter(parentWriter, this.valueSize);
            valueWriter.initialize(length);
            for (int c = 0; c < length; ++c) {
                this.valueConvert.convert(valueWriter, c, vector.values, offset + c);
            }
            return start;
        }

        @Override
        public void convert(UnsafeRowWriter writer, int column, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNullAt(column);
            } else {
                int start = this.writeMap((UnsafeWriter)writer, (MapColumnVector)vector, rowIndex);
                writer.setOffsetAndSizeFromPreviousCursor(column, start);
            }
        }

        @Override
        public void convert(UnsafeArrayWriter writer, int element, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNull(element);
            } else {
                int start = this.writeMap((UnsafeWriter)writer, (MapColumnVector)vector, rowIndex);
                writer.setOffsetAndSizeFromPreviousCursor(element, start);
            }
        }
    }

    private static class ListConverter
    implements Converter {
        private final Converter childConverter;
        private final TypeDescription child;

        ListConverter(TypeDescription schema) {
            this.child = schema.getChildren().get(0);
            this.childConverter = SparkOrcReader.buildConverter(this.child);
        }

        int writeList(UnsafeWriter parentWriter, ListColumnVector vector, int row) {
            int offset = (int)vector.offsets[row];
            int length = (int)vector.lengths[row];
            UnsafeArrayWriter childWriter = new UnsafeArrayWriter(parentWriter, SparkOrcReader.getArrayElementSize(this.child));
            int start = childWriter.cursor();
            childWriter.initialize(length);
            for (int c = 0; c < length; ++c) {
                this.childConverter.convert(childWriter, c, vector.child, offset + c);
            }
            return start;
        }

        @Override
        public void convert(UnsafeRowWriter writer, int column, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNullAt(column);
            } else {
                int start = this.writeList((UnsafeWriter)writer, (ListColumnVector)vector, rowIndex);
                writer.setOffsetAndSizeFromPreviousCursor(column, start);
            }
        }

        @Override
        public void convert(UnsafeArrayWriter writer, int element, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNull(element);
            } else {
                int start = this.writeList((UnsafeWriter)writer, (ListColumnVector)vector, rowIndex);
                writer.setOffsetAndSizeFromPreviousCursor(element, start);
            }
        }
    }

    private static class StructConverter
    implements Converter {
        private final Converter[] children;

        StructConverter(TypeDescription schema) {
            this.children = new Converter[schema.getChildren().size()];
            for (int c = 0; c < this.children.length; ++c) {
                this.children[c] = SparkOrcReader.buildConverter(schema.getChildren().get(c));
            }
        }

        int writeStruct(UnsafeWriter parentWriter, StructColumnVector vector, int row) {
            UnsafeRowWriter childWriter = new UnsafeRowWriter(parentWriter, this.children.length);
            int start = childWriter.cursor();
            childWriter.resetRowWriter();
            for (int c = 0; c < this.children.length; ++c) {
                this.children[c].convert(childWriter, c, vector.fields[c], row);
            }
            return start;
        }

        @Override
        public void convert(UnsafeRowWriter writer, int column, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNullAt(column);
            } else {
                int start = this.writeStruct((UnsafeWriter)writer, (StructColumnVector)vector, rowIndex);
                writer.setOffsetAndSizeFromPreviousCursor(column, start);
            }
        }

        @Override
        public void convert(UnsafeArrayWriter writer, int element, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNull(element);
            } else {
                int start = this.writeStruct((UnsafeWriter)writer, (StructColumnVector)vector, rowIndex);
                writer.setOffsetAndSizeFromPreviousCursor(element, start);
            }
        }
    }

    private static class Decimal38Converter
    implements Converter {
        private final int precision;
        private final int scale;

        Decimal38Converter(int precision, int scale) {
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        public void convert(UnsafeRowWriter writer, int column, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNullAt(column);
            } else {
                java.math.BigDecimal value = ((DecimalColumnVector)vector).vector[rowIndex].getHiveDecimal().bigDecimalValue();
                writer.write(column, new Decimal().set(new BigDecimal(value), this.precision, this.scale), this.precision, this.scale);
            }
        }

        @Override
        public void convert(UnsafeArrayWriter writer, int element, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNull(element);
            } else {
                java.math.BigDecimal value = ((DecimalColumnVector)vector).vector[rowIndex].getHiveDecimal().bigDecimalValue();
                writer.write(element, new Decimal().set(new BigDecimal(value), this.precision, this.scale), this.precision, this.scale);
            }
        }
    }

    private static class Decimal18Converter
    implements Converter {
        private final int precision;
        private final int scale;

        Decimal18Converter(int precision, int scale) {
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        public void convert(UnsafeRowWriter writer, int column, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNullAt(column);
            } else {
                HiveDecimalWritable value = ((DecimalColumnVector)vector).vector[rowIndex];
                writer.write(column, new Decimal().set(value.serialize64(value.scale()), value.precision(), value.scale()), this.precision, this.scale);
            }
        }

        @Override
        public void convert(UnsafeArrayWriter writer, int element, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNull(element);
            } else {
                HiveDecimalWritable value = ((DecimalColumnVector)vector).vector[rowIndex];
                writer.write(element, new Decimal().set(value.serialize64(value.scale()), value.precision(), value.scale()), this.precision, this.scale);
            }
        }
    }

    private static class BinaryConverter
    implements Converter {
        private BinaryConverter() {
        }

        @Override
        public void convert(UnsafeRowWriter writer, int column, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNullAt(column);
            } else {
                BytesColumnVector bytesVector = (BytesColumnVector)vector;
                writer.write(column, bytesVector.vector[rowIndex], bytesVector.start[rowIndex], bytesVector.length[rowIndex]);
            }
        }

        @Override
        public void convert(UnsafeArrayWriter writer, int element, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNull(element);
            } else {
                BytesColumnVector v = (BytesColumnVector)vector;
                writer.write(element, v.vector[rowIndex], v.start[rowIndex], v.length[rowIndex]);
            }
        }
    }

    private static class TimestampConverter
    implements Converter {
        private TimestampConverter() {
        }

        private long convert(TimestampColumnVector vector, int row) {
            return vector.time[row] / 1000L * 1000000L + (long)(vector.nanos[row] / 1000);
        }

        @Override
        public void convert(UnsafeRowWriter writer, int column, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNullAt(column);
            } else {
                writer.write(column, this.convert((TimestampColumnVector)vector, rowIndex));
            }
        }

        @Override
        public void convert(UnsafeArrayWriter writer, int element, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNull(element);
            } else {
                writer.write(element, this.convert((TimestampColumnVector)vector, rowIndex));
            }
        }
    }

    private static class DoubleConverter
    implements Converter {
        private DoubleConverter() {
        }

        @Override
        public void convert(UnsafeRowWriter writer, int column, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNullAt(column);
            } else {
                writer.write(column, ((DoubleColumnVector)vector).vector[rowIndex]);
            }
        }

        @Override
        public void convert(UnsafeArrayWriter writer, int element, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNull(element);
            } else {
                writer.write(element, ((DoubleColumnVector)vector).vector[rowIndex]);
            }
        }
    }

    private static class FloatConverter
    implements Converter {
        private FloatConverter() {
        }

        @Override
        public void convert(UnsafeRowWriter writer, int column, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNullAt(column);
            } else {
                writer.write(column, (float)((DoubleColumnVector)vector).vector[rowIndex]);
            }
        }

        @Override
        public void convert(UnsafeArrayWriter writer, int element, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNull(element);
            } else {
                writer.write(element, (float)((DoubleColumnVector)vector).vector[rowIndex]);
            }
        }
    }

    private static class LongConverter
    implements Converter {
        private LongConverter() {
        }

        @Override
        public void convert(UnsafeRowWriter writer, int column, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNullAt(column);
            } else {
                writer.write(column, ((LongColumnVector)vector).vector[rowIndex]);
            }
        }

        @Override
        public void convert(UnsafeArrayWriter writer, int element, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNull(element);
            } else {
                writer.write(element, ((LongColumnVector)vector).vector[rowIndex]);
            }
        }
    }

    private static class IntConverter
    implements Converter {
        private IntConverter() {
        }

        @Override
        public void convert(UnsafeRowWriter writer, int column, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNullAt(column);
            } else {
                writer.write(column, (int)((LongColumnVector)vector).vector[rowIndex]);
            }
        }

        @Override
        public void convert(UnsafeArrayWriter writer, int element, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNull(element);
            } else {
                writer.write(element, (int)((LongColumnVector)vector).vector[rowIndex]);
            }
        }
    }

    private static class ShortConverter
    implements Converter {
        private ShortConverter() {
        }

        @Override
        public void convert(UnsafeRowWriter writer, int column, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNullAt(column);
            } else {
                writer.write(column, (short)((LongColumnVector)vector).vector[rowIndex]);
            }
        }

        @Override
        public void convert(UnsafeArrayWriter writer, int element, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNull(element);
            } else {
                writer.write(element, (short)((LongColumnVector)vector).vector[rowIndex]);
            }
        }
    }

    private static class ByteConverter
    implements Converter {
        private ByteConverter() {
        }

        @Override
        public void convert(UnsafeRowWriter writer, int column, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNullAt(column);
            } else {
                writer.write(column, (byte)((LongColumnVector)vector).vector[rowIndex]);
            }
        }

        @Override
        public void convert(UnsafeArrayWriter writer, int element, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNull(element);
            } else {
                writer.write(element, (byte)((LongColumnVector)vector).vector[rowIndex]);
            }
        }
    }

    private static class BooleanConverter
    implements Converter {
        private BooleanConverter() {
        }

        @Override
        public void convert(UnsafeRowWriter writer, int column, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNullAt(column);
            } else {
                writer.write(column, ((LongColumnVector)vector).vector[rowIndex] != 0L);
            }
        }

        @Override
        public void convert(UnsafeArrayWriter writer, int element, ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                writer.setNull(element);
            } else {
                writer.write(element, ((LongColumnVector)vector).vector[rowIndex] != 0L);
            }
        }
    }

    static interface Converter {
        public void convert(UnsafeRowWriter var1, int var2, ColumnVector var3, int var4);

        public void convert(UnsafeArrayWriter var1, int var2, ColumnVector var3, int var4);
    }
}

