/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.util.List;
import org.apache.iceberg.orc.OrcValueWriter;
import org.apache.iceberg.shaded.org.apache.orc.TypeDescription;
import org.apache.iceberg.shaded.org.apache.orc.storage.common.type.HiveDecimal;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.BytesColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.DecimalColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.DoubleColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.ListColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.LongColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.MapColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.StructColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.TimestampColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;

public class SparkOrcWriter
implements OrcValueWriter<InternalRow> {
    private final Converter[] converters;

    public SparkOrcWriter(TypeDescription schema) {
        this.converters = SparkOrcWriter.buildConverters(schema);
    }

    @Override
    public void write(InternalRow value, VectorizedRowBatch output) {
        int row = output.size++;
        for (int c = 0; c < this.converters.length; ++c) {
            this.converters[c].addValue(row, c, (SpecializedGetters)value, output.cols[c]);
        }
    }

    private static Converter buildConverter(TypeDescription schema) {
        switch (schema.getCategory()) {
            case BOOLEAN: {
                return new BooleanConverter();
            }
            case BYTE: {
                return new ByteConverter();
            }
            case SHORT: {
                return new ShortConverter();
            }
            case DATE: 
            case INT: {
                return new IntConverter();
            }
            case LONG: {
                return new LongConverter();
            }
            case FLOAT: {
                return new FloatConverter();
            }
            case DOUBLE: {
                return new DoubleConverter();
            }
            case BINARY: {
                return new BytesConverter();
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new StringConverter();
            }
            case DECIMAL: {
                return schema.getPrecision() <= 18 ? new Decimal18Converter(schema) : new Decimal38Converter(schema);
            }
            case TIMESTAMP: {
                return new TimestampConverter();
            }
            case STRUCT: {
                return new StructConverter(schema);
            }
            case LIST: {
                return new ListConverter(schema);
            }
            case MAP: {
                return new MapConverter(schema);
            }
        }
        throw new IllegalArgumentException("Unhandled type " + schema);
    }

    private static Converter[] buildConverters(TypeDescription schema) {
        if (schema.getCategory() != TypeDescription.Category.STRUCT) {
            throw new IllegalArgumentException("Top level must be a struct " + schema);
        }
        List<TypeDescription> children = schema.getChildren();
        Converter[] result = new Converter[children.size()];
        for (int c = 0; c < children.size(); ++c) {
            result[c] = SparkOrcWriter.buildConverter(children.get(c));
        }
        return result;
    }

    static class MapConverter
    implements Converter {
        private final Converter keyConverter;
        private final Converter valueConverter;

        MapConverter(TypeDescription schema) {
            this.keyConverter = SparkOrcWriter.buildConverter(schema.getChildren().get(0));
            this.valueConverter = SparkOrcWriter.buildConverter(schema.getChildren().get(1));
        }

        @Override
        public void addValue(int rowId, int column, SpecializedGetters data, ColumnVector output) {
            if (data.isNullAt(column)) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                MapData map = data.getMap(column);
                ArrayData key = map.keyArray();
                ArrayData value = map.valueArray();
                MapColumnVector cv = (MapColumnVector)output;
                cv.lengths[rowId] = value.numElements();
                cv.offsets[rowId] = cv.childCount;
                cv.childCount = (int)((long)cv.childCount + cv.lengths[rowId]);
                cv.keys.ensureSize(cv.childCount, true);
                cv.values.ensureSize(cv.childCount, true);
                int e = 0;
                while ((long)e < cv.lengths[rowId]) {
                    int pos = (int)((long)e + cv.offsets[rowId]);
                    this.keyConverter.addValue(pos, e, (SpecializedGetters)key, cv.keys);
                    this.valueConverter.addValue(pos, e, (SpecializedGetters)value, cv.values);
                    ++e;
                }
            }
        }
    }

    static class ListConverter
    implements Converter {
        private final Converter children;

        ListConverter(TypeDescription schema) {
            this.children = SparkOrcWriter.buildConverter(schema.getChildren().get(0));
        }

        @Override
        public void addValue(int rowId, int column, SpecializedGetters data, ColumnVector output) {
            if (data.isNullAt(column)) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                ArrayData value = data.getArray(column);
                ListColumnVector cv = (ListColumnVector)output;
                cv.lengths[rowId] = value.numElements();
                cv.offsets[rowId] = cv.childCount;
                cv.childCount = (int)((long)cv.childCount + cv.lengths[rowId]);
                cv.child.ensureSize(cv.childCount, true);
                int e = 0;
                while ((long)e < cv.lengths[rowId]) {
                    this.children.addValue((int)((long)e + cv.offsets[rowId]), e, (SpecializedGetters)value, cv.child);
                    ++e;
                }
            }
        }
    }

    static class StructConverter
    implements Converter {
        private final Converter[] children;

        StructConverter(TypeDescription schema) {
            this.children = new Converter[schema.getChildren().size()];
            for (int c = 0; c < this.children.length; ++c) {
                this.children[c] = SparkOrcWriter.buildConverter(schema.getChildren().get(c));
            }
        }

        @Override
        public void addValue(int rowId, int column, SpecializedGetters data, ColumnVector output) {
            if (data.isNullAt(column)) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                InternalRow value = data.getStruct(column, this.children.length);
                StructColumnVector cv = (StructColumnVector)output;
                for (int c = 0; c < this.children.length; ++c) {
                    this.children[c].addValue(rowId, c, (SpecializedGetters)value, cv.fields[c]);
                }
            }
        }
    }

    static class Decimal38Converter
    implements Converter {
        private final int precision;
        private final int scale;

        Decimal38Converter(TypeDescription schema) {
            this.precision = schema.getPrecision();
            this.scale = schema.getScale();
        }

        @Override
        public void addValue(int rowId, int column, SpecializedGetters data, ColumnVector output) {
            if (data.isNullAt(column)) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                ((DecimalColumnVector)output).vector[rowId].set(HiveDecimal.create(data.getDecimal(column, this.precision, this.scale).toJavaBigDecimal()));
            }
        }
    }

    static class Decimal18Converter
    implements Converter {
        private final int precision;
        private final int scale;

        Decimal18Converter(TypeDescription schema) {
            this.precision = schema.getPrecision();
            this.scale = schema.getScale();
        }

        @Override
        public void addValue(int rowId, int column, SpecializedGetters data, ColumnVector output) {
            if (data.isNullAt(column)) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                ((DecimalColumnVector)output).vector[rowId].setFromLongAndScale(data.getDecimal(column, this.precision, this.scale).toUnscaledLong(), this.scale);
            }
        }
    }

    static class TimestampConverter
    implements Converter {
        TimestampConverter() {
        }

        @Override
        public void addValue(int rowId, int column, SpecializedGetters data, ColumnVector output) {
            if (data.isNullAt(column)) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                TimestampColumnVector cv = (TimestampColumnVector)output;
                long micros = data.getLong(column);
                cv.time[rowId] = micros / 1000000L * 1000L;
                int nanos = (int)(micros % 1000000L) * 1000;
                if (nanos < 0) {
                    nanos += 1000000000;
                    int n = rowId;
                    cv.time[n] = cv.time[n] - 1000L;
                }
                cv.nanos[rowId] = nanos;
            }
        }
    }

    static class BytesConverter
    implements Converter {
        BytesConverter() {
        }

        @Override
        public void addValue(int rowId, int column, SpecializedGetters data, ColumnVector output) {
            if (data.isNullAt(column)) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                byte[] value = data.getBinary(column);
                ((BytesColumnVector)output).setRef(rowId, value, 0, value.length);
            }
        }
    }

    static class StringConverter
    implements Converter {
        StringConverter() {
        }

        @Override
        public void addValue(int rowId, int column, SpecializedGetters data, ColumnVector output) {
            if (data.isNullAt(column)) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                byte[] value = data.getUTF8String(column).getBytes();
                ((BytesColumnVector)output).setRef(rowId, value, 0, value.length);
            }
        }
    }

    static class DoubleConverter
    implements Converter {
        DoubleConverter() {
        }

        @Override
        public void addValue(int rowId, int column, SpecializedGetters data, ColumnVector output) {
            if (data.isNullAt(column)) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                ((DoubleColumnVector)output).vector[rowId] = data.getDouble(column);
            }
        }
    }

    static class FloatConverter
    implements Converter {
        FloatConverter() {
        }

        @Override
        public void addValue(int rowId, int column, SpecializedGetters data, ColumnVector output) {
            if (data.isNullAt(column)) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                ((DoubleColumnVector)output).vector[rowId] = data.getFloat(column);
            }
        }
    }

    static class LongConverter
    implements Converter {
        LongConverter() {
        }

        @Override
        public void addValue(int rowId, int column, SpecializedGetters data, ColumnVector output) {
            if (data.isNullAt(column)) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                ((LongColumnVector)output).vector[rowId] = data.getLong(column);
            }
        }
    }

    static class IntConverter
    implements Converter {
        IntConverter() {
        }

        @Override
        public void addValue(int rowId, int column, SpecializedGetters data, ColumnVector output) {
            if (data.isNullAt(column)) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                ((LongColumnVector)output).vector[rowId] = data.getInt(column);
            }
        }
    }

    static class ShortConverter
    implements Converter {
        ShortConverter() {
        }

        @Override
        public void addValue(int rowId, int column, SpecializedGetters data, ColumnVector output) {
            if (data.isNullAt(column)) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                ((LongColumnVector)output).vector[rowId] = data.getShort(column);
            }
        }
    }

    static class ByteConverter
    implements Converter {
        ByteConverter() {
        }

        @Override
        public void addValue(int rowId, int column, SpecializedGetters data, ColumnVector output) {
            if (data.isNullAt(column)) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                ((LongColumnVector)output).vector[rowId] = data.getByte(column);
            }
        }
    }

    static class BooleanConverter
    implements Converter {
        BooleanConverter() {
        }

        @Override
        public void addValue(int rowId, int column, SpecializedGetters data, ColumnVector output) {
            if (data.isNullAt(column)) {
                output.noNulls = false;
                output.isNull[rowId] = true;
            } else {
                output.isNull[rowId] = false;
                ((LongColumnVector)output).vector[rowId] = data.getBoolean(column) ? 1L : 0L;
            }
        }
    }

    static interface Converter {
        public void addValue(int var1, int var2, SpecializedGetters var3, ColumnVector var4);
    }
}

