/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.iceberg.Schema;
import org.apache.iceberg.parquet.ParquetTypeVisitor;
import org.apache.iceberg.parquet.ParquetValueReaders;
import org.apache.iceberg.parquet.ParquetValueWriter;
import org.apache.iceberg.parquet.ParquetValueWriters;
import org.apache.iceberg.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.shaded.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.org.apache.parquet.column.ColumnDescriptor;
import org.apache.iceberg.shaded.org.apache.parquet.io.api.Binary;
import org.apache.iceberg.shaded.org.apache.parquet.schema.DecimalMetadata;
import org.apache.iceberg.shaded.org.apache.parquet.schema.GroupType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.MessageType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.PrimitiveType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.Type;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.types.TypeUtil;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.types.UTF8String;

public class SparkParquetWriters {
    private SparkParquetWriters() {
    }

    public static <T> ParquetValueWriter<T> buildWriter(Schema schema, MessageType type) {
        return (ParquetValueWriter)ParquetTypeVisitor.visit(type, new WriteBuilder(schema, type));
    }

    private static ParquetValueWriters.PrimitiveWriter<UTF8String> utf8Strings(ColumnDescriptor desc) {
        return new UTF8StringWriter(desc);
    }

    private static ParquetValueWriters.PrimitiveWriter<Decimal> decimalAsInteger(ColumnDescriptor desc, int precision, int scale) {
        return new IntegerDecimalWriter(desc, precision, scale);
    }

    private static ParquetValueWriters.PrimitiveWriter<Decimal> decimalAsLong(ColumnDescriptor desc, int precision, int scale) {
        return new LongDecimalWriter(desc, precision, scale);
    }

    private static ParquetValueWriters.PrimitiveWriter<Decimal> decimalAsFixed(ColumnDescriptor desc, int precision, int scale) {
        return new FixedDecimalWriter(desc, precision, scale);
    }

    private static ParquetValueWriters.PrimitiveWriter<byte[]> byteArrays(ColumnDescriptor desc) {
        return new ByteArrayWriter(desc);
    }

    private static class InternalRowWriter
    extends ParquetValueWriters.StructWriter<InternalRow> {
        private final DataType[] types;

        private InternalRowWriter(List<ParquetValueWriter<?>> writers, List<DataType> types) {
            super(writers);
            this.types = types.toArray(new DataType[types.size()]);
        }

        @Override
        protected Object get(InternalRow struct, int index) {
            return struct.get(index, this.types[index]);
        }
    }

    private static class MapDataWriter<K, V>
    extends ParquetValueWriters.RepeatedKeyValueWriter<MapData, K, V> {
        private final DataType keyType;
        private final DataType valueType;

        private MapDataWriter(int definitionLevel, int repetitionLevel, ParquetValueWriter<K> keyWriter, ParquetValueWriter<V> valueWriter, DataType keyType, DataType valueType) {
            super(definitionLevel, repetitionLevel, keyWriter, valueWriter);
            this.keyType = keyType;
            this.valueType = valueType;
        }

        @Override
        protected Iterator<Map.Entry<K, V>> pairs(MapData map) {
            return new EntryIterator(map);
        }

        private class EntryIterator<K, V>
        implements Iterator<Map.Entry<K, V>> {
            private final int size;
            private final ArrayData keys;
            private final ArrayData values;
            private final ParquetValueReaders.ReusableEntry<K, V> entry;
            private final MapData map;
            private int index;

            private EntryIterator(MapData map) {
                this.map = map;
                this.size = map.numElements();
                this.keys = map.keyArray();
                this.values = map.valueArray();
                this.entry = new ParquetValueReaders.ReusableEntry();
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.index != this.size;
            }

            @Override
            public Map.Entry<K, V> next() {
                if (this.index >= this.size) {
                    throw new NoSuchElementException();
                }
                if (this.values.isNullAt(this.index)) {
                    this.entry.set(this.keys.get(this.index, MapDataWriter.this.keyType), null);
                } else {
                    this.entry.set(this.keys.get(this.index, MapDataWriter.this.keyType), this.values.get(this.index, MapDataWriter.this.valueType));
                }
                ++this.index;
                return this.entry;
            }
        }
    }

    private static class ArrayDataWriter<E>
    extends ParquetValueWriters.RepeatedWriter<ArrayData, E> {
        private final DataType elementType;

        private ArrayDataWriter(int definitionLevel, int repetitionLevel, ParquetValueWriter<E> writer, DataType elementType) {
            super(definitionLevel, repetitionLevel, writer);
            this.elementType = elementType;
        }

        @Override
        protected Iterator<E> elements(ArrayData list) {
            return new ElementIterator(list);
        }

        private class ElementIterator<E>
        implements Iterator<E> {
            private final int size;
            private final ArrayData list;
            private int index;

            private ElementIterator(ArrayData list) {
                this.list = list;
                this.size = list.numElements();
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.index != this.size;
            }

            @Override
            public E next() {
                if (this.index >= this.size) {
                    throw new NoSuchElementException();
                }
                Object element = this.list.isNullAt(this.index) ? null : this.list.get(this.index, ArrayDataWriter.this.elementType);
                ++this.index;
                return (E)element;
            }
        }
    }

    private static class ByteArrayWriter
    extends ParquetValueWriters.PrimitiveWriter<byte[]> {
        private ByteArrayWriter(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public void write(int repetitionLevel, byte[] bytes) {
            this.column.writeBinary(repetitionLevel, Binary.fromReusedByteArray(bytes));
        }
    }

    private static class FixedDecimalWriter
    extends ParquetValueWriters.PrimitiveWriter<Decimal> {
        private final int precision;
        private final int scale;
        private final int length;
        private final ThreadLocal<byte[]> bytes;

        private FixedDecimalWriter(ColumnDescriptor desc, int precision, int scale) {
            super(desc);
            this.precision = precision;
            this.scale = scale;
            this.length = TypeUtil.decimalRequriedBytes(precision);
            this.bytes = ThreadLocal.withInitial(() -> new byte[this.length]);
        }

        @Override
        public void write(int repetitionLevel, Decimal decimal) {
            Preconditions.checkArgument(decimal.scale() == this.scale, "Cannot write value as decimal(%s,%s), wrong scale: %s", (Object)this.precision, (Object)this.scale, (Object)decimal);
            Preconditions.checkArgument(decimal.precision() <= this.precision, "Cannot write value as decimal(%s,%s), too large: %s", (Object)this.precision, (Object)this.scale, (Object)decimal);
            BigDecimal bigDecimal = decimal.toJavaBigDecimal();
            byte fillByte = (byte)(bigDecimal.signum() < 0 ? 255 : 0);
            byte[] unscaled = bigDecimal.unscaledValue().toByteArray();
            byte[] buf = this.bytes.get();
            int offset = this.length - unscaled.length;
            for (int i = 0; i < this.length; ++i) {
                buf[i] = i < offset ? fillByte : unscaled[i - offset];
            }
            this.column.writeBinary(repetitionLevel, Binary.fromReusedByteArray(buf));
        }
    }

    private static class LongDecimalWriter
    extends ParquetValueWriters.PrimitiveWriter<Decimal> {
        private final int precision;
        private final int scale;

        private LongDecimalWriter(ColumnDescriptor desc, int precision, int scale) {
            super(desc);
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        public void write(int repetitionLevel, Decimal decimal) {
            Preconditions.checkArgument(decimal.scale() == this.scale, "Cannot write value as decimal(%s,%s), wrong scale: %s", (Object)this.precision, (Object)this.scale, (Object)decimal);
            Preconditions.checkArgument(decimal.precision() <= this.precision, "Cannot write value as decimal(%s,%s), too large: %s", (Object)this.precision, (Object)this.scale, (Object)decimal);
            this.column.writeLong(repetitionLevel, decimal.toUnscaledLong());
        }
    }

    private static class IntegerDecimalWriter
    extends ParquetValueWriters.PrimitiveWriter<Decimal> {
        private final int precision;
        private final int scale;

        private IntegerDecimalWriter(ColumnDescriptor desc, int precision, int scale) {
            super(desc);
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        public void write(int repetitionLevel, Decimal decimal) {
            Preconditions.checkArgument(decimal.scale() == this.scale, "Cannot write value as decimal(%s,%s), wrong scale: %s", (Object)this.precision, (Object)this.scale, (Object)decimal);
            Preconditions.checkArgument(decimal.precision() <= this.precision, "Cannot write value as decimal(%s,%s), too large: %s", (Object)this.precision, (Object)this.scale, (Object)decimal);
            this.column.writeInteger(repetitionLevel, (int)decimal.toUnscaledLong());
        }
    }

    private static class UTF8StringWriter
    extends ParquetValueWriters.PrimitiveWriter<UTF8String> {
        private UTF8StringWriter(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public void write(int repetitionLevel, UTF8String value) {
            this.column.writeBinary(repetitionLevel, Binary.fromReusedByteArray(value.getBytes()));
        }
    }

    private static class WriteBuilder
    extends ParquetTypeVisitor<ParquetValueWriter<?>> {
        private final Schema schema;
        private final MessageType type;

        WriteBuilder(Schema schema, MessageType type) {
            this.schema = schema;
            this.type = type;
        }

        @Override
        public ParquetValueWriter<?> message(MessageType message, List<ParquetValueWriter<?>> fieldWriters) {
            return this.struct(message.asGroupType(), (List)fieldWriters);
        }

        @Override
        public ParquetValueWriter<?> struct(GroupType struct, List<ParquetValueWriter<?>> fieldWriters) {
            List<Type> fields = struct.getFields();
            ArrayList<ParquetValueWriter<?>> writers = Lists.newArrayListWithExpectedSize(fieldWriters.size());
            ArrayList<DataType> sparkTypes = Lists.newArrayList();
            for (int i = 0; i < fields.size(); ++i) {
                Type fieldType = struct.getType(i);
                int fieldD = this.type.getMaxDefinitionLevel(this.path(fieldType.getName()));
                writers.add(ParquetValueWriters.option(fieldType, fieldD, fieldWriters.get(i)));
                sparkTypes.add(SparkSchemaUtil.convert(this.schema.findType(fieldType.getId().intValue())));
            }
            return new InternalRowWriter(writers, sparkTypes);
        }

        @Override
        public ParquetValueWriter<?> list(GroupType array, ParquetValueWriter<?> elementWriter) {
            GroupType repeated = array.getFields().get(0).asGroupType();
            String[] repeatedPath = this.currentPath();
            int repeatedD = this.type.getMaxDefinitionLevel(repeatedPath);
            int repeatedR = this.type.getMaxRepetitionLevel(repeatedPath);
            Type elementType = repeated.getType(0);
            int elementD = this.type.getMaxDefinitionLevel(this.path(elementType.getName()));
            DataType elementSparkType = SparkSchemaUtil.convert(this.schema.findType(elementType.getId().intValue()));
            return new ArrayDataWriter(repeatedD, repeatedR, ParquetValueWriters.option(elementType, elementD, elementWriter), elementSparkType);
        }

        @Override
        public ParquetValueWriter<?> map(GroupType map, ParquetValueWriter<?> keyWriter, ParquetValueWriter<?> valueWriter) {
            GroupType repeatedKeyValue = map.getFields().get(0).asGroupType();
            String[] repeatedPath = this.currentPath();
            int repeatedD = this.type.getMaxDefinitionLevel(repeatedPath);
            int repeatedR = this.type.getMaxRepetitionLevel(repeatedPath);
            Type keyType = repeatedKeyValue.getType(0);
            int keyD = this.type.getMaxDefinitionLevel(this.path(keyType.getName()));
            DataType keySparkType = SparkSchemaUtil.convert(this.schema.findType(keyType.getId().intValue()));
            Type valueType = repeatedKeyValue.getType(1);
            int valueD = this.type.getMaxDefinitionLevel(this.path(valueType.getName()));
            DataType valueSparkType = SparkSchemaUtil.convert(this.schema.findType(valueType.getId().intValue()));
            return new MapDataWriter(repeatedD, repeatedR, ParquetValueWriters.option(keyType, keyD, keyWriter), ParquetValueWriters.option(valueType, valueD, valueWriter), keySparkType, valueSparkType);
        }

        @Override
        public ParquetValueWriter<?> primitive(PrimitiveType primitive) {
            ColumnDescriptor desc = this.type.getColumnDescription(this.currentPath());
            if (primitive.getOriginalType() != null) {
                switch (primitive.getOriginalType()) {
                    case ENUM: 
                    case JSON: 
                    case UTF8: {
                        return SparkParquetWriters.utf8Strings(desc);
                    }
                    case DATE: 
                    case INT_8: 
                    case INT_16: 
                    case INT_32: 
                    case INT_64: 
                    case TIME_MICROS: 
                    case TIMESTAMP_MICROS: {
                        return ParquetValueWriters.unboxed(desc);
                    }
                    case DECIMAL: {
                        DecimalMetadata decimal = primitive.getDecimalMetadata();
                        switch (primitive.getPrimitiveTypeName()) {
                            case INT32: {
                                return SparkParquetWriters.decimalAsInteger(desc, decimal.getPrecision(), decimal.getScale());
                            }
                            case INT64: {
                                return SparkParquetWriters.decimalAsLong(desc, decimal.getPrecision(), decimal.getScale());
                            }
                            case BINARY: 
                            case FIXED_LEN_BYTE_ARRAY: {
                                return SparkParquetWriters.decimalAsFixed(desc, decimal.getPrecision(), decimal.getScale());
                            }
                        }
                        throw new UnsupportedOperationException("Unsupported base type for decimal: " + (Object)((Object)primitive.getPrimitiveTypeName()));
                    }
                    case BSON: {
                        return SparkParquetWriters.byteArrays(desc);
                    }
                }
                throw new UnsupportedOperationException("Unsupported logical type: " + (Object)((Object)primitive.getOriginalType()));
            }
            switch (primitive.getPrimitiveTypeName()) {
                case BINARY: 
                case FIXED_LEN_BYTE_ARRAY: {
                    return SparkParquetWriters.byteArrays(desc);
                }
                case INT32: 
                case INT64: 
                case BOOLEAN: 
                case FLOAT: 
                case DOUBLE: {
                    return ParquetValueWriters.unboxed(desc);
                }
            }
            throw new UnsupportedOperationException("Unsupported type: " + primitive);
        }

        private String[] currentPath() {
            String[] path = new String[this.fieldNames.size()];
            if (!this.fieldNames.isEmpty()) {
                Iterator iter = this.fieldNames.descendingIterator();
                int i = 0;
                while (iter.hasNext()) {
                    path[i] = (String)iter.next();
                    ++i;
                }
            }
            return path;
        }

        private String[] path(String name) {
            String[] path = new String[this.fieldNames.size() + 1];
            path[this.fieldNames.size()] = name;
            if (!this.fieldNames.isEmpty()) {
                Iterator iter = this.fieldNames.descendingIterator();
                int i = 0;
                while (iter.hasNext()) {
                    path[i] = (String)iter.next();
                    ++i;
                }
            }
            return path;
        }
    }
}

