/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.UUID;
import org.apache.iceberg.avro.ValueReader;
import org.apache.iceberg.shaded.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.org.apache.avro.Schema;
import org.apache.iceberg.shaded.org.apache.avro.io.Decoder;
import org.apache.iceberg.shaded.org.apache.avro.io.ResolvingDecoder;
import org.apache.iceberg.shaded.org.apache.avro.util.Utf8;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.types.UTF8String;

public class SparkValueReaders {
    private SparkValueReaders() {
    }

    static ValueReader<UTF8String> strings() {
        return StringReader.INSTANCE;
    }

    static ValueReader<UTF8String> uuids() {
        return UUIDReader.INSTANCE;
    }

    static ValueReader<Decimal> decimal(ValueReader<byte[]> unscaledReader, int scale) {
        return new DecimalReader(unscaledReader, scale);
    }

    static ValueReader<ArrayData> array(ValueReader<?> elementReader) {
        return new ArrayReader(elementReader);
    }

    static ValueReader<ArrayBasedMapData> arrayMap(ValueReader<?> keyReader, ValueReader<?> valueReader) {
        return new ArrayMapReader(keyReader, valueReader);
    }

    static ValueReader<ArrayBasedMapData> map(ValueReader<?> keyReader, ValueReader<?> valueReader) {
        return new MapReader(keyReader, valueReader);
    }

    static ValueReader<InternalRow> struct(List<ValueReader<?>> readers) {
        return new StructReader(readers);
    }

    static class StructReader
    implements ValueReader<InternalRow> {
        private final ValueReader<?>[] readers;

        private StructReader(List<ValueReader<?>> readers) {
            this.readers = new ValueReader[readers.size()];
            for (int i = 0; i < this.readers.length; ++i) {
                this.readers[i] = readers.get(i);
            }
        }

        ValueReader<?>[] readers() {
            return this.readers;
        }

        @Override
        public InternalRow read(Decoder decoder, Object reuse) throws IOException {
            GenericInternalRow row = new GenericInternalRow(this.readers.length);
            if (decoder instanceof ResolvingDecoder) {
                for (Schema.Field field : ((ResolvingDecoder)decoder).readFieldOrder()) {
                    Object value = this.readers[field.pos()].read(decoder, null);
                    if (value != null) {
                        row.update(field.pos(), value);
                        continue;
                    }
                    row.setNullAt(field.pos());
                }
            } else {
                for (int i = 0; i < this.readers.length; ++i) {
                    Object value = this.readers[i].read(decoder, null);
                    if (value != null) {
                        row.update(i, value);
                        continue;
                    }
                    row.setNullAt(i);
                }
            }
            return row;
        }
    }

    private static class MapReader
    implements ValueReader<ArrayBasedMapData> {
        private final ValueReader<?> keyReader;
        private final ValueReader<?> valueReader;
        private final List<Object> reusedKeyList = Lists.newArrayList();
        private final List<Object> reusedValueList = Lists.newArrayList();

        private MapReader(ValueReader<?> keyReader, ValueReader<?> valueReader) {
            this.keyReader = keyReader;
            this.valueReader = valueReader;
        }

        @Override
        public ArrayBasedMapData read(Decoder decoder, Object reuse) throws IOException {
            this.reusedKeyList.clear();
            this.reusedValueList.clear();
            long chunkLength = decoder.readMapStart();
            while (chunkLength > 0L) {
                int i = 0;
                while ((long)i < chunkLength) {
                    this.reusedKeyList.add(this.keyReader.read(decoder, null));
                    this.reusedValueList.add(this.valueReader.read(decoder, null));
                    ++i;
                }
                chunkLength = decoder.mapNext();
            }
            return new ArrayBasedMapData((ArrayData)new GenericArrayData(this.reusedKeyList.toArray()), (ArrayData)new GenericArrayData(this.reusedValueList.toArray()));
        }
    }

    private static class ArrayMapReader
    implements ValueReader<ArrayBasedMapData> {
        private final ValueReader<?> keyReader;
        private final ValueReader<?> valueReader;
        private final List<Object> reusedKeyList = Lists.newArrayList();
        private final List<Object> reusedValueList = Lists.newArrayList();

        private ArrayMapReader(ValueReader<?> keyReader, ValueReader<?> valueReader) {
            this.keyReader = keyReader;
            this.valueReader = valueReader;
        }

        @Override
        public ArrayBasedMapData read(Decoder decoder, Object reuse) throws IOException {
            this.reusedKeyList.clear();
            this.reusedValueList.clear();
            long chunkLength = decoder.readArrayStart();
            while (chunkLength > 0L) {
                int i = 0;
                while ((long)i < chunkLength) {
                    this.reusedKeyList.add(this.keyReader.read(decoder, null));
                    this.reusedValueList.add(this.valueReader.read(decoder, null));
                    ++i;
                }
                chunkLength = decoder.arrayNext();
            }
            return new ArrayBasedMapData((ArrayData)new GenericArrayData(this.reusedKeyList.toArray()), (ArrayData)new GenericArrayData(this.reusedValueList.toArray()));
        }
    }

    private static class ArrayReader
    implements ValueReader<ArrayData> {
        private final ValueReader<?> elementReader;
        private final List<Object> reusedList = Lists.newArrayList();

        private ArrayReader(ValueReader<?> elementReader) {
            this.elementReader = elementReader;
        }

        @Override
        public GenericArrayData read(Decoder decoder, Object reuse) throws IOException {
            this.reusedList.clear();
            long chunkLength = decoder.readArrayStart();
            while (chunkLength > 0L) {
                int i = 0;
                while ((long)i < chunkLength) {
                    this.reusedList.add(this.elementReader.read(decoder, null));
                    ++i;
                }
                chunkLength = decoder.arrayNext();
            }
            return new GenericArrayData(this.reusedList.toArray());
        }
    }

    private static class DecimalReader
    implements ValueReader<Decimal> {
        private final ValueReader<byte[]> bytesReader;
        private final int scale;

        private DecimalReader(ValueReader<byte[]> bytesReader, int scale) {
            this.bytesReader = bytesReader;
            this.scale = scale;
        }

        @Override
        public Decimal read(Decoder decoder, Object reuse) throws IOException {
            byte[] bytes = this.bytesReader.read(decoder, null);
            return Decimal.apply((BigDecimal)new BigDecimal(new BigInteger(bytes), this.scale));
        }
    }

    private static class UUIDReader
    implements ValueReader<UTF8String> {
        private static final ThreadLocal<ByteBuffer> BUFFER = ThreadLocal.withInitial(() -> {
            ByteBuffer buffer = ByteBuffer.allocate(16);
            buffer.order(ByteOrder.BIG_ENDIAN);
            return buffer;
        });
        private static final UUIDReader INSTANCE = new UUIDReader();

        private UUIDReader() {
        }

        @Override
        public UTF8String read(Decoder decoder, Object reuse) throws IOException {
            ByteBuffer buffer = BUFFER.get();
            buffer.rewind();
            decoder.readFixed(buffer.array(), 0, 16);
            long mostSigBits = buffer.getLong();
            long leastSigBits = buffer.getLong();
            return UTF8String.fromString((String)new UUID(mostSigBits, leastSigBits).toString());
        }
    }

    private static class StringReader
    implements ValueReader<UTF8String> {
        private static final StringReader INSTANCE = new StringReader();

        private StringReader() {
        }

        @Override
        public UTF8String read(Decoder decoder, Object reuse) throws IOException {
            Utf8 utf8 = null;
            if (reuse instanceof UTF8String) {
                utf8 = new Utf8(((UTF8String)reuse).getBytes());
            }
            Utf8 string = decoder.readString(utf8);
            return UTF8String.fromBytes((byte[])string.getBytes(), (int)0, (int)string.getByteLength());
        }
    }
}

