/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.UUID;
import org.apache.iceberg.avro.ValueWriter;
import org.apache.iceberg.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.shaded.org.apache.avro.io.Encoder;
import org.apache.iceberg.shaded.org.apache.avro.util.Utf8;
import org.apache.iceberg.types.TypeUtil;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.types.UTF8String;

public class SparkValueWriters {
    private SparkValueWriters() {
    }

    static ValueWriter<UTF8String> strings() {
        return StringWriter.INSTANCE;
    }

    static ValueWriter<UTF8String> uuids() {
        return UUIDWriter.INSTANCE;
    }

    static ValueWriter<Decimal> decimal(int precision, int scale) {
        return new DecimalWriter(precision, scale);
    }

    static <T> ValueWriter<ArrayData> array(ValueWriter<T> elementWriter, DataType elementType) {
        return new ArrayWriter(elementWriter, elementType);
    }

    static <K, V> ValueWriter<MapData> arrayMap(ValueWriter<K> keyWriter, DataType keyType, ValueWriter<V> valueWriter, DataType valueType) {
        return new ArrayMapWriter(keyWriter, keyType, valueWriter, valueType);
    }

    static <K, V> ValueWriter<MapData> map(ValueWriter<K> keyWriter, DataType keyType, ValueWriter<V> valueWriter, DataType valueType) {
        return new MapWriter(keyWriter, keyType, valueWriter, valueType);
    }

    static ValueWriter<InternalRow> struct(List<ValueWriter<?>> writers, List<DataType> types) {
        return new StructWriter(writers, types);
    }

    static class StructWriter
    implements ValueWriter<InternalRow> {
        private final ValueWriter<?>[] writers;
        private final DataType[] types;

        private StructWriter(List<ValueWriter<?>> writers, List<DataType> types) {
            this.writers = (ValueWriter[])Array.newInstance(ValueWriter.class, writers.size());
            this.types = new DataType[writers.size()];
            for (int i = 0; i < writers.size(); ++i) {
                this.writers[i] = writers.get(i);
                this.types[i] = types.get(i);
            }
        }

        ValueWriter<?>[] writers() {
            return this.writers;
        }

        @Override
        public void write(InternalRow row, Encoder encoder) throws IOException {
            for (int i = 0; i < this.types.length; ++i) {
                if (row.isNullAt(i)) {
                    this.writers[i].write(null, encoder);
                    continue;
                }
                this.write(row, i, this.writers[i], encoder);
            }
        }

        private <T> void write(InternalRow row, int pos, ValueWriter<T> writer, Encoder encoder) throws IOException {
            writer.write(row.get(pos, this.types[pos]), encoder);
        }
    }

    private static class MapWriter<K, V>
    implements ValueWriter<MapData> {
        private final ValueWriter<K> keyWriter;
        private final ValueWriter<V> valueWriter;
        private final DataType keyType;
        private final DataType valueType;

        private MapWriter(ValueWriter<K> keyWriter, DataType keyType, ValueWriter<V> valueWriter, DataType valueType) {
            this.keyWriter = keyWriter;
            this.keyType = keyType;
            this.valueWriter = valueWriter;
            this.valueType = valueType;
        }

        @Override
        public void write(MapData map, Encoder encoder) throws IOException {
            encoder.writeMapStart();
            int numElements = map.numElements();
            encoder.setItemCount(numElements);
            ArrayData keyArray = map.keyArray();
            ArrayData valueArray = map.valueArray();
            for (int i = 0; i < numElements; ++i) {
                encoder.startItem();
                this.keyWriter.write(keyArray.get(i, this.keyType), encoder);
                this.valueWriter.write(valueArray.get(i, this.valueType), encoder);
            }
            encoder.writeMapEnd();
        }
    }

    private static class ArrayMapWriter<K, V>
    implements ValueWriter<MapData> {
        private final ValueWriter<K> keyWriter;
        private final ValueWriter<V> valueWriter;
        private final DataType keyType;
        private final DataType valueType;

        private ArrayMapWriter(ValueWriter<K> keyWriter, DataType keyType, ValueWriter<V> valueWriter, DataType valueType) {
            this.keyWriter = keyWriter;
            this.keyType = keyType;
            this.valueWriter = valueWriter;
            this.valueType = valueType;
        }

        @Override
        public void write(MapData map, Encoder encoder) throws IOException {
            encoder.writeArrayStart();
            int numElements = map.numElements();
            encoder.setItemCount(numElements);
            ArrayData keyArray = map.keyArray();
            ArrayData valueArray = map.valueArray();
            for (int i = 0; i < numElements; ++i) {
                encoder.startItem();
                this.keyWriter.write(keyArray.get(i, this.keyType), encoder);
                this.valueWriter.write(valueArray.get(i, this.valueType), encoder);
            }
            encoder.writeArrayEnd();
        }
    }

    private static class ArrayWriter<T>
    implements ValueWriter<ArrayData> {
        private final ValueWriter<T> elementWriter;
        private final DataType elementType;

        private ArrayWriter(ValueWriter<T> elementWriter, DataType elementType) {
            this.elementWriter = elementWriter;
            this.elementType = elementType;
        }

        @Override
        public void write(ArrayData array, Encoder encoder) throws IOException {
            encoder.writeArrayStart();
            int numElements = array.numElements();
            encoder.setItemCount(numElements);
            for (int i = 0; i < numElements; ++i) {
                encoder.startItem();
                this.elementWriter.write(array.get(i, this.elementType), encoder);
            }
            encoder.writeArrayEnd();
        }
    }

    private static class DecimalWriter
    implements ValueWriter<Decimal> {
        private final int precision;
        private final int scale;
        private final int length;
        private final ThreadLocal<byte[]> bytes;

        private DecimalWriter(int precision, int scale) {
            this.precision = precision;
            this.scale = scale;
            this.length = TypeUtil.decimalRequriedBytes(precision);
            this.bytes = ThreadLocal.withInitial(() -> new byte[this.length]);
        }

        @Override
        public void write(Decimal d, Encoder encoder) throws IOException {
            Preconditions.checkArgument(d.scale() == this.scale, "Cannot write value as decimal(%s,%s), wrong scale: %s", (Object)this.precision, (Object)this.scale, (Object)d);
            Preconditions.checkArgument(d.precision() <= this.precision, "Cannot write value as decimal(%s,%s), too large: %s", (Object)this.precision, (Object)this.scale, (Object)d);
            BigDecimal decimal = d.toJavaBigDecimal();
            byte fillByte = (byte)(decimal.signum() < 0 ? 255 : 0);
            byte[] unscaled = decimal.unscaledValue().toByteArray();
            byte[] buf = this.bytes.get();
            int offset = this.length - unscaled.length;
            for (int i = 0; i < this.length; ++i) {
                buf[i] = i < offset ? fillByte : unscaled[i - offset];
            }
            encoder.writeFixed(buf);
        }
    }

    private static class UUIDWriter
    implements ValueWriter<UTF8String> {
        private static final ThreadLocal<ByteBuffer> BUFFER = ThreadLocal.withInitial(() -> {
            ByteBuffer buffer = ByteBuffer.allocate(16);
            buffer.order(ByteOrder.BIG_ENDIAN);
            return buffer;
        });
        private static final UUIDWriter INSTANCE = new UUIDWriter();

        private UUIDWriter() {
        }

        @Override
        public void write(UTF8String s2, Encoder encoder) throws IOException {
            UUID uuid = UUID.fromString(s2.toString());
            ByteBuffer buffer = BUFFER.get();
            buffer.rewind();
            buffer.putLong(uuid.getMostSignificantBits());
            buffer.putLong(uuid.getLeastSignificantBits());
            encoder.writeFixed(buffer.array());
        }
    }

    private static class StringWriter
    implements ValueWriter<UTF8String> {
        private static final StringWriter INSTANCE = new StringWriter();

        private StringWriter() {
        }

        @Override
        public void write(UTF8String s2, Encoder encoder) throws IOException {
            encoder.writeString(new Utf8(s2.getBytes()));
        }
    }
}

