/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.hacks;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.iceberg.shaded.com.google.common.base.Splitter;
import org.apache.iceberg.shaded.com.google.common.collect.Lists;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.client.HiveClient;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class Hive {
    private static volatile HiveClient hiveClient = null;

    private Hive() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HiveClient getClient(SparkSession spark) {
        if (hiveClient != null) return hiveClient;
        Class<Hive> clazz = Hive.class;
        synchronized (Hive.class) {
            if (hiveClient != null) return hiveClient;
            hiveClient = HiveUtils$.MODULE$.newClientForMetadata(spark.sparkContext().conf(), spark.sparkContext().hadoopConfiguration());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return hiveClient;
        }
    }

    public static Seq<CatalogTablePartition> partitions(SparkSession spark, String name) {
        ArrayList<String> parts = Lists.newArrayList(Splitter.on('.').limit(2).split(name));
        String db = parts.size() == 1 ? "default" : (String)parts.get(0);
        String table = (String)parts.get(parts.size() == 1 ? 0 : 1);
        return Hive.getClient(spark).getPartitions(db, table, Option.empty());
    }

    public static Seq<CatalogTablePartition> partitionsByFilter(SparkSession spark, String name, Expression expression) {
        ArrayList<String> parts = Lists.newArrayList(Splitter.on('.').limit(2).split(name));
        String db = parts.size() == 1 ? "default" : (String)parts.get(0);
        String table = (String)parts.get(parts.size() == 1 ? 0 : 1);
        HiveClient client = Hive.getClient(spark);
        ArrayList<Expression> expressions = new ArrayList<Expression>(Arrays.asList(expression));
        Seq exprs = ((Iterable)JavaConverters.collectionAsScalaIterableConverter(expressions).asScala()).toSeq();
        return client.getPartitionsByFilter(client.getTable(db, table), exprs);
    }
}

