/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.shaded.com.google.common.collect.Maps;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.types.UTF8String;

class PartitionKey
implements StructLike {
    private final PartitionSpec spec;
    private final int size;
    private final Object[] partitionTuple;
    private final Transform[] transforms;
    private final Accessor<InternalRow>[] accessors;

    PartitionKey(PartitionSpec spec) {
        this.spec = spec;
        List<PartitionField> fields = spec.fields();
        this.size = fields.size();
        this.partitionTuple = new Object[this.size];
        this.transforms = new Transform[this.size];
        this.accessors = (Accessor[])Array.newInstance(Accessor.class, this.size);
        Schema schema = spec.schema();
        Map<Integer, Accessor<InternalRow>> newAccessors = PartitionKey.buildAccessors(schema);
        for (int i = 0; i < this.size; ++i) {
            PartitionField field = fields.get(i);
            Accessor<InternalRow> accessor = newAccessors.get(field.sourceId());
            if (accessor == null) {
                throw new RuntimeException("Cannot build accessor for field: " + schema.findField(field.sourceId()));
            }
            this.accessors[i] = accessor;
            this.transforms[i] = field.transform();
        }
    }

    private PartitionKey(PartitionKey toCopy) {
        this.spec = toCopy.spec;
        this.size = toCopy.size;
        this.partitionTuple = new Object[toCopy.partitionTuple.length];
        this.transforms = toCopy.transforms;
        this.accessors = toCopy.accessors;
        for (int i = 0; i < this.partitionTuple.length; ++i) {
            this.partitionTuple[i] = this.defensiveCopyIfNeeded(toCopy.partitionTuple[i]);
        }
    }

    private Object defensiveCopyIfNeeded(Object obj) {
        if (obj instanceof UTF8String) {
            byte[] bytes = ((UTF8String)obj).getBytes();
            return UTF8String.fromBytes((byte[])Arrays.copyOf(bytes, bytes.length));
        }
        return obj;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.partitionTuple.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.partitionTuple[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    PartitionKey copy() {
        return new PartitionKey(this);
    }

    String toPath() {
        return this.spec.partitionToPath(this);
    }

    void partition(InternalRow row) {
        for (int i = 0; i < this.partitionTuple.length; ++i) {
            Transform transform = this.transforms[i];
            this.partitionTuple[i] = transform.apply(this.accessors[i].get(row));
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public <T> T get(int pos, Class<T> javaClass) {
        return javaClass.cast(this.partitionTuple[pos]);
    }

    @Override
    public <T> void set(int pos, T value) {
        this.partitionTuple[pos] = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionKey that = (PartitionKey)o;
        return Arrays.equals(this.partitionTuple, that.partitionTuple);
    }

    public int hashCode() {
        return Arrays.hashCode(this.partitionTuple);
    }

    private static Map<Integer, Accessor<InternalRow>> buildAccessors(Schema schema) {
        return TypeUtil.visit(schema, new BuildPositionAccessors());
    }

    private static Accessor<InternalRow> newAccessor(int position, Type type) {
        switch (type.typeId()) {
            case STRING: {
                return new StringAccessor(position, SparkSchemaUtil.convert(type));
            }
            case DECIMAL: {
                return new DecimalAccessor(position, SparkSchemaUtil.convert(type));
            }
            case BINARY: {
                return new BytesAccessor(position, SparkSchemaUtil.convert(type));
            }
        }
        return new PositionAccessor(position, SparkSchemaUtil.convert(type));
    }

    private static Accessor<InternalRow> newAccessor(int position, boolean isOptional, Types.StructType type, Accessor<InternalRow> accessor) {
        int size = type.fields().size();
        if (isOptional) {
            return new WrappedPositionAccessor(position, size, accessor);
        }
        if (accessor instanceof PositionAccessor) {
            return new Position2Accessor(position, size, (PositionAccessor)accessor);
        }
        if (accessor instanceof Position2Accessor) {
            return new Position3Accessor(position, size, (Position2Accessor)accessor);
        }
        return new WrappedPositionAccessor(position, size, accessor);
    }

    private static class WrappedPositionAccessor
    implements Accessor<InternalRow> {
        private final int position;
        private final int size;
        private final Accessor<InternalRow> accessor;

        private WrappedPositionAccessor(int position, int size, Accessor<InternalRow> accessor) {
            this.position = position;
            this.size = size;
            this.accessor = accessor;
        }

        @Override
        public Object get(InternalRow row) {
            InternalRow inner = row.getStruct(this.position, this.size);
            if (inner != null) {
                return this.accessor.get(inner);
            }
            return null;
        }
    }

    private static class Position3Accessor
    implements Accessor<InternalRow> {
        private final int p0;
        private final int size0;
        private final int p1;
        private final int size1;
        private final int p2;
        private final DataType type;

        private Position3Accessor(int position, int size, Position2Accessor wrapped) {
            this.p0 = position;
            this.size0 = size;
            this.p1 = wrapped.p0;
            this.size1 = wrapped.size0;
            this.p2 = wrapped.p1;
            this.type = wrapped.type;
        }

        @Override
        public Object get(InternalRow row) {
            return row.getStruct(this.p0, this.size0).getStruct(this.p1, this.size1).get(this.p2, this.type);
        }
    }

    private static class Position2Accessor
    implements Accessor<InternalRow> {
        private final int p0;
        private final int size0;
        private final int p1;
        private final DataType type;

        private Position2Accessor(int position, int size, PositionAccessor wrapped) {
            this.p0 = position;
            this.size0 = size;
            this.p1 = wrapped.position;
            this.type = wrapped.type;
        }

        @Override
        public Object get(InternalRow row) {
            return row.getStruct(this.p0, this.size0).get(this.p1, this.type);
        }
    }

    private static class BytesAccessor
    extends PositionAccessor {
        private BytesAccessor(int position, DataType type) {
            super(position, type);
        }

        @Override
        public Object get(InternalRow row) {
            if (row.isNullAt(this.position())) {
                return null;
            }
            return ByteBuffer.wrap((byte[])row.get(this.position(), this.type()));
        }
    }

    private static class DecimalAccessor
    extends PositionAccessor {
        private DecimalAccessor(int position, DataType type) {
            super(position, type);
        }

        @Override
        public Object get(InternalRow row) {
            if (row.isNullAt(this.position())) {
                return null;
            }
            return ((Decimal)row.get(this.position(), this.type())).toJavaBigDecimal();
        }
    }

    private static class StringAccessor
    extends PositionAccessor {
        private StringAccessor(int position, DataType type) {
            super(position, type);
        }

        @Override
        public Object get(InternalRow row) {
            if (row.isNullAt(this.position())) {
                return null;
            }
            return row.get(this.position(), this.type()).toString();
        }
    }

    private static class PositionAccessor
    implements Accessor<InternalRow> {
        private final DataType type;
        private int position;

        private PositionAccessor(int position, DataType type) {
            this.position = position;
            this.type = type;
        }

        @Override
        public Object get(InternalRow row) {
            if (row.isNullAt(this.position)) {
                return null;
            }
            return row.get(this.position, this.type);
        }

        DataType type() {
            return this.type;
        }

        int position() {
            return this.position;
        }
    }

    private static class BuildPositionAccessors
    extends TypeUtil.SchemaVisitor<Map<Integer, Accessor<InternalRow>>> {
        private BuildPositionAccessors() {
        }

        @Override
        public Map<Integer, Accessor<InternalRow>> schema(Schema schema, Map<Integer, Accessor<InternalRow>> structResult) {
            return structResult;
        }

        @Override
        public Map<Integer, Accessor<InternalRow>> struct(Types.StructType struct, List<Map<Integer, Accessor<InternalRow>>> fieldResults) {
            HashMap<Integer, Accessor<InternalRow>> accessors = Maps.newHashMap();
            List<Types.NestedField> fields = struct.fields();
            for (int i = 0; i < fieldResults.size(); ++i) {
                Types.NestedField field = fields.get(i);
                Map<Integer, Accessor<InternalRow>> result = fieldResults.get(i);
                if (result != null) {
                    for (Map.Entry<Integer, Accessor<InternalRow>> entry : result.entrySet()) {
                        accessors.put(entry.getKey(), PartitionKey.newAccessor(i, field.isOptional(), field.type().asNestedType().asStructType(), entry.getValue()));
                    }
                    continue;
                }
                accessors.put(field.fieldId(), PartitionKey.newAccessor(i, field.type()));
            }
            if (accessors.isEmpty()) {
                return null;
            }
            return accessors;
        }

        @Override
        public Map<Integer, Accessor<InternalRow>> field(Types.NestedField field, Map<Integer, Accessor<InternalRow>> fieldResult) {
            return fieldResult;
        }
    }

    private static interface Accessor<T> {
        public Object get(T var1);
    }
}

