/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.shaded.com.google.common.collect.ImmutableList;
import org.apache.iceberg.shaded.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ByteBuffers;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

class StructInternalRow
extends InternalRow {
    private final Types.StructType type;
    private StructLike struct;

    StructInternalRow(Types.StructType type) {
        this.type = type;
    }

    private StructInternalRow(Types.StructType type, StructLike struct) {
        this.type = type;
        this.struct = struct;
    }

    public StructInternalRow setStruct(StructLike newStruct) {
        this.struct = newStruct;
        return this;
    }

    public int numFields() {
        return this.struct.size();
    }

    public void setNullAt(int i) {
        throw new UnsupportedOperationException("StructInternalRow is read-only");
    }

    public void update(int i, Object value) {
        throw new UnsupportedOperationException("StructInternalRow is read-only");
    }

    public InternalRow copy() {
        return this;
    }

    public boolean isNullAt(int ordinal) {
        return this.struct.get(ordinal, Object.class) == null;
    }

    public boolean getBoolean(int ordinal) {
        return this.struct.get(ordinal, Boolean.class);
    }

    public byte getByte(int ordinal) {
        return (byte)this.struct.get(ordinal, Integer.class).intValue();
    }

    public short getShort(int ordinal) {
        return (short)this.struct.get(ordinal, Integer.class).intValue();
    }

    public int getInt(int ordinal) {
        return this.struct.get(ordinal, Integer.class);
    }

    public long getLong(int ordinal) {
        return this.struct.get(ordinal, Long.class);
    }

    public float getFloat(int ordinal) {
        return this.struct.get(ordinal, Float.class).floatValue();
    }

    public double getDouble(int ordinal) {
        return this.struct.get(ordinal, Double.class);
    }

    public Decimal getDecimal(int ordinal, int precision, int scale) {
        return Decimal.apply((BigDecimal)this.struct.get(ordinal, BigDecimal.class));
    }

    public UTF8String getUTF8String(int ordinal) {
        CharSequence seq = this.struct.get(ordinal, CharSequence.class);
        return UTF8String.fromString((String)seq.toString());
    }

    public byte[] getBinary(int ordinal) {
        ByteBuffer bytes = this.struct.get(ordinal, ByteBuffer.class);
        return ByteBuffers.toByteArray(bytes);
    }

    public CalendarInterval getInterval(int ordinal) {
        throw new UnsupportedOperationException("Unsupported type: interval");
    }

    public InternalRow getStruct(int ordinal, int numFields) {
        return new StructInternalRow(this.type.fields().get(ordinal).type().asStructType(), this.struct.get(ordinal, StructLike.class));
    }

    public ArrayData getArray(int ordinal) {
        return this.collectionToArrayData(this.type.fields().get(ordinal).type().asListType().elementType(), this.struct.get(ordinal, Collection.class));
    }

    public MapData getMap(int ordinal) {
        return this.mapToMapData(this.type.fields().get(ordinal).type().asMapType(), this.struct.get(ordinal, Map.class));
    }

    public Object get(int ordinal, DataType dataType) {
        if (dataType instanceof IntegerType) {
            return this.getInt(ordinal);
        }
        if (dataType instanceof LongType) {
            return this.getLong(ordinal);
        }
        if (dataType instanceof StringType) {
            return this.getUTF8String(ordinal);
        }
        if (dataType instanceof FloatType) {
            return Float.valueOf(this.getFloat(ordinal));
        }
        if (dataType instanceof DoubleType) {
            return this.getDouble(ordinal);
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return this.getDecimal(ordinal, decimalType.precision(), decimalType.scale());
        }
        if (dataType instanceof BinaryType) {
            return this.getBinary(ordinal);
        }
        if (dataType instanceof StructType) {
            return this.getStruct(ordinal, ((StructType)dataType).size());
        }
        if (dataType instanceof ArrayType) {
            return this.getArray(ordinal);
        }
        if (dataType instanceof MapType) {
            return this.getMap(ordinal);
        }
        if (dataType instanceof BooleanType) {
            return this.getBoolean(ordinal);
        }
        if (dataType instanceof ByteType) {
            return this.getByte(ordinal);
        }
        if (dataType instanceof ShortType) {
            return this.getShort(ordinal);
        }
        return null;
    }

    private MapData mapToMapData(Types.MapType mapType, Map<?, ?> map) {
        ImmutableList<Map.Entry<?, ?>> entries = ImmutableList.copyOf(map.entrySet());
        return new ArrayBasedMapData(this.collectionToArrayData(mapType.keyType(), Lists.transform(entries, Map.Entry::getKey)), this.collectionToArrayData(mapType.valueType(), Lists.transform(entries, Map.Entry::getValue)));
    }

    private ArrayData collectionToArrayData(Type elementType, Collection<?> values) {
        switch (elementType.typeId()) {
            case BOOLEAN: {
                return this.fillArray(values, array -> (arg_0, arg_1) -> ((ArrayData)array).setBoolean(arg_0, arg_1));
            }
            case INTEGER: 
            case DATE: 
            case TIME: {
                return this.fillArray(values, array -> (arg_0, arg_1) -> ((ArrayData)array).setInt(arg_0, arg_1));
            }
            case LONG: 
            case TIMESTAMP: {
                return this.fillArray(values, array -> (arg_0, arg_1) -> ((ArrayData)array).setLong(arg_0, arg_1));
            }
            case FLOAT: {
                return this.fillArray(values, array -> (arg_0, arg_1) -> ((ArrayData)array).setFloat(arg_0, arg_1));
            }
            case DOUBLE: {
                return this.fillArray(values, array -> (arg_0, arg_1) -> ((ArrayData)array).setDouble(arg_0, arg_1));
            }
            case STRING: {
                return this.fillArray(values, array -> (pos, seq) -> array.update(pos.intValue(), (Object)UTF8String.fromString((String)seq.toString())));
            }
            case FIXED: 
            case BINARY: {
                return this.fillArray(values, array -> (pos, buf) -> array.update(pos.intValue(), (Object)ByteBuffers.toByteArray(buf)));
            }
            case DECIMAL: {
                return this.fillArray(values, array -> (pos, dec) -> array.update(pos.intValue(), (Object)Decimal.apply((BigDecimal)dec)));
            }
            case STRUCT: {
                return this.fillArray(values, array -> (pos, tuple) -> array.update(pos.intValue(), (Object)new StructInternalRow(elementType.asStructType(), (StructLike)tuple)));
            }
            case LIST: {
                return this.fillArray(values, array -> (pos, list) -> array.update(pos.intValue(), (Object)this.collectionToArrayData(elementType.asListType(), (Collection<?>)list)));
            }
            case MAP: {
                return this.fillArray(values, array -> (pos, map) -> array.update(pos.intValue(), (Object)this.mapToMapData(elementType.asMapType(), (Map<?, ?>)map)));
            }
        }
        throw new UnsupportedOperationException("Unsupported array element type: " + elementType);
    }

    private <T> GenericArrayData fillArray(Collection<?> values, Function<ArrayData, BiConsumer<Integer, T>> makeSetter) {
        GenericArrayData array = new GenericArrayData(new Object[values.size()]);
        BiConsumer<Integer, Integer> setter = makeSetter.apply((ArrayData)array);
        int index = 0;
        for (Object value : values) {
            if (value == null) {
                array.setNullAt(index);
            } else {
                setter.accept(index, (Integer)value);
            }
            ++index;
        }
        return array;
    }
}

