/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iceberg.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.transforms.Bucket;
import org.apache.iceberg.transforms.Dates;
import org.apache.iceberg.transforms.Identity;
import org.apache.iceberg.transforms.Timestamps;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Truncate;
import org.apache.iceberg.transforms.UnknownTransform;
import org.apache.iceberg.types.Type;

public class Transforms {
    private static final Pattern HAS_WIDTH = Pattern.compile("(\\w+)\\[(\\d+)\\]");

    private Transforms() {
    }

    public static Transform<?, ?> fromString(Type type, String transform) {
        Matcher widthMatcher = HAS_WIDTH.matcher(transform);
        if (widthMatcher.matches()) {
            String name = widthMatcher.group(1);
            int parsedWidth = Integer.parseInt(widthMatcher.group(2));
            if (name.equalsIgnoreCase("truncate")) {
                return Truncate.get(type, parsedWidth);
            }
            if (name.equals("bucket")) {
                return Bucket.get(type, parsedWidth);
            }
        }
        if (transform.equalsIgnoreCase("identity")) {
            return Identity.get(type);
        }
        try {
            if (type.typeId() == Type.TypeID.TIMESTAMP) {
                return Timestamps.valueOf(transform.toUpperCase(Locale.ENGLISH));
            }
            if (type.typeId() == Type.TypeID.DATE) {
                return Dates.valueOf(transform.toUpperCase(Locale.ENGLISH));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return new UnknownTransform(type, transform);
    }

    public static <T> Transform<T, T> identity(Type type) {
        return Identity.get(type);
    }

    public static <T> Transform<T, Integer> year(Type type) {
        switch (type.typeId()) {
            case DATE: {
                return Dates.YEAR;
            }
            case TIMESTAMP: {
                return Timestamps.YEAR;
            }
        }
        throw new IllegalArgumentException("Cannot partition type " + type + " by year");
    }

    public static <T> Transform<T, Integer> month(Type type) {
        switch (type.typeId()) {
            case DATE: {
                return Dates.MONTH;
            }
            case TIMESTAMP: {
                return Timestamps.MONTH;
            }
        }
        throw new IllegalArgumentException("Cannot partition type " + type + " by month");
    }

    public static <T> Transform<T, Integer> day(Type type) {
        switch (type.typeId()) {
            case DATE: {
                return Dates.DAY;
            }
            case TIMESTAMP: {
                return Timestamps.DAY;
            }
        }
        throw new IllegalArgumentException("Cannot partition type " + type + " by day");
    }

    public static <T> Transform<T, Integer> hour(Type type) {
        Preconditions.checkArgument(type.typeId() == Type.TypeID.TIMESTAMP, "Cannot partition type %s by hour", (Object)type);
        return Timestamps.HOUR;
    }

    public static <T> Transform<T, Integer> bucket(Type type, int numBuckets) {
        return Bucket.get(type, numBuckets);
    }

    public static <T> Transform<T, T> truncate(Type type, int width) {
        return Truncate.get(type, width);
    }
}

