/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.apache.iceberg.Schema;
import org.apache.iceberg.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.shaded.com.google.common.collect.ImmutableList;
import org.apache.iceberg.shaded.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class CheckCompatibility
extends TypeUtil.CustomOrderSchemaVisitor<List<String>> {
    private static final List<String> NO_ERRORS = ImmutableList.of();
    private final Schema schema;
    private final boolean checkOrdering;
    private Type currentType;

    public static List<String> writeCompatibilityErrors(Schema readSchema, Schema writeSchema) {
        return TypeUtil.visit(readSchema, new CheckCompatibility(writeSchema, true));
    }

    public static List<String> readCompatibilityErrors(Schema readSchema, Schema writeSchema) {
        return TypeUtil.visit(readSchema, new CheckCompatibility(writeSchema, false));
    }

    private CheckCompatibility(Schema schema, boolean checkOrdering) {
        this.schema = schema;
        this.checkOrdering = checkOrdering;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> schema(Schema readSchema, Supplier<List<String>> structErrors) {
        this.currentType = this.schema.asStruct();
        try {
            List<String> list = structErrors.get();
            return list;
        }
        finally {
            this.currentType = null;
        }
    }

    @Override
    public List<String> struct(Types.StructType readStruct, Iterable<List<String>> fieldErrorLists) {
        Preconditions.checkNotNull(readStruct, "Evaluation must start with a schema.");
        if (!this.currentType.isStructType()) {
            return ImmutableList.of(String.format(": %s cannot be read as a struct", this.currentType));
        }
        ArrayList<String> errors = Lists.newArrayList();
        for (List<String> fieldErrors : fieldErrorLists) {
            errors.addAll(fieldErrors);
        }
        if (this.checkOrdering) {
            Types.StructType struct = this.currentType.asStructType();
            List<Types.NestedField> fields = struct.fields();
            HashMap<Integer, Integer> idToOrdinal = Maps.newHashMap();
            for (int i = 0; i < fields.size(); ++i) {
                idToOrdinal.put(fields.get(i).fieldId(), i);
            }
            int lastOrdinal = -1;
            for (Types.NestedField readField : readStruct.fields()) {
                int id = readField.fieldId();
                Types.NestedField field = struct.field(id);
                if (field == null) continue;
                int ordinal = (Integer)idToOrdinal.get(id);
                if (lastOrdinal >= ordinal) {
                    errors.add(readField.name() + " is out of order, before " + fields.get(lastOrdinal).name());
                }
                lastOrdinal = ordinal;
            }
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> field(Types.NestedField readField, Supplier<List<String>> fieldErrors) {
        Types.StructType struct = this.currentType.asStructType();
        Types.NestedField field = struct.field(readField.fieldId());
        ArrayList<String> errors = Lists.newArrayList();
        if (field == null) {
            if (readField.isRequired()) {
                return ImmutableList.of(readField.name() + " is required, but is missing");
            }
            return NO_ERRORS;
        }
        this.currentType = field.type();
        try {
            if (readField.isRequired() && field.isOptional()) {
                errors.add(readField.name() + " should be required, but is optional");
            }
            for (String error : fieldErrors.get()) {
                if (error.startsWith(":")) {
                    errors.add(readField.name() + error);
                    continue;
                }
                errors.add(readField.name() + "." + error);
            }
            ArrayList<String> arrayList = errors;
            return arrayList;
        }
        finally {
            this.currentType = struct;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> list(Types.ListType readList, Supplier<List<String>> elementErrors) {
        if (!this.currentType.isListType()) {
            return ImmutableList.of(String.format(": %s cannot be read as a list", this.currentType));
        }
        Types.ListType list = this.currentType.asNestedType().asListType();
        ArrayList<String> errors = Lists.newArrayList();
        this.currentType = list.elementType();
        try {
            if (readList.isElementRequired() && list.isElementOptional()) {
                errors.add(": elements should be required, but are optional");
            }
            errors.addAll((Collection)elementErrors.get());
            ArrayList<String> arrayList = errors;
            return arrayList;
        }
        finally {
            this.currentType = list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> map(Types.MapType readMap, Supplier<List<String>> keyErrors, Supplier<List<String>> valueErrors) {
        if (!this.currentType.isMapType()) {
            return ImmutableList.of(String.format(": %s cannot be read as a map", this.currentType));
        }
        Types.MapType map = this.currentType.asNestedType().asMapType();
        ArrayList<String> errors = Lists.newArrayList();
        try {
            if (readMap.isValueRequired() && map.isValueOptional()) {
                errors.add(": values should be required, but are optional");
            }
            this.currentType = map.keyType();
            errors.addAll((Collection)keyErrors.get());
            this.currentType = map.valueType();
            errors.addAll((Collection)valueErrors.get());
            ArrayList<String> arrayList = errors;
            return arrayList;
        }
        finally {
            this.currentType = map;
        }
    }

    @Override
    public List<String> primitive(Type.PrimitiveType readPrimitive) {
        if (this.currentType.equals(readPrimitive)) {
            return NO_ERRORS;
        }
        if (!this.currentType.isPrimitiveType()) {
            return ImmutableList.of(String.format(": %s cannot be read as a %s", this.currentType.typeId().toString().toLowerCase(Locale.ENGLISH), readPrimitive));
        }
        if (!TypeUtil.isPromotionAllowed(this.currentType.asPrimitiveType(), readPrimitive)) {
            return ImmutableList.of(String.format(": %s cannot be promoted to %s", this.currentType, readPrimitive));
        }
        return NO_ERRORS;
    }
}

