/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.nio.ByteBuffer;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.shaded.com.google.common.base.Preconditions;

public class BinaryUtil {
    private BinaryUtil() {
    }

    public static ByteBuffer truncateBinary(ByteBuffer input, int length) {
        Preconditions.checkArgument(length > 0, "Truncate length should be positive");
        if (length >= input.remaining()) {
            return input;
        }
        byte[] array = new byte[length];
        input.duplicate().get(array);
        return ByteBuffer.wrap(array);
    }

    public static Literal<ByteBuffer> truncateBinaryMin(Literal<ByteBuffer> input, int length) {
        ByteBuffer inputBuffer = input.value();
        if (length >= inputBuffer.remaining()) {
            return input;
        }
        return Literal.of(BinaryUtil.truncateBinary(inputBuffer, length));
    }

    public static Literal<ByteBuffer> truncateBinaryMax(Literal<ByteBuffer> input, int length) {
        ByteBuffer inputBuffer = input.value();
        if (length >= inputBuffer.remaining()) {
            return input;
        }
        ByteBuffer truncatedInput = BinaryUtil.truncateBinary(inputBuffer, length);
        for (int i = length - 1; i >= 0; --i) {
            byte element = truncatedInput.get(i);
            if ((element = (byte)(element + 1)) == 0) continue;
            truncatedInput.put(i, element);
            truncatedInput.position(0);
            truncatedInput.limit(i + 1);
            return Literal.of(truncatedInput);
        }
        return null;
    }
}

