/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.nio.ByteBuffer;
import java.util.Arrays;

public class ByteBuffers {
    public static byte[] toByteArray(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        if (buffer.hasArray()) {
            byte[] array = buffer.array();
            if (buffer.arrayOffset() == 0 && buffer.position() == 0 && array.length == buffer.remaining()) {
                return array;
            }
            int start = buffer.arrayOffset() + buffer.position();
            int end = start + buffer.remaining();
            return Arrays.copyOfRange(array, start, end);
        }
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }

    public static ByteBuffer copy(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        byte[] copyArray = new byte[buffer.remaining()];
        ByteBuffer readerBuffer = buffer.asReadOnlyBuffer();
        readerBuffer.get(copyArray);
        return ByteBuffer.wrap(copyArray);
    }

    private ByteBuffers() {
    }
}

