/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.shaded.com.google.common.collect.Lists;

public class SnapshotUtil {
    private SnapshotUtil() {
    }

    public static List<Long> currentAncestors(Table table) {
        return SnapshotUtil.ancestorIds(table.currentSnapshot(), table::snapshot);
    }

    public static List<Long> ancestorIds(Snapshot snapshot, Function<Long, Snapshot> lookup) {
        ArrayList<Long> ancestorIds = Lists.newArrayList();
        Snapshot current = snapshot;
        while (current != null) {
            ancestorIds.add(current.snapshotId());
            if (current.parentId() != null) {
                current = lookup.apply(current.parentId());
                continue;
            }
            current = null;
        }
        return ancestorIds;
    }
}

