/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.iceberg.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.apache.iceberg.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;

public class ThreadPools {
    public static final String WORKER_THREAD_POOL_SIZE_PROP = "iceberg.worker.num-threads";
    public static final int WORKER_THREAD_POOL_SIZE = ThreadPools.getPoolSize("iceberg.worker.num-threads", Runtime.getRuntime().availableProcessors());
    private static final ExecutorService WORKER_POOL = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)Executors.newFixedThreadPool(WORKER_THREAD_POOL_SIZE, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("iceberg-worker-pool-%d").build()));

    private ThreadPools() {
    }

    public static ExecutorService getWorkerPool() {
        return WORKER_POOL;
    }

    private static int getPoolSize(String systemProperty, int defaultSize) {
        String value = System.getProperty(systemProperty);
        if (value != null) {
            try {
                return Integer.parseUnsignedInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultSize;
    }
}

