/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.externalize;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.query.calcite.externalize.RelInputEx;
import org.apache.ignite.internal.processors.query.calcite.externalize.RelJson;
import org.apache.ignite.internal.processors.query.calcite.prepare.BaseQueryContext;
import org.apache.ignite.internal.processors.query.calcite.prepare.bounds.SearchBounds;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;

public class RelJsonReader {
    private static final TypeReference<LinkedHashMap<String, Object>> TYPE_REF = new TypeReference<LinkedHashMap<String, Object>>(){};
    private final ObjectMapper mapper = new ObjectMapper().enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
    private final RelOptSchema relOptSchema;
    private final RelJson relJson;
    private final Map<String, RelNode> relMap = new LinkedHashMap<String, RelNode>();
    private RelNode lastRel;

    public static <T extends RelNode> T fromJson(BaseQueryContext ctx, String json) {
        RelJsonReader reader = new RelJsonReader(ctx);
        return (T)reader.read(json);
    }

    public RelJsonReader(BaseQueryContext qctx) {
        this.relOptSchema = qctx.catalogReader();
        this.relJson = new RelJson(qctx);
    }

    public RelNode read(String s) {
        try {
            this.lastRel = null;
            Map o = (Map)this.mapper.readValue(s, TYPE_REF);
            List rels = (List)o.get("rels");
            this.readRels(rels);
            return this.lastRel;
        }
        catch (IOException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    private void readRels(List<Map<String, Object>> jsonRels) {
        for (Map<String, Object> jsonRel : jsonRels) {
            this.readRel(jsonRel);
        }
    }

    private void readRel(Map<String, Object> jsonRel) {
        String id = (String)jsonRel.get("id");
        String type = (String)jsonRel.get("relOp");
        Function<RelInput, RelNode> factory = this.relJson.factory(type);
        RelNode rel = factory.apply(new RelInputImpl(jsonRel));
        this.relMap.put(id, rel);
        this.lastRel = rel;
    }

    private class RelInputImpl
    implements RelInputEx {
        private final Map<String, Object> jsonRel;

        private RelInputImpl(Map<String, Object> jsonRel) {
            this.jsonRel = jsonRel;
        }

        public RelOptCluster getCluster() {
            return Commons.emptyCluster();
        }

        public RelTraitSet getTraitSet() {
            return Commons.emptyCluster().traitSet();
        }

        public RelOptTable getTable(String table) {
            List<String> list = this.getStringList(table);
            return RelJsonReader.this.relOptSchema.getTableForMember(list);
        }

        public RelNode getInput() {
            List<RelNode> inputs = this.getInputs();
            assert (inputs.size() == 1);
            return inputs.get(0);
        }

        public List<RelNode> getInputs() {
            List<String> jsonInputs = this.getStringList("inputs");
            if (jsonInputs == null) {
                return ImmutableList.of((Object)RelJsonReader.this.lastRel);
            }
            ArrayList<RelNode> inputs = new ArrayList<RelNode>();
            for (String jsonInput : jsonInputs) {
                inputs.add(this.lookupInput(jsonInput));
            }
            return inputs;
        }

        public RexNode getExpression(String tag) {
            return RelJsonReader.this.relJson.toRex(this, this.jsonRel.get(tag));
        }

        public ImmutableBitSet getBitSet(String tag) {
            return ImmutableBitSet.of(this.getIntegerList(tag));
        }

        public List<ImmutableBitSet> getBitSetList(String tag) {
            List<List<Integer>> list = this.getIntegerListList(tag);
            if (list == null) {
                return null;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (List<Integer> integers : list) {
                builder.add((Object)ImmutableBitSet.of(integers));
            }
            return builder.build();
        }

        public List<String> getStringList(String tag) {
            return (List)this.jsonRel.get(tag);
        }

        public List<Integer> getIntegerList(String tag) {
            return (List)this.jsonRel.get(tag);
        }

        public List<List<Integer>> getIntegerListList(String tag) {
            return (List)this.jsonRel.get(tag);
        }

        public List<AggregateCall> getAggregateCalls(String tag) {
            List jsonAggs = (List)this.jsonRel.get(tag);
            ArrayList<AggregateCall> inputs = new ArrayList<AggregateCall>();
            for (Map jsonAggCall : jsonAggs) {
                inputs.add(this.toAggCall(jsonAggCall));
            }
            return inputs;
        }

        public Object get(String tag) {
            return this.jsonRel.get(tag);
        }

        public String getString(String tag) {
            return (String)this.jsonRel.get(tag);
        }

        public float getFloat(String tag) {
            return ((Number)this.jsonRel.get(tag)).floatValue();
        }

        public boolean getBoolean(String tag, boolean default_) {
            Boolean b = (Boolean)this.jsonRel.get(tag);
            return b != null ? b : default_;
        }

        public <E extends Enum<E>> E getEnum(String tag, Class<E> enumClass) {
            Enum res;
            Object name = this.get(tag);
            if (name instanceof String && (res = Util.enumVal(enumClass, (String)((String)name).toUpperCase(Locale.ROOT))) != null) {
                return (E)res;
            }
            return (E)RelJsonReader.this.relJson.toEnum(name);
        }

        public List<RexNode> getExpressionList(String tag) {
            List jsonNodes = (List)this.jsonRel.get(tag);
            if (jsonNodes == null) {
                return null;
            }
            ArrayList<RexNode> nodes = new ArrayList<RexNode>();
            for (Object jsonNode : jsonNodes) {
                nodes.add(RelJsonReader.this.relJson.toRex(this, jsonNode));
            }
            return nodes;
        }

        public RelDataType getRowType(String tag) {
            Object o = this.jsonRel.get(tag);
            return RelJsonReader.this.relJson.toType((RelDataTypeFactory)Commons.typeFactory(Commons.emptyCluster()), o);
        }

        public RelDataType getRowType(String expressionsTag, String fieldsTag) {
            final List<RexNode> expressionList = this.getExpressionList(expressionsTag);
            final List names = (List)this.get(fieldsTag);
            return Commons.typeFactory(Commons.emptyCluster()).createStructType(new AbstractList<Map.Entry<String, RelDataType>>(){

                @Override
                public Map.Entry<String, RelDataType> get(int index) {
                    return Pair.of(names.get(index), (Object)((RexNode)expressionList.get(index)).getType());
                }

                @Override
                public int size() {
                    return names.size();
                }
            });
        }

        public RelCollation getCollation() {
            return RelJsonReader.this.relJson.toCollation((List)this.get("collation"));
        }

        @Override
        public RelCollation getCollation(String tag) {
            return RelJsonReader.this.relJson.toCollation((List)this.get(tag));
        }

        @Override
        public List<SearchBounds> getSearchBounds(String tag) {
            return RelJsonReader.this.relJson.toSearchBoundList(this, (List)this.get(tag));
        }

        public RelDistribution getDistribution() {
            return RelJsonReader.this.relJson.toDistribution(this.get("distribution"));
        }

        public ImmutableList<ImmutableList<RexLiteral>> getTuples(String tag) {
            List jsonTuples = (List)this.get(tag);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (List jsonTuple : jsonTuples) {
                builder.add(this.getTuple(jsonTuple));
            }
            return builder.build();
        }

        private RelNode lookupInput(String jsonInput) {
            RelNode node = (RelNode)RelJsonReader.this.relMap.get(jsonInput);
            if (node == null) {
                throw new RuntimeException("unknown id " + jsonInput + " for relational expression");
            }
            return node;
        }

        private ImmutableList<RexLiteral> getTuple(List jsonTuple) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Object jsonValue : jsonTuple) {
                builder.add((Object)((RexLiteral)RelJsonReader.this.relJson.toRex(this, jsonValue)));
            }
            return builder.build();
        }

        private AggregateCall toAggCall(Map<String, Object> jsonAggCall) {
            Map aggMap = (Map)jsonAggCall.get("agg");
            SqlAggFunction aggregation = (SqlAggFunction)RelJsonReader.this.relJson.toOp(aggMap);
            Boolean distinct = (Boolean)jsonAggCall.get("distinct");
            List operands = (List)jsonAggCall.get("operands");
            Integer filterOperand = (Integer)jsonAggCall.get("filter");
            RelDataType type = RelJsonReader.this.relJson.toType((RelDataTypeFactory)Commons.typeFactory(Commons.emptyCluster()), jsonAggCall.get("type"));
            String name = (String)jsonAggCall.get("name");
            RelCollation collation = RelJsonReader.this.relJson.toCollation((List)jsonAggCall.get("coll"));
            return AggregateCall.create((SqlAggFunction)aggregation, (boolean)distinct, (boolean)false, (boolean)false, (List)operands, (int)(filterOperand == null ? -1 : filterOperand), null, (RelCollation)collation, (RelDataType)type, (String)name);
        }
    }
}

