/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare;

import com.google.common.collect.Multimap;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.Metadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.UnboundMetadata;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.util.SqlOperatorTables;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.calcite.CalciteQueryProcessor;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.IgniteRexBuilder;
import org.apache.ignite.internal.processors.query.calcite.metadata.cost.IgniteCostFactory;
import org.apache.ignite.internal.processors.query.calcite.prepare.AbstractQueryContext;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.logger.NullLogger;
import org.jetbrains.annotations.NotNull;

public final class BaseQueryContext
extends AbstractQueryContext {
    private static final IgniteCostFactory COST_FACTORY = new IgniteCostFactory();
    public static final CalciteConnectionConfig CALCITE_CONNECTION_CONFIG;
    private static final BaseQueryContext EMPTY_CONTEXT;
    private static final VolcanoPlanner EMPTY_PLANNER;
    private static final RexBuilder REX_BUILDER;
    public static final RelOptCluster CLUSTER;
    public static final IgniteTypeFactory TYPE_FACTORY;
    private final FrameworkConfig cfg;
    private final IgniteLogger log;
    private final IgniteTypeFactory typeFactory;
    private final RexBuilder rexBuilder;
    private CalciteCatalogReader catalogReader;
    private SqlOperatorTable opTable;
    private final GridQueryCancel qryCancel;
    private final boolean isLocal;
    private final boolean forcedJoinOrder;
    private final int[] parts;

    private BaseQueryContext(FrameworkConfig cfg, Context parentCtx, IgniteLogger log, boolean isLocal, boolean forcedJoinOrder, int[] parts) {
        super(Contexts.chain((Context[])new Context[]{parentCtx, cfg.getContext()}));
        this.cfg = Frameworks.newConfigBuilder((FrameworkConfig)cfg).context((Context)this).build();
        this.log = log;
        this.isLocal = isLocal;
        this.forcedJoinOrder = forcedJoinOrder;
        this.parts = parts;
        this.qryCancel = this.unwrap(GridQueryCancel.class);
        this.typeFactory = TYPE_FACTORY;
        this.rexBuilder = REX_BUILDER;
    }

    public FrameworkConfig config() {
        return this.cfg;
    }

    public IgniteLogger logger() {
        return this.log;
    }

    public String schemaName() {
        return this.schema().getName();
    }

    public SchemaPlus schema() {
        return this.cfg.getDefaultSchema();
    }

    public IgniteTypeFactory typeFactory() {
        return this.typeFactory;
    }

    public RexBuilder rexBuilder() {
        return this.rexBuilder;
    }

    public SqlOperatorTable opTable() {
        if (this.opTable == null) {
            this.opTable = SqlOperatorTables.chain((SqlOperatorTable[])new SqlOperatorTable[]{this.config().getOperatorTable(), this.catalogReader()});
        }
        return this.opTable;
    }

    public CalciteCatalogReader catalogReader() {
        SchemaPlus dfltSchema;
        if (this.catalogReader != null) {
            return this.catalogReader;
        }
        SchemaPlus rootSchema = dfltSchema = this.schema();
        while (rootSchema.getParentSchema() != null) {
            rootSchema = rootSchema.getParentSchema();
        }
        this.catalogReader = new CalciteCatalogReader(CalciteSchema.from((SchemaPlus)rootSchema), CalciteSchema.from((SchemaPlus)dfltSchema).path(null), (RelDataTypeFactory)this.typeFactory(), CALCITE_CONNECTION_CONFIG);
        return this.catalogReader;
    }

    public GridQueryCancel queryCancel() {
        return this.qryCancel;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static BaseQueryContext empty() {
        return EMPTY_CONTEXT;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean isForcedJoinOrder() {
        return this.forcedJoinOrder;
    }

    public int[] partitions() {
        if (this.parts != null) {
            return Arrays.copyOf(this.parts, this.parts.length);
        }
        return null;
    }

    static {
        Properties props = new Properties();
        props.setProperty(CalciteConnectionProperty.CASE_SENSITIVE.camelName(), String.valueOf(CalciteQueryProcessor.FRAMEWORK_CONFIG.getParserConfig().caseSensitive()));
        props.setProperty(CalciteConnectionProperty.CONFORMANCE.camelName(), String.valueOf(CalciteQueryProcessor.FRAMEWORK_CONFIG.getParserConfig().conformance()));
        props.setProperty(CalciteConnectionProperty.MATERIALIZATIONS_ENABLED.camelName(), String.valueOf(true));
        CALCITE_CONNECTION_CONFIG = new CalciteConnectionConfigImpl(props);
        EMPTY_CONTEXT = BaseQueryContext.builder().build();
        EMPTY_PLANNER = new VolcanoPlanner(COST_FACTORY, EMPTY_CONTEXT){

            public void registerSchema(RelOptSchema schema) {
            }
        };
        RelDataTypeSystem typeSys = (RelDataTypeSystem)CALCITE_CONNECTION_CONFIG.typeSystem(RelDataTypeSystem.class, (Object)CalciteQueryProcessor.FRAMEWORK_CONFIG.getTypeSystem());
        TYPE_FACTORY = new IgniteTypeFactory(typeSys);
        REX_BUILDER = new IgniteRexBuilder((RelDataTypeFactory)TYPE_FACTORY);
        CLUSTER = RelOptCluster.create((RelOptPlanner)EMPTY_PLANNER, (RexBuilder)REX_BUILDER);
        final String cantBeUsedMsg = "Empty cluster can't be used for planning or mapping";
        CLUSTER.setMetadataProvider(new RelMetadataProvider(){

            public <M extends Metadata> UnboundMetadata<M> apply(Class<? extends RelNode> relCls, Class<? extends M> metadataCls) {
                throw new AssertionError((Object)cantBeUsedMsg);
            }

            public <M extends Metadata> Multimap<Method, MetadataHandler<M>> handlers(MetadataDef<M> def) {
                throw new AssertionError((Object)cantBeUsedMsg);
            }

            public List<MetadataHandler<?>> handlers(Class<? extends MetadataHandler<?>> hndCls) {
                throw new AssertionError((Object)cantBeUsedMsg);
            }
        });
        CLUSTER.setMetadataQuerySupplier(() -> {
            throw new AssertionError((Object)cantBeUsedMsg);
        });
    }

    public static class Builder {
        private static final FrameworkConfig EMPTY_CONFIG = Frameworks.newConfigBuilder((FrameworkConfig)CalciteQueryProcessor.FRAMEWORK_CONFIG).defaultSchema(Frameworks.createRootSchema((boolean)false)).build();
        private FrameworkConfig frameworkCfg = EMPTY_CONFIG;
        private Context parentCtx = Contexts.empty();
        private IgniteLogger log = new NullLogger();
        private boolean isLocal;
        private boolean forcedJoinOrder;
        private int[] parts = null;

        public Builder frameworkConfig(@NotNull FrameworkConfig frameworkCfg) {
            this.frameworkCfg = frameworkCfg;
            return this;
        }

        public Builder parentContext(@NotNull Context parentCtx) {
            this.parentCtx = parentCtx;
            return this;
        }

        public Builder logger(@NotNull IgniteLogger log) {
            this.log = log;
            return this;
        }

        public Builder local(boolean isLocal) {
            this.isLocal = isLocal;
            return this;
        }

        public Builder forcedJoinOrder(boolean forcedJoinOrder) {
            this.forcedJoinOrder = forcedJoinOrder;
            return this;
        }

        public Builder partitions(int[] parts) {
            if (parts != null) {
                this.parts = Arrays.copyOf(parts, parts.length);
            }
            return this;
        }

        public BaseQueryContext build() {
            return new BaseQueryContext(this.frameworkCfg, this.parentCtx, this.log, this.isLocal, this.forcedJoinOrder, this.parts);
        }
    }
}

