/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rule;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.PhysicalNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.Util;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.rel.set.IgniteColocatedIntersect;
import org.apache.ignite.internal.processors.query.calcite.rel.set.IgniteColocatedMinus;
import org.apache.ignite.internal.processors.query.calcite.rel.set.IgniteMapIntersect;
import org.apache.ignite.internal.processors.query.calcite.rel.set.IgniteMapMinus;
import org.apache.ignite.internal.processors.query.calcite.rel.set.IgniteReduceIntersect;
import org.apache.ignite.internal.processors.query.calcite.rel.set.IgniteReduceMinus;
import org.apache.ignite.internal.processors.query.calcite.rule.AbstractIgniteConverterRule;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistributions;

public class SetOpConverterRule {
    public static final RelOptRule COLOCATED_MINUS = new ColocatedMinusConverterRule();
    public static final RelOptRule COLOCATED_INTERSECT = new ColocatedIntersectConverterRule();
    public static final RelOptRule MAP_REDUCE_MINUS = new MapReduceMinusConverterRule();
    public static final RelOptRule MAP_REDUCE_INTERSECT = new MapReduceIntersectConverterRule();

    private SetOpConverterRule() {
    }

    private static class MapReduceIntersectConverterRule
    extends MapReduceSetOpConverterRule<LogicalIntersect> {
        MapReduceIntersectConverterRule() {
            super(LogicalIntersect.class, "MapReduceIntersectConverterRule");
        }

        @Override
        PhysicalNode createMapNode(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, boolean all) {
            return new IgniteMapIntersect(cluster, traits, inputs, all);
        }

        @Override
        PhysicalNode createReduceNode(RelOptCluster cluster, RelTraitSet traits, RelNode input, boolean all, RelDataType rowType) {
            return new IgniteReduceIntersect(cluster, traits, input, all, rowType);
        }
    }

    private static class MapReduceMinusConverterRule
    extends MapReduceSetOpConverterRule<LogicalMinus> {
        MapReduceMinusConverterRule() {
            super(LogicalMinus.class, "MapReduceMinusConverterRule");
        }

        @Override
        PhysicalNode createMapNode(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, boolean all) {
            return new IgniteMapMinus(cluster, traits, inputs, all);
        }

        @Override
        PhysicalNode createReduceNode(RelOptCluster cluster, RelTraitSet traits, RelNode input, boolean all, RelDataType rowType) {
            return new IgniteReduceMinus(cluster, traits, input, all, rowType);
        }
    }

    private static abstract class MapReduceSetOpConverterRule<T extends SetOp>
    extends AbstractIgniteConverterRule<T> {
        MapReduceSetOpConverterRule(Class<T> cls, String desc) {
            super(cls, desc);
        }

        abstract PhysicalNode createMapNode(RelOptCluster var1, RelTraitSet var2, List<RelNode> var3, boolean var4);

        abstract PhysicalNode createReduceNode(RelOptCluster var1, RelTraitSet var2, RelNode var3, boolean var4, RelDataType var5);

        @Override
        protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, T setOp) {
            RelOptCluster cluster = setOp.getCluster();
            RelTraitSet inTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE);
            RelTraitSet outTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE);
            List inputs = Util.transform((List)setOp.getInputs(), rel -> MapReduceSetOpConverterRule.convert((RelNode)rel, (RelTraitSet)inTrait));
            PhysicalNode map = this.createMapNode(cluster, outTrait, inputs, ((SetOp)setOp).all);
            return this.createReduceNode(cluster, outTrait.replace((RelTrait)IgniteDistributions.single()), MapReduceSetOpConverterRule.convert((RelNode)map, (RelTraitSet)inTrait.replace((RelTrait)IgniteDistributions.single())), ((SetOp)setOp).all, cluster.getTypeFactory().leastRestrictive(Util.transform((List)inputs, RelNode::getRowType)));
        }
    }

    private static class ColocatedIntersectConverterRule
    extends ColocatedSetOpConverterRule<LogicalIntersect> {
        ColocatedIntersectConverterRule() {
            super(LogicalIntersect.class, "ColocatedIntersectConverterRule");
        }

        @Override
        PhysicalNode createNode(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, boolean all) {
            return new IgniteColocatedIntersect(cluster, traits, inputs, all);
        }
    }

    private static class ColocatedMinusConverterRule
    extends ColocatedSetOpConverterRule<LogicalMinus> {
        ColocatedMinusConverterRule() {
            super(LogicalMinus.class, "ColocatedMinusConverterRule");
        }

        @Override
        PhysicalNode createNode(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, boolean all) {
            return new IgniteColocatedMinus(cluster, traits, inputs, all);
        }
    }

    private static abstract class ColocatedSetOpConverterRule<T extends SetOp>
    extends AbstractIgniteConverterRule<T> {
        ColocatedSetOpConverterRule(Class<T> cls, String desc) {
            super(cls, desc);
        }

        abstract PhysicalNode createNode(RelOptCluster var1, RelTraitSet var2, List<RelNode> var3, boolean var4);

        @Override
        protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, T setOp) {
            RelOptCluster cluster = setOp.getCluster();
            RelTraitSet inTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)IgniteDistributions.single());
            RelTraitSet outTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)IgniteDistributions.single());
            List inputs = Util.transform((List)setOp.getInputs(), rel -> ColocatedSetOpConverterRule.convert((RelNode)rel, (RelTraitSet)inTrait));
            return this.createNode(cluster, outTrait, inputs, ((SetOp)setOp).all);
        }
    }
}

