/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.schema;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.SystemViewScan;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.RangeIterable;
import org.apache.ignite.internal.processors.query.calcite.metadata.ColocationGroup;
import org.apache.ignite.internal.processors.query.calcite.prepare.bounds.SearchBounds;
import org.apache.ignite.internal.processors.query.calcite.rel.logical.IgniteLogicalIndexScan;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteIndex;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.apache.ignite.internal.processors.query.calcite.schema.SystemViewTableDescriptorImpl;
import org.apache.ignite.internal.processors.query.calcite.schema.SystemViewTableImpl;
import org.apache.ignite.internal.processors.query.calcite.util.RexUtils;
import org.jetbrains.annotations.Nullable;

public class SystemViewIndexImpl
implements IgniteIndex {
    private final String idxName;
    private final SystemViewTableImpl tbl;

    public SystemViewIndexImpl(SystemViewTableImpl tbl) {
        this.tbl = tbl;
        this.idxName = ((SystemViewTableDescriptorImpl)tbl.descriptor()).name() + "_IDX";
    }

    @Override
    public RelCollation collation() {
        return RelCollations.EMPTY;
    }

    @Override
    public String name() {
        return this.idxName;
    }

    @Override
    public IgniteTable table() {
        return this.tbl;
    }

    @Override
    public IgniteLogicalIndexScan toRel(RelOptCluster cluster, RelOptTable relOptTbl, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable ImmutableBitSet requiredColumns) {
        return IgniteLogicalIndexScan.create(cluster, cluster.traitSet(), relOptTbl, this.idxName, proj, cond, requiredColumns);
    }

    @Override
    public <Row> Iterable<Row> scan(ExecutionContext<Row> execCtx, ColocationGroup grp, RangeIterable<Row> ranges, @Nullable ImmutableBitSet requiredColumns) {
        return new SystemViewScan(execCtx, this.tbl.descriptor(), ranges, requiredColumns);
    }

    @Override
    public long count(ExecutionContext<?> ectx, ColocationGroup grp, boolean notNull) {
        assert (!notNull);
        return ((SystemViewTableDescriptorImpl)this.tbl.descriptor()).systemView().size();
    }

    @Override
    public <Row> Iterable<Row> firstOrLast(boolean first, ExecutionContext<Row> ectx, ColocationGroup grp, @Nullable ImmutableBitSet requiredColumns) {
        throw new IgniteException("Taking first or last value is not implemented for system view index.");
    }

    @Override
    public List<SearchBounds> toSearchBounds(RelOptCluster cluster, @Nullable RexNode cond, @Nullable ImmutableBitSet requiredColumns) {
        if (cond == null) {
            return null;
        }
        RelDataType rowType = this.tbl.getRowType(cluster.getTypeFactory());
        return RexUtils.buildHashSearchBounds(cluster, cond, rowType, requiredColumns, true);
    }

    @Override
    public boolean isInlineScanPossible(@Nullable ImmutableBitSet requiredColumns) {
        return false;
    }
}

