/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql2rel.NullInitializerExpressionFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.RowHandler;
import org.apache.ignite.internal.processors.query.calcite.metadata.ColocationGroup;
import org.apache.ignite.internal.processors.query.calcite.prepare.MappingQueryContext;
import org.apache.ignite.internal.processors.query.calcite.schema.SystemViewColumnDescriptor;
import org.apache.ignite.internal.processors.query.calcite.schema.TableDescriptor;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistribution;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistributions;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.calcite.util.TypeUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.systemview.view.SystemView;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;
import org.jetbrains.annotations.Nullable;

public class SystemViewTableDescriptorImpl<ViewRow>
extends NullInitializerExpressionFactory
implements TableDescriptor<ViewRow> {
    private static final SystemViewColumnDescriptor[] DUMMY = new SystemViewColumnDescriptor[0];
    private final SystemViewColumnDescriptor[] descriptors;
    private final Map<String, SystemViewColumnDescriptor> descriptorsMap;
    private final SystemView<ViewRow> sysView;

    public SystemViewTableDescriptorImpl(SystemView<ViewRow> sysView) {
        final ArrayList descriptors = new ArrayList(sysView.walker().count());
        final List filtrableAttrs = sysView.walker().filtrableAttributes();
        sysView.walker().visitAll(new SystemViewRowAttributeWalker.AttributeVisitor(){

            public <T> void accept(int idx, String name, Class<T> clazz) {
                descriptors.add(new SystemViewColumnDescriptorImpl(name, clazz, idx, filtrableAttrs.contains(name)));
            }
        });
        HashMap descriptorsMap = U.newHashMap((int)descriptors.size());
        for (SystemViewColumnDescriptor descriptor : descriptors) {
            descriptorsMap.put(descriptor.name(), descriptor);
        }
        this.sysView = sysView;
        this.descriptors = descriptors.toArray(DUMMY);
        this.descriptorsMap = descriptorsMap;
    }

    public String name() {
        return MetricUtils.toSqlName((String)this.sysView.name());
    }

    @Override
    public RelDataType insertRowType(IgniteTypeFactory factory) {
        return this.rowType(factory, null);
    }

    @Override
    public IgniteDistribution distribution() {
        return IgniteDistributions.single();
    }

    @Override
    public ColocationGroup colocationGroup(MappingQueryContext ctx) {
        return ColocationGroup.forNodes(Collections.singletonList(ctx.localNodeId()));
    }

    @Override
    public <Row> Row toRow(final ExecutionContext<Row> ectx, ViewRow row, RowHandler.RowFactory<Row> factory, final @Nullable ImmutableBitSet requiredColumns) {
        final RowHandler<Row> hnd = factory.handler();
        assert (hnd == ectx.rowHandler());
        final Row res = factory.create();
        assert (hnd.columnCount(res) == (requiredColumns == null ? this.descriptors.length : requiredColumns.cardinality()));
        this.sysView.walker().visitAll(row, new SystemViewRowAttributeWalker.AttributeWithValueVisitor(){
            private int colIdx;

            public <T> void accept(int idx, String name, Class<T> clazz, T val) {
                if (requiredColumns == null || requiredColumns.get(idx)) {
                    hnd.set(this.colIdx++, res, TypeUtils.toInternal(ectx, val, SystemViewTableDescriptorImpl.this.descriptors[idx].storageType()));
                }
            }

            public void acceptBoolean(int idx, String name, boolean val) {
                this.accept(idx, name, Boolean.class, val);
            }

            public void acceptChar(int idx, String name, char val) {
                this.accept(idx, name, Character.class, Character.valueOf(val));
            }

            public void acceptByte(int idx, String name, byte val) {
                this.accept(idx, name, Byte.class, val);
            }

            public void acceptShort(int idx, String name, short val) {
                this.accept(idx, name, Short.class, val);
            }

            public void acceptInt(int idx, String name, int val) {
                this.accept(idx, name, Integer.class, val);
            }

            public void acceptLong(int idx, String name, long val) {
                this.accept(idx, name, Long.class, val);
            }

            public void acceptFloat(int idx, String name, float val) {
                this.accept(idx, name, Float.class, Float.valueOf(val));
            }

            public void acceptDouble(int idx, String name, double val) {
                this.accept(idx, name, Double.class, val);
            }
        });
        return res;
    }

    @Override
    public boolean isUpdateAllowed(RelOptTable tbl, int colIdx) {
        return false;
    }

    @Override
    public RelDataType rowType(IgniteTypeFactory factory, ImmutableBitSet usedColumns) {
        RelDataTypeFactory.Builder b = new RelDataTypeFactory.Builder((RelDataTypeFactory)factory);
        if (usedColumns == null) {
            for (int i = 0; i < this.descriptors.length; ++i) {
                b.add(this.descriptors[i].name(), this.descriptors[i].logicalType(factory));
            }
        } else {
            int i = usedColumns.nextSetBit(0);
            while (i != -1) {
                b.add(this.descriptors[i].name(), this.descriptors[i].logicalType(factory));
                i = usedColumns.nextSetBit(i + 1);
            }
        }
        return b.build();
    }

    @Override
    public SystemViewColumnDescriptor columnDescriptor(String fieldName) {
        return fieldName == null ? null : this.descriptorsMap.get(fieldName);
    }

    @Override
    public Collection<SystemViewColumnDescriptor> columnDescriptors() {
        return Collections.unmodifiableList(Arrays.asList(this.descriptors));
    }

    public SystemView<ViewRow> systemView() {
        return this.sysView;
    }

    public boolean isFiltrable() {
        return !F.isEmpty((Collection)this.sysView.walker().filtrableAttributes());
    }

    private static class SystemViewColumnDescriptorImpl
    implements SystemViewColumnDescriptor {
        private final String sqlName;
        private final String originalName;
        private final int fieldIdx;
        private final Class<?> type;
        private final boolean isFiltrable;
        private volatile RelDataType logicalType;

        private SystemViewColumnDescriptorImpl(String name, Class<?> type, int fieldIdx, boolean isFiltrable) {
            this.originalName = name;
            this.sqlName = MetricUtils.toSqlName((String)name);
            this.fieldIdx = fieldIdx;
            this.type = type;
            this.isFiltrable = isFiltrable;
        }

        @Override
        public boolean hasDefaultValue() {
            return false;
        }

        @Override
        public Object defaultValue() {
            throw new AssertionError();
        }

        @Override
        public String name() {
            return this.sqlName;
        }

        @Override
        public String originalName() {
            return this.originalName;
        }

        @Override
        public int fieldIndex() {
            return this.fieldIdx;
        }

        @Override
        public RelDataType logicalType(IgniteTypeFactory f) {
            if (this.logicalType == null) {
                this.logicalType = TypeUtils.sqlType(f, this.type, -1, Integer.MIN_VALUE);
            }
            return this.logicalType;
        }

        @Override
        public Class<?> storageType() {
            return this.type;
        }

        @Override
        public boolean isFiltrable() {
            return this.isFiltrable;
        }
    }
}

