/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.util;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.calcite.DataContext;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlUnknownLiteral;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.DateValueUtils;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.RowHandler;
import org.apache.ignite.internal.processors.query.calcite.schema.ColumnDescriptor;
import org.apache.ignite.internal.processors.query.calcite.schema.TableDescriptor;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeSystem;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeUtils {
    private static final Set<Type> CONVERTABLE_TYPES = ImmutableSet.of(java.util.Date.class, Date.class, Time.class, Timestamp.class, LocalDateTime.class, LocalDate.class, (Object[])new Type[]{LocalTime.class, Duration.class, Period.class, byte[].class});

    public static RelDataType combinedRowType(IgniteTypeFactory typeFactory, RelDataType ... types) {
        RelDataTypeFactory.Builder builder = new RelDataTypeFactory.Builder((RelDataTypeFactory)typeFactory);
        HashSet<String> names = new HashSet<String>();
        for (RelDataType type : types) {
            for (RelDataTypeField field : type.getFieldList()) {
                int idx = 0;
                String fieldName = field.getName();
                while (!names.add(fieldName)) {
                    fieldName = field.getName() + idx++;
                }
                builder.add(fieldName, field.getType());
            }
        }
        return builder.build();
    }

    public static boolean needCast(RelDataTypeFactory factory, RelDataType fromType, RelDataType toType) {
        if (fromType instanceof RelDataTypeFactoryImpl.JavaType && toType.getSqlTypeName() == fromType.getSqlTypeName()) {
            return false;
        }
        if (toType.getSqlTypeName() == SqlTypeName.ANY || fromType.getSqlTypeName() == SqlTypeName.ANY) {
            return toType.getClass() != fromType.getClass();
        }
        if (SqlTypeUtil.isCharacter((RelDataType)toType) && SqlTypeUtil.isCharacter((RelDataType)fromType)) {
            return false;
        }
        if (fromType.getPrecedenceList().containsType(toType) && SqlTypeUtil.isIntType((RelDataType)fromType) && SqlTypeUtil.isIntType((RelDataType)toType)) {
            return false;
        }
        if (SqlTypeUtil.equalSansNullability((RelDataTypeFactory)factory, (RelDataType)fromType, (RelDataType)toType)) {
            return false;
        }
        assert (SqlTypeUtil.canCastFrom((RelDataType)toType, (RelDataType)fromType, (boolean)true));
        return true;
    }

    @NotNull
    public static RelDataType createRowType(@NotNull IgniteTypeFactory typeFactory, Class<?> ... fields) {
        List<RelDataType> types = Arrays.stream(fields).map(arg_0 -> ((IgniteTypeFactory)typeFactory).createJavaType(arg_0)).collect(Collectors.toList());
        return TypeUtils.createRowType(typeFactory, types, "$F");
    }

    @NotNull
    public static RelDataType createRowType(@NotNull IgniteTypeFactory typeFactory, RelDataType ... fields) {
        List<RelDataType> types = Arrays.asList(fields);
        return TypeUtils.createRowType(typeFactory, types, "$F");
    }

    private static RelDataType createRowType(IgniteTypeFactory typeFactory, List<RelDataType> fields, String namePreffix) {
        List names = IntStream.range(0, fields.size()).mapToObj(ord -> namePreffix + ord).collect(Collectors.toList());
        return typeFactory.createStructType(fields, names);
    }

    public static RelDataType sqlType(IgniteTypeFactory typeFactory, Class<?> cls, int precision, int scale) {
        RelDataType javaType = typeFactory.createJavaType(cls);
        if (javaType.getSqlTypeName().allowsPrecScale(true, true) && (precision != -1 || scale != Integer.MIN_VALUE)) {
            return typeFactory.createSqlType(javaType.getSqlTypeName(), precision, scale);
        }
        return TypeUtils.sqlType(typeFactory, javaType);
    }

    private static RelDataType sqlType(IgniteTypeFactory typeFactory, RelDataType rowType) {
        if (!rowType.isStruct()) {
            return typeFactory.toSql(rowType);
        }
        return typeFactory.createStructType(Commons.transform(rowType.getFieldList(), f -> Pair.of((Object)f.getName(), (Object)TypeUtils.sqlType(typeFactory, f.getType()))));
    }

    public static RelDataType getResultType(IgniteTypeFactory typeFactory, RelOptSchema schema, RelDataType sqlType, @Nullable List<List<String>> origins) {
        assert (origins == null || origins.size() == sqlType.getFieldCount());
        RelDataTypeFactory.Builder b = new RelDataTypeFactory.Builder((RelDataTypeFactory)typeFactory);
        List fields = sqlType.getFieldList();
        for (int i = 0; i < sqlType.getFieldCount(); ++i) {
            List<String> origin = origins == null ? null : origins.get(i);
            b.add(((RelDataTypeField)fields.get(i)).getName(), typeFactory.createType(TypeUtils.getResultClass(typeFactory, schema, ((RelDataTypeField)fields.get(i)).getType(), origin)));
        }
        return b.build();
    }

    private static Type getResultClass(IgniteTypeFactory typeFactory, RelOptSchema schema, RelDataType type, @Nullable List<String> origin) {
        if (F.isEmpty(origin)) {
            return typeFactory.getResultClass(type);
        }
        RelOptTable table = schema.getTableForMember(origin.subList(0, 2));
        assert (table != null);
        ColumnDescriptor fldDesc = ((TableDescriptor)table.unwrap(TableDescriptor.class)).columnDescriptor(origin.get(2));
        assert (fldDesc != null);
        return fldDesc.storageType();
    }

    public static <Row> Function<Row, Row> resultTypeConverter(ExecutionContext<Row> ectx, RelDataType resultType) {
        assert (resultType.isStruct());
        if (TypeUtils.hasConvertableFields(resultType)) {
            RowHandler handler = ectx.rowHandler();
            List types = RelOptUtil.getFieldTypeList((RelDataType)resultType);
            RowHandler.RowFactory factory = handler.factory(ectx.getTypeFactory(), types);
            List<Function> converters = Commons.transform(types, t -> TypeUtils.fieldConverter(ectx, t));
            return r -> {
                Object newRow = factory.create();
                assert (handler.columnCount(newRow) == converters.size());
                assert (handler.columnCount(r) == converters.size());
                for (int i = 0; i < converters.size(); ++i) {
                    handler.set(i, newRow, ((Function)converters.get(i)).apply(handler.get(i, r)));
                }
                return newRow;
            };
        }
        return Function.identity();
    }

    private static Function<Object, Object> fieldConverter(ExecutionContext<?> ectx, RelDataType fieldType) {
        Type storageType = ectx.getTypeFactory().getJavaClass(fieldType);
        if (TypeUtils.isConvertableType(storageType)) {
            return v -> TypeUtils.fromInternal(ectx, v, storageType);
        }
        return Function.identity();
    }

    public static boolean isConvertableType(Type type) {
        return CONVERTABLE_TYPES.contains(type);
    }

    public static boolean isConvertableType(RelDataType type) {
        return type instanceof RelDataTypeFactoryImpl.JavaType && TypeUtils.isConvertableType(((RelDataTypeFactoryImpl.JavaType)type).getJavaClass());
    }

    private static boolean hasConvertableFields(RelDataType resultType) {
        return RelOptUtil.getFieldTypeList((RelDataType)resultType).stream().anyMatch(TypeUtils::isConvertableType);
    }

    public static boolean hasPrecision(RelDataType type) {
        if (type.getSqlTypeName() == SqlTypeName.DECIMAL && type.getPrecision() == IgniteTypeSystem.INSTANCE.getDefaultPrecision(SqlTypeName.DECIMAL)) {
            return false;
        }
        return type.getPrecision() != -1;
    }

    public static boolean hasScale(RelDataType type) {
        if (type.getSqlTypeName() == SqlTypeName.DECIMAL && type.getPrecision() == IgniteTypeSystem.INSTANCE.getDefaultPrecision(SqlTypeName.DECIMAL)) {
            return false;
        }
        return type.getScale() != Integer.MIN_VALUE;
    }

    public static Object toInternal(DataContext ctx, Object val) {
        return val == null ? null : TypeUtils.toInternal(ctx, val, val.getClass());
    }

    public static Object toInternal(DataContext ctx, Object val, Type storageType) {
        if (val == null) {
            return null;
        }
        if (storageType == Date.class) {
            return (int)(TypeUtils.toLong(ctx, val) / 86400000L);
        }
        if (storageType == LocalDate.class) {
            return (int)(TypeUtils.toLong(ctx, val) / 86400000L);
        }
        if (storageType == Time.class) {
            return (int)(TypeUtils.toLong(ctx, val) % 86400000L);
        }
        if (storageType == LocalTime.class) {
            return (int)(TypeUtils.toLong(ctx, val) % 86400000L);
        }
        if (storageType == Timestamp.class || storageType == LocalDateTime.class) {
            return TypeUtils.toLong(ctx, val);
        }
        if (storageType == java.util.Date.class) {
            return TypeUtils.toLong(ctx, val);
        }
        if (storageType == java.util.Date.class) {
            return TypeUtils.toLong(ctx, val);
        }
        if (storageType == Duration.class) {
            return TimeUnit.SECONDS.toMillis(((Duration)val).getSeconds()) + TimeUnit.NANOSECONDS.toMillis(((Duration)val).getNano());
        }
        if (storageType == Period.class) {
            return (int)((Period)val).toTotalMonths();
        }
        if (storageType == byte[].class) {
            return new ByteString((byte[])val);
        }
        if (val instanceof Number && storageType != val.getClass()) {
            Number num = (Number)val;
            return Byte.class.equals((Object)storageType) || Byte.TYPE.equals(storageType) ? (Number)SqlFunctions.toByte((Number)num) : (Number)(Short.class.equals((Object)storageType) || Short.TYPE.equals(storageType) ? (Number)SqlFunctions.toShort((Number)num) : (Number)(Integer.class.equals((Object)storageType) || Integer.TYPE.equals(storageType) ? (Number)SqlFunctions.toInt((Number)num) : (Number)(Long.class.equals((Object)storageType) || Long.TYPE.equals(storageType) ? (Number)SqlFunctions.toLong((Number)num) : (Number)(Float.class.equals((Object)storageType) || Float.TYPE.equals(storageType) ? (Number)Float.valueOf(SqlFunctions.toFloat((Number)num)) : (Number)(Double.class.equals((Object)storageType) || Double.TYPE.equals(storageType) ? (Number)SqlFunctions.toDouble((Number)num) : (Number)(BigDecimal.class.equals((Object)storageType) ? SqlFunctions.toBigDecimal((Number)num) : num))))));
        }
        return val;
    }

    private static long toLong(DataContext ctx, Object val) {
        if (val instanceof LocalDateTime) {
            return TypeUtils.toLong(DateValueUtils.convertToTimestamp((LocalDateTime)((LocalDateTime)val)), (TimeZone)DataContext.Variable.TIME_ZONE.get(ctx));
        }
        if (val instanceof LocalDate) {
            return TypeUtils.toLong(DateValueUtils.convertToSqlDate((LocalDate)((LocalDate)val)), (TimeZone)DataContext.Variable.TIME_ZONE.get(ctx));
        }
        if (val instanceof LocalTime) {
            return TypeUtils.toLong(DateValueUtils.convertToSqlTime((LocalTime)((LocalTime)val)), (TimeZone)DataContext.Variable.TIME_ZONE.get(ctx));
        }
        return TypeUtils.toLong((java.util.Date)val, (TimeZone)DataContext.Variable.TIME_ZONE.get(ctx));
    }

    private static long toLong(java.util.Date val, TimeZone tz) {
        long time = val.getTime();
        return time + (long)tz.getOffset(time);
    }

    public static Object fromInternal(DataContext ctx, Object val, Type storageType) {
        if (val == null) {
            return null;
        }
        if (storageType == Date.class && val instanceof Integer) {
            return new Date(TypeUtils.fromLocalTs(ctx, (long)((Integer)val).intValue() * 86400000L));
        }
        if (storageType == LocalDate.class && val instanceof Integer) {
            return new Date(TypeUtils.fromLocalTs(ctx, (long)((Integer)val).intValue() * 86400000L)).toLocalDate();
        }
        if (storageType == Time.class && val instanceof Integer) {
            return new Time(TypeUtils.fromLocalTs(ctx, ((Integer)val).intValue()));
        }
        if (storageType == LocalTime.class && val instanceof Integer) {
            return Instant.ofEpochMilli(((Integer)val).intValue()).atZone(ZoneOffset.UTC).toLocalTime();
        }
        if (storageType == Timestamp.class && val instanceof Long) {
            return new Timestamp(TypeUtils.fromLocalTs(ctx, (Long)val));
        }
        if (storageType == LocalDateTime.class && val instanceof Long) {
            return new Timestamp(TypeUtils.fromLocalTs(ctx, (Long)val)).toLocalDateTime();
        }
        if (storageType == java.util.Date.class && val instanceof Long) {
            return new java.util.Date(TypeUtils.fromLocalTs(ctx, (Long)val));
        }
        if (storageType == Duration.class && val instanceof Long) {
            return Duration.ofMillis((Long)val);
        }
        if (storageType == Period.class && val instanceof Integer) {
            return Period.of((Integer)val / 12, (Integer)val % 12, 0);
        }
        if (storageType == byte[].class && val instanceof ByteString) {
            return ((ByteString)val).getBytes();
        }
        return val;
    }

    public static Object fromLiteral(DataContext ctx, Type storageType, SqlLiteral literal) {
        Object internalVal;
        block12: {
            try {
                storageType = Primitive.box((Type)storageType);
                if (Date.class.equals((Object)storageType)) {
                    SqlLiteral literal0 = ((SqlUnknownLiteral)literal).resolve(SqlTypeName.DATE);
                    internalVal = ((DateString)literal0.getValueAs(DateString.class)).getDaysSinceEpoch();
                    break block12;
                }
                if (Time.class.equals((Object)storageType)) {
                    SqlLiteral literal0 = ((SqlUnknownLiteral)literal).resolve(SqlTypeName.TIME);
                    internalVal = ((TimeString)literal0.getValueAs(TimeString.class)).getMillisOfDay();
                    break block12;
                }
                if (Timestamp.class.equals((Object)storageType)) {
                    SqlLiteral literal0 = ((SqlUnknownLiteral)literal).resolve(SqlTypeName.TIMESTAMP);
                    internalVal = ((TimestampString)literal0.getValueAs(TimestampString.class)).getMillisSinceEpoch();
                    break block12;
                }
                if (Duration.class.equals((Object)storageType)) {
                    if (literal instanceof SqlIntervalLiteral && !((SqlIntervalLiteral.IntervalValue)literal.getValueAs(SqlIntervalLiteral.IntervalValue.class)).getIntervalQualifier().isYearMonth()) {
                        internalVal = literal.getValueAs(Long.class);
                        break block12;
                    }
                    throw new IgniteException("Expected DAY-TIME interval literal");
                }
                if (Period.class.equals((Object)storageType)) {
                    if (literal instanceof SqlIntervalLiteral && ((SqlIntervalLiteral.IntervalValue)literal.getValueAs(SqlIntervalLiteral.IntervalValue.class)).getIntervalQualifier().isYearMonth()) {
                        internalVal = ((Long)literal.getValueAs(Long.class)).intValue();
                        break block12;
                    }
                    throw new IgniteException("Expected YEAR-MONTH interval literal");
                }
                if (UUID.class.equals((Object)storageType)) {
                    if (literal instanceof SqlCharStringLiteral) {
                        internalVal = UUID.fromString((String)literal.getValueAs(String.class));
                        break block12;
                    }
                    throw new IgniteException("Expected string literal");
                }
                if (storageType instanceof Class) {
                    internalVal = literal.getValueAs((Class)storageType);
                    break block12;
                }
                throw new IgniteException("Unexpected storage type: " + storageType);
            }
            catch (Throwable t) {
                throw new IgniteSQLException("Cannot convert literal " + literal + " to type " + storageType, 2002, t);
            }
        }
        return TypeUtils.fromInternal(ctx, internalVal, storageType);
    }

    private static long fromLocalTs(DataContext ctx, long ts) {
        TimeZone tz = (TimeZone)DataContext.Variable.TIME_ZONE.get(ctx);
        return ts - (long)tz.getOffset(ts - (long)tz.getOffset(ts));
    }

    public static RexNode toRexLiteral(Object dfltVal, RelDataType type, DataContext ctx, RexBuilder rexBuilder) {
        dfltVal = dfltVal instanceof UUID ? dfltVal.toString() : TypeUtils.toInternal(ctx, dfltVal);
        return rexBuilder.makeLiteral(dfltVal, type, true);
    }
}

