package org.apache.ignite.internal.processors.query.calcite.rule.logical;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.tools.RelBuilderFactory;
import org.immutables.value.Generated;

/**
 * {@code ImmutableFilterScanMergeRule} contains immutable implementation classes generated from
 * abstract value types defined as nested inside {@link FilterScanMergeRule}.
 * @see ImmutableFilterScanMergeRule.Config
 */
@Generated(from = "FilterScanMergeRule", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
final class ImmutableFilterScanMergeRule {
  private ImmutableFilterScanMergeRule() {}

  /**
   * Immutable implementation of {@link FilterScanMergeRule.Config}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableFilterScanMergeRule.Config.builder()}.
   */
  @Generated(from = "FilterScanMergeRule.Config", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class Config
      implements FilterScanMergeRule.Config {
    private final RelBuilderFactory relBuilderFactory;
    private final @Nullable String description;
    private final RelRule.OperandTransform operandSupplier;
    private final Function<FilterScanMergeRule.Config, RelOptRule> ruleFactory;
    private final boolean skipCorrelated;

    private Config(ImmutableFilterScanMergeRule.Config.Builder builder) {
      this.description = builder.description;
      this.ruleFactory = builder.ruleFactory;
      if (builder.relBuilderFactory != null) {
        initShim.withRelBuilderFactory(builder.relBuilderFactory);
      }
      if (builder.operandSupplier != null) {
        initShim.withOperandSupplier(builder.operandSupplier);
      }
      if (builder.skipCorrelatedIsSet()) {
        initShim.withSkipCorrelated(builder.skipCorrelated);
      }
      this.relBuilderFactory = initShim.relBuilderFactory();
      this.operandSupplier = initShim.operandSupplier();
      this.skipCorrelated = initShim.isSkipCorrelated();
      this.initShim = null;
    }

    private Config(
        RelBuilderFactory relBuilderFactory,
        @Nullable String description,
        RelRule.OperandTransform operandSupplier,
        Function<FilterScanMergeRule.Config, RelOptRule> ruleFactory,
        boolean skipCorrelated) {
      this.relBuilderFactory = relBuilderFactory;
      this.description = description;
      this.operandSupplier = operandSupplier;
      this.ruleFactory = ruleFactory;
      this.skipCorrelated = skipCorrelated;
      this.initShim = null;
    }

    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    @SuppressWarnings("Immutable")
    private transient volatile InitShim initShim = new InitShim();

    @Generated(from = "FilterScanMergeRule.Config", generator = "Immutables")
    private final class InitShim {
      private byte relBuilderFactoryBuildStage = STAGE_UNINITIALIZED;
      private RelBuilderFactory relBuilderFactory;

      RelBuilderFactory relBuilderFactory() {
        if (relBuilderFactoryBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (relBuilderFactoryBuildStage == STAGE_UNINITIALIZED) {
          relBuilderFactoryBuildStage = STAGE_INITIALIZING;
          this.relBuilderFactory = Objects.requireNonNull(relBuilderFactoryInitialize(), "relBuilderFactory");
          relBuilderFactoryBuildStage = STAGE_INITIALIZED;
        }
        return this.relBuilderFactory;
      }

      void withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
        this.relBuilderFactory = relBuilderFactory;
        relBuilderFactoryBuildStage = STAGE_INITIALIZED;
      }

      private byte operandSupplierBuildStage = STAGE_UNINITIALIZED;
      private RelRule.OperandTransform operandSupplier;

      RelRule.OperandTransform operandSupplier() {
        if (operandSupplierBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (operandSupplierBuildStage == STAGE_UNINITIALIZED) {
          operandSupplierBuildStage = STAGE_INITIALIZING;
          this.operandSupplier = Objects.requireNonNull(operandSupplierInitialize(), "operandSupplier");
          operandSupplierBuildStage = STAGE_INITIALIZED;
        }
        return this.operandSupplier;
      }

      void withOperandSupplier(RelRule.OperandTransform operandSupplier) {
        this.operandSupplier = operandSupplier;
        operandSupplierBuildStage = STAGE_INITIALIZED;
      }

      private byte skipCorrelatedBuildStage = STAGE_UNINITIALIZED;
      private boolean skipCorrelated;

      boolean isSkipCorrelated() {
        if (skipCorrelatedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (skipCorrelatedBuildStage == STAGE_UNINITIALIZED) {
          skipCorrelatedBuildStage = STAGE_INITIALIZING;
          this.skipCorrelated = isSkipCorrelatedInitialize();
          skipCorrelatedBuildStage = STAGE_INITIALIZED;
        }
        return this.skipCorrelated;
      }

      void withSkipCorrelated(boolean skipCorrelated) {
        this.skipCorrelated = skipCorrelated;
        skipCorrelatedBuildStage = STAGE_INITIALIZED;
      }

      private String formatInitCycleMessage() {
        List<String> attributes = new ArrayList<>();
        if (relBuilderFactoryBuildStage == STAGE_INITIALIZING) attributes.add("relBuilderFactory");
        if (operandSupplierBuildStage == STAGE_INITIALIZING) attributes.add("operandSupplier");
        if (skipCorrelatedBuildStage == STAGE_INITIALIZING) attributes.add("skipCorrelated");
        return "Cannot build Config, attribute initializers form cycle " + attributes;
      }
    }

    private RelBuilderFactory relBuilderFactoryInitialize() {
      return FilterScanMergeRule.Config.super.relBuilderFactory();
    }

    private RelRule.OperandTransform operandSupplierInitialize() {
      return FilterScanMergeRule.Config.super.operandSupplier();
    }

    private boolean isSkipCorrelatedInitialize() {
      return FilterScanMergeRule.Config.super.isSkipCorrelated();
    }

    /**
     * @return The value of the {@code relBuilderFactory} attribute
     */
    @Override
    public RelBuilderFactory relBuilderFactory() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.relBuilderFactory()
          : this.relBuilderFactory;
    }

    /**
     * @return The value of the {@code description} attribute
     */
    @Override
    public @Nullable String description() {
      return description;
    }

    /**
     * @return The value of the {@code operandSupplier} attribute
     */
    @Override
    public RelRule.OperandTransform operandSupplier() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.operandSupplier()
          : this.operandSupplier;
    }

    /**
     * @return The value of the {@code ruleFactory} attribute
     */
    @Override
    public Function<FilterScanMergeRule.Config, RelOptRule> ruleFactory() {
      return ruleFactory;
    }

    /**
     * @return The value of the {@code skipCorrelated} attribute
     */
    @Override
    public boolean isSkipCorrelated() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.isSkipCorrelated()
          : this.skipCorrelated;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link FilterScanMergeRule.Config#relBuilderFactory() relBuilderFactory} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for relBuilderFactory
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableFilterScanMergeRule.Config withRelBuilderFactory(RelBuilderFactory value) {
      if (this.relBuilderFactory == value) return this;
      RelBuilderFactory newValue = Objects.requireNonNull(value, "relBuilderFactory");
      return new ImmutableFilterScanMergeRule.Config(newValue, this.description, this.operandSupplier, this.ruleFactory, this.skipCorrelated);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link FilterScanMergeRule.Config#description() description} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for description (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableFilterScanMergeRule.Config withDescription(@Nullable String value) {
      if (Objects.equals(this.description, value)) return this;
      return new ImmutableFilterScanMergeRule.Config(this.relBuilderFactory, value, this.operandSupplier, this.ruleFactory, this.skipCorrelated);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link FilterScanMergeRule.Config#operandSupplier() operandSupplier} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for operandSupplier
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableFilterScanMergeRule.Config withOperandSupplier(RelRule.OperandTransform value) {
      if (this.operandSupplier == value) return this;
      RelRule.OperandTransform newValue = Objects.requireNonNull(value, "operandSupplier");
      return new ImmutableFilterScanMergeRule.Config(this.relBuilderFactory, this.description, newValue, this.ruleFactory, this.skipCorrelated);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link FilterScanMergeRule.Config#ruleFactory() ruleFactory} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for ruleFactory
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableFilterScanMergeRule.Config withRuleFactory(Function<FilterScanMergeRule.Config, RelOptRule> value) {
      if (this.ruleFactory == value) return this;
      Function<FilterScanMergeRule.Config, RelOptRule> newValue = Objects.requireNonNull(value, "ruleFactory");
      return new ImmutableFilterScanMergeRule.Config(this.relBuilderFactory, this.description, this.operandSupplier, newValue, this.skipCorrelated);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link FilterScanMergeRule.Config#isSkipCorrelated() skipCorrelated} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for skipCorrelated
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableFilterScanMergeRule.Config withSkipCorrelated(boolean value) {
      if (this.skipCorrelated == value) return this;
      return new ImmutableFilterScanMergeRule.Config(this.relBuilderFactory, this.description, this.operandSupplier, this.ruleFactory, value);
    }

    /**
     * This instance is equal to all instances of {@code Config} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableFilterScanMergeRule.Config
          && equalTo((ImmutableFilterScanMergeRule.Config) another);
    }

    private boolean equalTo(ImmutableFilterScanMergeRule.Config another) {
      return relBuilderFactory.equals(another.relBuilderFactory)
          && Objects.equals(description, another.description)
          && operandSupplier.equals(another.operandSupplier)
          && ruleFactory.equals(another.ruleFactory)
          && skipCorrelated == another.skipCorrelated;
    }

    /**
     * Computes a hash code from attributes: {@code relBuilderFactory}, {@code description}, {@code operandSupplier}, {@code ruleFactory}, {@code skipCorrelated}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + relBuilderFactory.hashCode();
      h += (h << 5) + Objects.hashCode(description);
      h += (h << 5) + operandSupplier.hashCode();
      h += (h << 5) + ruleFactory.hashCode();
      h += (h << 5) + Booleans.hashCode(skipCorrelated);
      return h;
    }

    /**
     * Prints the immutable value {@code Config} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Config")
          .omitNullValues()
          .add("relBuilderFactory", relBuilderFactory)
          .add("description", description)
          .add("operandSupplier", operandSupplier)
          .add("ruleFactory", ruleFactory)
          .add("skipCorrelated", skipCorrelated)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link FilterScanMergeRule.Config} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Config instance
     */
    public static ImmutableFilterScanMergeRule.Config copyOf(FilterScanMergeRule.Config instance) {
      if (instance instanceof ImmutableFilterScanMergeRule.Config) {
        return (ImmutableFilterScanMergeRule.Config) instance;
      }
      return ImmutableFilterScanMergeRule.Config.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableFilterScanMergeRule.Config Config}.
     * <pre>
     * ImmutableFilterScanMergeRule.Config.builder()
     *    .withRelBuilderFactory(org.apache.calcite.tools.RelBuilderFactory) // optional {@link FilterScanMergeRule.Config#relBuilderFactory() relBuilderFactory}
     *    .withDescription(String | null) // nullable {@link FilterScanMergeRule.Config#description() description}
     *    .withOperandSupplier(org.apache.calcite.plan.RelRule.OperandTransform) // optional {@link FilterScanMergeRule.Config#operandSupplier() operandSupplier}
     *    .withRuleFactory(function.Function&amp;lt;org.apache.ignite.internal.processors.query.calcite.rule.logical.FilterScanMergeRule.Config, org.apache.calcite.plan.RelOptRule&amp;gt;) // required {@link FilterScanMergeRule.Config#ruleFactory() ruleFactory}
     *    .withSkipCorrelated(boolean) // optional {@link FilterScanMergeRule.Config#isSkipCorrelated() skipCorrelated}
     *    .build();
     * </pre>
     * @return A new Config builder
     */
    public static ImmutableFilterScanMergeRule.Config.Builder builder() {
      return new ImmutableFilterScanMergeRule.Config.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableFilterScanMergeRule.Config Config}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "FilterScanMergeRule.Config", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_RULE_FACTORY = 0x1L;
      private static final long OPT_BIT_SKIP_CORRELATED = 0x1L;
      private long initBits = 0x1L;
      private long optBits;

      private @Nullable RelBuilderFactory relBuilderFactory;
      private @Nullable String description;
      private @Nullable RelRule.OperandTransform operandSupplier;
      private @Nullable Function<FilterScanMergeRule.Config, RelOptRule> ruleFactory;
      private boolean skipCorrelated;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.apache.calcite.plan.RelRule.Config} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(RelRule.Config instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.apache.ignite.internal.processors.query.calcite.rule.logical.FilterScanMergeRule.Config} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(FilterScanMergeRule.Config instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      private void from(Object object) {
        if (object instanceof RelRule.Config) {
          RelRule.Config instance = (RelRule.Config) object;
          withRelBuilderFactory(instance.relBuilderFactory());
          withOperandSupplier(instance.operandSupplier());
          @Nullable String descriptionValue = instance.description();
          if (descriptionValue != null) {
            withDescription(descriptionValue);
          }
        }
        if (object instanceof FilterScanMergeRule.Config) {
          FilterScanMergeRule.Config instance = (FilterScanMergeRule.Config) object;
          withSkipCorrelated(instance.isSkipCorrelated());
          withRuleFactory(instance.ruleFactory());
        }
      }

      /**
       * Initializes the value for the {@link FilterScanMergeRule.Config#relBuilderFactory() relBuilderFactory} attribute.
       * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link FilterScanMergeRule.Config#relBuilderFactory() relBuilderFactory}.</em>
       * @param relBuilderFactory The value for relBuilderFactory 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
        this.relBuilderFactory = Objects.requireNonNull(relBuilderFactory, "relBuilderFactory");
        return this;
      }

      /**
       * Initializes the value for the {@link FilterScanMergeRule.Config#description() description} attribute.
       * @param description The value for description (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder withDescription(@Nullable String description) {
        this.description = description;
        return this;
      }

      /**
       * Initializes the value for the {@link FilterScanMergeRule.Config#operandSupplier() operandSupplier} attribute.
       * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link FilterScanMergeRule.Config#operandSupplier() operandSupplier}.</em>
       * @param operandSupplier The value for operandSupplier 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder withOperandSupplier(RelRule.OperandTransform operandSupplier) {
        this.operandSupplier = Objects.requireNonNull(operandSupplier, "operandSupplier");
        return this;
      }

      /**
       * Initializes the value for the {@link FilterScanMergeRule.Config#ruleFactory() ruleFactory} attribute.
       * @param ruleFactory The value for ruleFactory 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder withRuleFactory(Function<FilterScanMergeRule.Config, RelOptRule> ruleFactory) {
        this.ruleFactory = Objects.requireNonNull(ruleFactory, "ruleFactory");
        initBits &= ~INIT_BIT_RULE_FACTORY;
        return this;
      }

      /**
       * Initializes the value for the {@link FilterScanMergeRule.Config#isSkipCorrelated() skipCorrelated} attribute.
       * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link FilterScanMergeRule.Config#isSkipCorrelated() skipCorrelated}.</em>
       * @param skipCorrelated The value for skipCorrelated 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder withSkipCorrelated(boolean skipCorrelated) {
        this.skipCorrelated = skipCorrelated;
        optBits |= OPT_BIT_SKIP_CORRELATED;
        return this;
      }

      /**
       * Builds a new {@link ImmutableFilterScanMergeRule.Config Config}.
       * @return An immutable instance of Config
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableFilterScanMergeRule.Config build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableFilterScanMergeRule.Config(this);
      }

      private boolean skipCorrelatedIsSet() {
        return (optBits & OPT_BIT_SKIP_CORRELATED) != 0;
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_RULE_FACTORY) != 0) attributes.add("ruleFactory");
        return "Cannot build Config, some of required attributes are not set " + attributes;
      }
    }
  }
}
