/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.commandline.ConnectionAndSslParameters;
import org.apache.ignite.internal.commandline.argument.parser.CLIArgument;
import org.apache.ignite.internal.commandline.argument.parser.CLIArgumentParser;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.IgniteCommandRegistry;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.ArgumentGroup;
import org.apache.ignite.internal.management.api.CliSubcommandsWithPrefix;
import org.apache.ignite.internal.management.api.Command;
import org.apache.ignite.internal.management.api.CommandUtils;
import org.apache.ignite.internal.management.api.CommandsRegistry;
import org.apache.ignite.internal.management.api.Positional;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteExperimental;
import org.apache.ignite.ssl.SslContextFactory;

public class ArgumentParser {
    private final IgniteLogger log;
    private final IgniteCommandRegistry registry;
    Deque<Command<?, ?>> cmdPath = new ArrayDeque();
    static final String CMD_HOST = "--host";
    static final String CMD_PORT = "--port";
    static final String CMD_PASSWORD = "--password";
    static final String CMD_USER = "--user";
    public static final String CMD_AUTO_CONFIRMATION = "--yes";
    static final String CMD_PING_INTERVAL = "--ping-interval";
    static final String CMD_PING_TIMEOUT = "--ping-timeout";
    public static final String CMD_VERBOSE = "--verbose";
    static final String CMD_SSL_PROTOCOL = "--ssl-protocol";
    static final String CMD_SSL_KEY_ALGORITHM = "--ssl-key-algorithm";
    static final String CMD_SSL_CIPHER_SUITES = "--ssl-cipher-suites";
    static final String CMD_KEYSTORE = "--keystore";
    static final String CMD_KEYSTORE_PASSWORD = "--keystore-password";
    static final String CMD_KEYSTORE_TYPE = "--keystore-type";
    static final String CMD_TRUSTSTORE = "--truststore";
    static final String CMD_TRUSTSTORE_PASSWORD = "--truststore-password";
    static final String CMD_TRUSTSTORE_TYPE = "--truststore-type";
    static final String CMD_ENABLE_EXPERIMENTAL = "--enable-experimental";
    static final String CMD_SSL_FACTORY = "--ssl-factory";
    private static final Set<String> SENSITIVE_ARGUMENTS = new HashSet<String>();
    private static final BiConsumer<String, Integer> PORT_VALIDATOR = (name, val) -> {
        if (val <= 0 || val > 65535) {
            throw new IllegalArgumentException("Invalid value for " + name + ": " + val);
        }
    };
    private static final BiConsumer<String, Long> POSITIVE_LONG = (name, val) -> {
        if (val <= 0L) {
            throw new IllegalArgumentException("Invalid value for " + name + ": " + val);
        }
    };
    private final List<CLIArgument<?>> common = new ArrayList();

    public static boolean isSensitiveArgument(String arg) {
        return SENSITIVE_ARGUMENTS.contains(arg);
    }

    public ArgumentParser(IgniteLogger log, IgniteCommandRegistry registry) {
        this.log = log;
        this.registry = registry;
        BiConsumer<String, Object> securityWarn = (name, val) -> log.info(String.format("Warning: %s is insecure. Whenever possible, use interactive prompt for password (just discard %s option).", name, name));
        this.arg(CMD_HOST, "HOST_OR_IP", String.class, "127.0.0.1");
        this.arg(CMD_PORT, "PORT", Integer.class, 11211, PORT_VALIDATOR);
        this.arg(CMD_USER, "USER", String.class, null);
        this.arg(CMD_PASSWORD, "PASSWORD", String.class, null, securityWarn);
        this.arg(CMD_PING_INTERVAL, "PING_INTERVAL", Long.class, 5000L, POSITIVE_LONG);
        this.arg(CMD_PING_TIMEOUT, "PING_TIMEOUT", Long.class, 7000L, POSITIVE_LONG);
        this.arg(CMD_VERBOSE, CMD_VERBOSE, Boolean.TYPE, false);
        this.arg(CMD_SSL_PROTOCOL, "SSL_PROTOCOL[, SSL_PROTOCOL_2, ..., SSL_PROTOCOL_N]", String[].class, new String[]{"TLS"});
        this.arg(CMD_SSL_CIPHER_SUITES, "SSL_CIPHER_1[, SSL_CIPHER_2, ..., SSL_CIPHER_N]", String[].class, null);
        this.arg(CMD_SSL_KEY_ALGORITHM, "SSL_KEY_ALGORITHM", String.class, SslContextFactory.DFLT_KEY_ALGORITHM);
        this.arg(CMD_SSL_FACTORY, "SSL_FACTORY_PATH", String.class, null);
        this.arg(CMD_KEYSTORE_TYPE, "KEYSTORE_TYPE", String.class, SslContextFactory.DFLT_STORE_TYPE);
        this.arg(CMD_KEYSTORE, "KEYSTORE_PATH", String.class, null);
        this.arg(CMD_KEYSTORE_PASSWORD, "KEYSTORE_PASSWORD", char[].class, null, securityWarn);
        this.arg(CMD_TRUSTSTORE_TYPE, "TRUSTSTORE_TYPE", String.class, SslContextFactory.DFLT_STORE_TYPE);
        this.arg(CMD_TRUSTSTORE, "TRUSTSTORE_PATH", String.class, null);
        this.arg(CMD_TRUSTSTORE_PASSWORD, "TRUSTSTORE_PASSWORD", char[].class, null, securityWarn);
        this.arg(CMD_AUTO_CONFIRMATION, CMD_AUTO_CONFIRMATION, Boolean.TYPE, false);
        this.arg(CMD_ENABLE_EXPERIMENTAL, CMD_ENABLE_EXPERIMENTAL, Boolean.class, IgniteSystemProperties.getBoolean((String)"IGNITE_ENABLE_EXPERIMENTAL_COMMAND"));
    }

    private <T> void arg(String name, String usage, Class<T> type, T dflt, BiConsumer<String, T> validator) {
        this.common.add(CLIArgument.optionalArg(name, usage, type, t -> dflt, validator));
    }

    private <T> void arg(String name, String usage, Class<T> type, T dflt) {
        this.common.add(CLIArgument.optionalArg(name, usage, type, () -> dflt));
    }

    public String[] getCommonOptions() {
        ArrayList<String> list = new ArrayList<String>();
        for (CLIArgument<?> arg : this.common) {
            if (arg.name().equals(CMD_AUTO_CONFIRMATION)) continue;
            if (CommandUtils.isBoolean(arg.type())) {
                list.add(CommandUtils.asOptional((String)arg.name(), (boolean)true));
                continue;
            }
            list.add(CommandUtils.asOptional((String)(arg.name() + " " + arg.usage()), (boolean)true));
        }
        return list.toArray(U.EMPTY_STRS);
    }

    public <A extends IgniteDataTransferObject> ConnectionAndSslParameters<A> parseAndValidate(List<String> raw) {
        ArrayList<String> args = new ArrayList<String>(raw);
        this.findCommand(args.iterator());
        CLIArgumentParser parser = this.createArgumentParser();
        parser.parse(args.iterator());
        IgniteDataTransferObject arg = CommandUtils.argument((Class)this.cmdPath.peek().argClass(), (fld, pos) -> parser.get((int)pos), fld -> parser.get(CommandUtils.toFormattedFieldName((Field)fld).toLowerCase()));
        if (!((Boolean)parser.get(CMD_ENABLE_EXPERIMENTAL)).booleanValue() && this.cmdPath.peek().getClass().isAnnotationPresent(IgniteExperimental.class)) {
            this.log.warning(String.format("To use experimental command add --enable-experimental parameter for %s", "control.(sh|bat)"));
            throw new IllegalArgumentException("Experimental commands disabled");
        }
        return new ConnectionAndSslParameters<IgniteDataTransferObject>(this.cmdPath, arg, parser);
    }

    protected void findCommand(Iterator<String> iter) {
        assert (this.cmdPath.isEmpty());
        while (iter.hasNext() && this.cmdPath.isEmpty()) {
            Command cmd;
            String cmdName = iter.next();
            if (!cmdName.startsWith("--") || (cmd = this.registry.command(CommandUtils.fromFormattedCommandName((String)cmdName.substring("--".length()), (char)'-'))) == null) continue;
            this.cmdPath.push(cmd);
        }
        if (this.cmdPath.isEmpty()) {
            throw new IllegalArgumentException("No action was specified");
        }
        iter.remove();
        while (this.cmdPath.peek() instanceof CommandsRegistry && iter.hasNext()) {
            Command cmd1;
            String name = iter.next();
            int delim = 95;
            if (this.cmdPath.peek().getClass().isAnnotationPresent(CliSubcommandsWithPrefix.class)) {
                if (!name.startsWith("--")) break;
                name = name.substring("--".length());
                delim = 45;
            }
            if ((cmd1 = ((CommandsRegistry)this.cmdPath.peek()).command(CommandUtils.fromFormattedCommandName((String)name, (char)delim))) == null) break;
            this.cmdPath.push(cmd1);
            iter.remove();
        }
        if (!CommandUtils.executable(this.cmdPath.peek())) {
            throw new IllegalArgumentException("Command " + CommandUtils.toFormattedCommandName(this.cmdPath.peek().getClass()) + " can't be executed");
        }
    }

    private CLIArgumentParser createArgumentParser() {
        assert (!this.cmdPath.isEmpty());
        ArrayList positionalArgs = new ArrayList();
        ArrayList namedArgs = new ArrayList();
        BiFunction<Field, Boolean, CLIArgument> toArg = (fld, optional) -> new CLIArgument<Object>(CommandUtils.toFormattedFieldName((Field)fld).toLowerCase(), null, (boolean)optional, (Class<Object>)fld.getType(), null, (name, val) -> {});
        List grpdFlds = CommandUtils.argumentGroupsValues((Class)this.cmdPath.peek().argClass());
        Consumer<Field> namedArgCb = fld -> namedArgs.add((CLIArgument<?>)toArg.apply((Field)fld, CommandUtils.argumentGroupIdx((List)grpdFlds, (String)fld.getName()) >= 0 || fld.getAnnotation(Argument.class).optional()));
        Consumer<Field> positionalArgCb = fld -> positionalArgs.add(new CLIArgument<Object>(fld.getName().toLowerCase(), null, fld.getAnnotation(Argument.class).optional(), fld.getType(), null, (name, val) -> {}));
        BiConsumer<ArgumentGroup, List> argGrpCb = (argGrp0, flds) -> flds.forEach(fld -> {
            if (fld.isAnnotationPresent(Positional.class)) {
                positionalArgCb.accept((Field)fld);
            } else {
                namedArgCb.accept((Field)fld);
            }
        });
        CommandUtils.visitCommandParams((Class)this.cmdPath.peek().argClass(), positionalArgCb, namedArgCb, argGrpCb);
        namedArgs.addAll(this.common);
        return new CLIArgumentParser(positionalArgs, namedArgs);
    }

    static {
        SENSITIVE_ARGUMENTS.add(CMD_PASSWORD);
        SENSITIVE_ARGUMENTS.add(CMD_KEYSTORE_PASSWORD);
        SENSITIVE_ARGUMENTS.add(CMD_TRUSTSTORE_PASSWORD);
    }
}

