/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Cursor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowFactory;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.SingleRowCursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableBase;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.jsr166.ConcurrentHashMap8;

public class GridH2MetaTable
extends TableBase {
    private static final int ID = 0;
    private final MetaIndex index;
    private final AtomicLong dataModificationId = new AtomicLong();
    private final Set<Session> fakeExclusiveSet = Collections.newSetFromMap(new ConcurrentHashMap8());

    public GridH2MetaTable(CreateTableData data) {
        super(data);
        ArrayList cols = data.columns;
        assert (cols.size() == 4) : cols;
        Column id = (Column)cols.get(0);
        assert ("ID".equals(id.getName()) && id.getType() == 4) : cols;
        assert (id.getColumnId() == 0);
        this.index = new MetaIndex();
    }

    public Row getTemplateRow() {
        return new MetaRow();
    }

    public SearchRow getTemplateSimpleRow(boolean singleColumn) {
        if (singleColumn) {
            return GridH2RowFactory.create((Value)null);
        }
        return new MetaRow();
    }

    public boolean lock(Session session, boolean exclusive, boolean forceLockEvenInMvcc) {
        if (this.fakeExclusiveSet.contains(session)) {
            return true;
        }
        if (exclusive) {
            this.fakeExclusiveSet.add(session);
        }
        return false;
    }

    public void unlock(Session s) {
        this.fakeExclusiveSet.remove(s);
    }

    public void close(Session session) {
    }

    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, boolean create, String indexComment) {
        assert (cols.length == 1) : "len: " + cols.length;
        int colId = cols[0].column.getColumnId();
        assert (colId == 0) : "colId: " + colId;
        return this.index;
    }

    public void removeRow(Session session, Row row) {
        this.dataModificationId.incrementAndGet();
        this.index.remove(session, row);
    }

    public void truncate(Session session) {
        this.dataModificationId.incrementAndGet();
        this.index.truncate(session);
    }

    public void addRow(Session session, Row row) {
        this.dataModificationId.incrementAndGet();
        this.index.add(session, row);
    }

    public void checkSupportAlter() {
        throw DbException.getUnsupportedException((String)"alter");
    }

    public String getTableType() {
        return "SYSTEM TABLE";
    }

    public Index getScanIndex(Session session) {
        return this.index;
    }

    public Index getUniqueIndex() {
        return this.index;
    }

    public ArrayList<Index> getIndexes() {
        return null;
    }

    public boolean isLockedExclusively() {
        return !this.fakeExclusiveSet.isEmpty();
    }

    public boolean isLockedExclusivelyBy(Session s) {
        return this.fakeExclusiveSet.contains(s);
    }

    public long getMaxDataModificationId() {
        return this.dataModificationId.get();
    }

    public boolean isDeterministic() {
        return false;
    }

    public boolean canGetRowCount() {
        return true;
    }

    public boolean canDrop() {
        return false;
    }

    public long getRowCount(Session session) {
        return this.index.getRowCount(session);
    }

    public long getRowCountApproximation() {
        return this.index.getRowCountApproximation();
    }

    public long getDiskSpaceUsed() {
        return 0L;
    }

    public void checkRename() {
        throw DbException.getUnsupportedException((String)"rename");
    }

    private static class MetaIndex
    extends BaseIndex {
        private final ConcurrentMap<ValueInt, GridH2Row> rows = new ConcurrentHashMap8();

        private MetaIndex() {
        }

        public void checkRename() {
            throw DbException.getUnsupportedException((String)"rename");
        }

        public void close(Session session) {
        }

        private static ValueInt id(SearchRow row) {
            Value id = row.getValue(0);
            assert (id != null);
            return (ValueInt)id;
        }

        public void add(Session session, Row row) {
            this.rows.put(MetaIndex.id((SearchRow)row), (GridH2Row)row);
        }

        public void remove(Session session, Row row) {
            this.rows.remove(MetaIndex.id((SearchRow)row), row);
        }

        public Cursor find(Session session, SearchRow first, SearchRow last) {
            if (first == null || last == null || !Objects.equals(MetaIndex.id(first), MetaIndex.id(last))) {
                return new GridH2Cursor(this.rows.values().iterator());
            }
            return new SingleRowCursor((Row)this.rows.get(MetaIndex.id(first)));
        }

        public double getCost(Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder) {
            if ((masks[0] & 1) == 1) {
                return 1.0;
            }
            return 1000 + this.rows.size();
        }

        public void remove(Session session) {
        }

        public void truncate(Session session) {
            this.rows.clear();
        }

        public boolean canGetFirstOrLast() {
            return false;
        }

        public Cursor findFirstOrLast(Session session, boolean first) {
            throw new UnsupportedOperationException();
        }

        public boolean needRebuild() {
            return false;
        }

        public long getRowCount(Session session) {
            return this.rows.size();
        }

        public long getRowCountApproximation() {
            return this.getRowCount(null);
        }

        public long getDiskSpaceUsed() {
            return 0L;
        }
    }

    private static class MetaRow
    extends GridH2Row {
        private Value v0;
        private Value v1;
        private Value v2;
        private Value v3;

        private MetaRow() {
        }

        public int getColumnCount() {
            return 4;
        }

        public Value getValue(int idx) {
            switch (idx) {
                case 0: {
                    return this.v0;
                }
                case 1: {
                    return this.v1;
                }
                case 2: {
                    return this.v2;
                }
                case 3: {
                    return this.v3;
                }
            }
            throw new IllegalStateException("Index: " + idx);
        }

        public void setValue(int idx, Value v) {
            switch (idx) {
                case 0: {
                    this.v0 = v;
                    break;
                }
                case 1: {
                    this.v1 = v;
                    break;
                }
                case 2: {
                    this.v2 = v;
                    break;
                }
                case 3: {
                    this.v3 = v;
                    break;
                }
                default: {
                    throw new IllegalStateException("Index: " + idx);
                }
            }
        }
    }
}

