/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.codec.binary.Base64;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryIndexType;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridLuceneDirectory;
import org.apache.ignite.internal.util.GridAtomicLong;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapter;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeMemory;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermRangeFilter;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.h2.util.JdbcUtils;
import org.jetbrains.annotations.Nullable;

public class GridLuceneIndex
implements AutoCloseable {
    public static final String VAL_STR_FIELD_NAME = "_gg_val_str__";
    public static final String VER_FIELD_NAME = "_gg_ver__";
    public static final String EXPIRATION_TIME_FIELD_NAME = "_gg_expires__";
    private final String spaceName;
    private final GridQueryTypeDescriptor type;
    private final IndexWriter writer;
    private final String[] idxdFields;
    private final AtomicLong updateCntr = new GridAtomicLong();
    private final GridLuceneDirectory dir;
    private final GridKernalContext ctx;

    public GridLuceneIndex(GridKernalContext ctx, @Nullable GridUnsafeMemory mem, @Nullable String spaceName, GridQueryTypeDescriptor type) throws IgniteCheckedException {
        this.ctx = ctx;
        this.spaceName = spaceName;
        this.type = type;
        this.dir = new GridLuceneDirectory(mem == null ? new GridUnsafeMemory(0L) : mem);
        try {
            this.writer = new IndexWriter((Directory)this.dir, new IndexWriterConfig(Version.LUCENE_30, (Analyzer)new StandardAnalyzer(Version.LUCENE_30)));
        }
        catch (IOException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
        GridQueryIndexDescriptor idx = null;
        for (GridQueryIndexDescriptor descriptor : type.indexes().values()) {
            if (descriptor.type() != GridQueryIndexType.FULLTEXT) continue;
            idx = descriptor;
            break;
        }
        if (idx != null) {
            Collection fields = idx.fields();
            this.idxdFields = new String[fields.size() + 1];
            fields.toArray(this.idxdFields);
        } else {
            assert (type.valueTextIndex() || type.valueClass() == String.class);
            this.idxdFields = new String[1];
        }
        this.idxdFields[this.idxdFields.length - 1] = VAL_STR_FIELD_NAME;
    }

    private CacheObjectContext objectContext() {
        if (this.ctx == null) {
            return null;
        }
        return this.ctx.cache().internalCache(this.spaceName).context().cacheObjectContext();
    }

    public void store(CacheObject k, CacheObject v, byte[] ver, long expires) throws IgniteCheckedException {
        CacheObjectContext coctx = this.objectContext();
        CacheObject key = k.isPlatformType() ? k.value(coctx, false) : k;
        CacheObject val = v.isPlatformType() ? v.value(coctx, false) : v;
        Document doc = new Document();
        boolean stringsFound = false;
        if (this.type.valueTextIndex() || this.type.valueClass() == String.class) {
            doc.add((Fieldable)new Field(VAL_STR_FIELD_NAME, val.toString(), Field.Store.YES, Field.Index.ANALYZED));
            stringsFound = true;
        }
        int last = this.idxdFields.length - 1;
        for (int i = 0; i < last; ++i) {
            Object fieldVal = this.type.value(this.idxdFields[i], (Object)key, (Object)val);
            if (fieldVal == null) continue;
            doc.add((Fieldable)new Field(this.idxdFields[i], fieldVal.toString(), Field.Store.YES, Field.Index.ANALYZED));
            stringsFound = true;
        }
        String keyStr = Base64.encodeBase64String((byte[])k.valueBytes(coctx));
        try {
            this.writer.deleteDocuments(new Term("_key", keyStr));
            if (!stringsFound) {
                return;
            }
            doc.add((Fieldable)new Field("_key", keyStr, Field.Store.YES, Field.Index.NOT_ANALYZED));
            if (this.type.valueClass() != String.class) {
                doc.add((Fieldable)new Field("_val", v.valueBytes(coctx)));
            }
            doc.add((Fieldable)new Field(VER_FIELD_NAME, ver));
            doc.add((Fieldable)new Field(EXPIRATION_TIME_FIELD_NAME, DateTools.timeToString((long)expires, (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.YES, Field.Index.NOT_ANALYZED));
            this.writer.addDocument(doc);
        }
        catch (IOException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
        finally {
            this.updateCntr.incrementAndGet();
        }
    }

    public void remove(CacheObject key) throws IgniteCheckedException {
        try {
            this.writer.deleteDocuments(new Term("_key", Base64.encodeBase64String((byte[])key.valueBytes(this.objectContext()))));
        }
        catch (IOException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
        finally {
            this.updateCntr.incrementAndGet();
        }
    }

    public <K, V> GridCloseableIterator<IgniteBiTuple<K, V>> query(String qry, IndexingQueryFilter filters) throws IgniteCheckedException {
        TopDocs docs;
        IndexReader reader;
        try {
            long updates = this.updateCntr.get();
            if (updates != 0L) {
                this.writer.commit();
                this.updateCntr.addAndGet(-updates);
            }
            reader = IndexReader.open((IndexWriter)this.writer, (boolean)true);
        }
        catch (IOException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
        IndexSearcher searcher = new IndexSearcher(reader);
        MultiFieldQueryParser parser = new MultiFieldQueryParser(Version.LUCENE_30, this.idxdFields, this.writer.getAnalyzer());
        TermRangeFilter f = new TermRangeFilter(EXPIRATION_TIME_FIELD_NAME, DateTools.timeToString((long)U.currentTimeMillis(), (DateTools.Resolution)DateTools.Resolution.MILLISECOND), null, false, false);
        try {
            docs = searcher.search(parser.parse(qry), (Filter)f, Integer.MAX_VALUE);
        }
        catch (Exception e) {
            throw new IgniteCheckedException((Throwable)e);
        }
        IgniteBiPredicate fltr = null;
        if (filters != null) {
            fltr = filters.forSpace(this.spaceName);
        }
        return new It(reader, searcher, docs.scoreDocs, fltr);
    }

    @Override
    public void close() {
        U.closeQuiet((AutoCloseable)this.writer);
        U.closeQuiet((AutoCloseable)((Object)this.dir));
    }

    private class It<K, V>
    extends GridCloseableIteratorAdapter<IgniteBiTuple<K, V>> {
        private static final long serialVersionUID = 0L;
        private final IndexReader reader;
        private final IndexSearcher searcher;
        private final ScoreDoc[] docs;
        private final IgniteBiPredicate<K, V> filters;
        private int idx;
        private IgniteBiTuple<K, V> curr;
        private CacheObjectContext coctx;

        private It(IndexReader reader, IndexSearcher searcher, ScoreDoc[] docs, IgniteBiPredicate<K, V> filters) throws IgniteCheckedException {
            this.reader = reader;
            this.searcher = searcher;
            this.docs = docs;
            this.filters = filters;
            this.coctx = GridLuceneIndex.this.objectContext();
            this.findNext();
        }

        private boolean filter(K key, V val) {
            return this.filters == null || this.filters.apply(key, val);
        }

        private <Z> Z unmarshall(byte[] bytes, ClassLoader ldr) throws IgniteCheckedException {
            if (this.coctx == null) {
                return (Z)JdbcUtils.deserialize((byte[])bytes, null);
            }
            return (Z)this.coctx.processor().unmarshal(this.coctx, bytes, ldr);
        }

        private void findNext() throws IgniteCheckedException {
            this.curr = null;
            while (this.idx < this.docs.length) {
                String v;
                Document doc;
                try {
                    doc = this.searcher.doc(this.docs[this.idx++].doc);
                }
                catch (IOException e) {
                    throw new IgniteCheckedException((Throwable)e);
                }
                ClassLoader ldr = null;
                if (GridLuceneIndex.this.ctx != null && GridLuceneIndex.this.ctx.deploy().enabled()) {
                    ldr = GridLuceneIndex.this.ctx.cache().internalCache(GridLuceneIndex.this.spaceName).context().deploy().globalLoader();
                }
                Object k = this.unmarshall(Base64.decodeBase64((String)doc.get("_key")), ldr);
                String string = v = GridLuceneIndex.this.type.valueClass() == String.class ? doc.get(GridLuceneIndex.VAL_STR_FIELD_NAME) : this.unmarshall(doc.getBinaryValue("_val"), ldr);
                assert (v != null);
                if (!this.filter(k, v)) continue;
                this.curr = new IgniteBiTuple(k, (Object)v);
                break;
            }
        }

        protected IgniteBiTuple<K, V> onNext() throws IgniteCheckedException {
            IgniteBiTuple<K, V> res = this.curr;
            this.findNext();
            return res;
        }

        protected boolean onHasNext() throws IgniteCheckedException {
            return this.curr != null;
        }

        protected void onClose() throws IgniteCheckedException {
            U.closeQuiet((AutoCloseable)this.searcher);
            U.closeQuiet((AutoCloseable)this.reader);
        }
    }
}

