/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlias;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSortColumn;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;

public abstract class GridSqlQuery {
    protected boolean distinct;
    protected List<GridSqlSortColumn> sort = new ArrayList<GridSqlSortColumn>();
    protected GridSqlElement offset;
    protected GridSqlElement limit;
    private boolean explain;

    public GridSqlQuery explain(boolean explain) {
        this.explain = explain;
        return this;
    }

    public boolean explain() {
        return this.explain;
    }

    public GridSqlElement offset() {
        return this.offset;
    }

    public void offset(GridSqlElement offset) {
        this.offset = offset;
    }

    public void limit(GridSqlElement limit) {
        this.limit = limit;
    }

    public GridSqlElement limit() {
        return this.limit;
    }

    public boolean distinct() {
        return this.distinct;
    }

    public void distinct(boolean distinct) {
        this.distinct = distinct;
    }

    public abstract String getSQL();

    public List<GridSqlSortColumn> sort() {
        return this.sort;
    }

    public void clearSort() {
        this.sort = new ArrayList<GridSqlSortColumn>();
    }

    public void addSort(GridSqlSortColumn sortCol) {
        this.sort.add(sortCol);
    }

    protected abstract int visibleColumns();

    protected abstract GridSqlElement column(int var1);

    protected void getSortLimitSQL(StatementBuilder buff) {
        if (!this.sort.isEmpty()) {
            buff.append("\nORDER BY ");
            int visibleCols = this.visibleColumns();
            buff.resetCount();
            for (GridSqlSortColumn col : this.sort) {
                buff.appendExceptFirst(", ");
                int idx = col.column();
                assert (idx >= 0) : idx;
                if (idx < visibleCols) {
                    buff.append((long)(idx + 1));
                } else {
                    GridSqlElement expr = this.column(idx);
                    if (expr == null) {
                        throw new IllegalStateException("Failed to build query: " + buff.toString());
                    }
                    if (expr instanceof GridSqlAlias) {
                        expr = expr.child();
                    }
                    buff.append('=').append(StringUtils.unEnclose((String)expr.getSQL()));
                }
                if (!col.asc()) {
                    buff.append(" DESC");
                }
                if (col.nullsFirst()) {
                    buff.append(" NULLS FIRST");
                    continue;
                }
                if (!col.nullsLast()) continue;
                buff.append(" NULLS LAST");
            }
        }
        if (this.limit != null) {
            buff.append(" LIMIT ").append(StringUtils.unEnclose((String)this.limit.getSQL()));
        }
        if (this.offset != null) {
            buff.append(" OFFSET ").append(StringUtils.unEnclose((String)this.offset.getSQL()));
        }
    }
}

