/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlias;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperation;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperationType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlTable;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;

public class GridSqlSelect
extends GridSqlQuery {
    private List<GridSqlElement> cols = new ArrayList<GridSqlElement>();
    private int visibleCols;
    private int[] grpCols;
    private GridSqlElement from;
    private GridSqlElement where;
    private int havingCol = -1;

    @Override
    public int visibleColumns() {
        return this.visibleCols;
    }

    public int allColumns() {
        return this.cols.size();
    }

    @Override
    protected GridSqlElement column(int col) {
        return this.cols.get(col);
    }

    @Override
    public String getSQL() {
        StatementBuilder buff = new StatementBuilder(this.explain() ? "EXPLAIN SELECT" : "SELECT");
        if (this.distinct) {
            buff.append(" DISTINCT");
        }
        for (GridSqlElement expression : this.columns(true)) {
            buff.appendExceptFirst(",");
            buff.append('\n');
            buff.append(expression.getSQL());
        }
        buff.append("\nFROM ").append(this.from.getSQL());
        if (this.where != null) {
            buff.append("\nWHERE ").append(StringUtils.unEnclose((String)this.where.getSQL()));
        }
        if (this.grpCols != null) {
            buff.append("\nGROUP BY ");
            buff.resetCount();
            for (int grpCol : this.grpCols) {
                buff.appendExceptFirst(", ");
                GridSqlSelect.addAlias(buff, this.cols.get(grpCol));
            }
        }
        if (this.havingCol >= 0) {
            buff.append("\nHAVING ");
            GridSqlSelect.addAlias(buff, this.cols.get(this.havingCol));
        }
        this.getSortLimitSQL(buff);
        return buff.toString();
    }

    public boolean simpleQuery() {
        boolean simple;
        boolean bl = simple = !this.distinct && this.from instanceof GridSqlTable && this.where == null && this.grpCols == null && this.havingCol < 0 && this.sort.isEmpty() && this.limit == null && this.offset == null;
        if (simple) {
            for (GridSqlElement expression : this.columns(true)) {
                if (expression instanceof GridSqlAlias) {
                    expression = expression.child();
                }
                if (expression instanceof GridSqlColumn) continue;
                return false;
            }
        }
        return simple;
    }

    private static void addAlias(StatementBuilder buff, GridSqlElement exp) {
        exp = GridSqlAlias.unwrap(exp);
        buff.append(StringUtils.unEnclose((String)exp.getSQL()));
    }

    public List<GridSqlElement> columns(boolean visibleOnly) {
        assert (this.visibleCols <= this.cols.size());
        return visibleOnly && this.visibleCols != this.cols.size() ? this.cols.subList(0, this.visibleCols) : this.cols;
    }

    public GridSqlSelect clearColumns() {
        this.visibleCols = 0;
        this.cols = new ArrayList<GridSqlElement>();
        return this;
    }

    public GridSqlSelect addColumn(GridSqlElement expression, boolean visible) {
        if (expression == null) {
            throw new NullPointerException();
        }
        if (visible) {
            if (this.visibleCols != this.cols.size()) {
                throw new IllegalStateException("Already started adding invisible columns.");
            }
            ++this.visibleCols;
        }
        this.cols.add(expression);
        return this;
    }

    public GridSqlSelect setColumn(int colIdx, GridSqlElement expression) {
        if (expression == null) {
            throw new NullPointerException();
        }
        this.cols.set(colIdx, expression);
        return this;
    }

    public int[] groupColumns() {
        return this.grpCols;
    }

    public GridSqlSelect groupColumns(int[] grpCols) {
        this.grpCols = grpCols;
        return this;
    }

    public GridSqlElement from() {
        return this.from;
    }

    public GridSqlSelect from(GridSqlElement from) {
        this.from = from;
        return this;
    }

    public GridSqlElement where() {
        return this.where;
    }

    public GridSqlSelect where(GridSqlElement where) {
        this.where = where;
        return this;
    }

    public GridSqlSelect whereAnd(GridSqlElement cond) {
        if (cond == null) {
            throw new NullPointerException();
        }
        GridSqlElement old = this.where();
        this.where(old == null ? cond : new GridSqlOperation(GridSqlOperationType.AND, old, cond));
        return this;
    }

    public GridSqlElement having() {
        return this.havingCol >= 0 ? this.column(this.havingCol) : null;
    }

    public GridSqlSelect havingColumn(int col) {
        assert (col >= -1) : col;
        this.havingCol = col;
        return this;
    }

    public int havingColumn() {
        return this.havingCol;
    }
}

