/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep.msg;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessage;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueBytes;

public class GridH2Bytes
extends GridH2ValueMessage {
    private byte[] b;

    public GridH2Bytes() {
    }

    public GridH2Bytes(Value val) {
        assert (val.getType() == 12) : val.getType();
        this.b = val.getBytesNoCopy();
    }

    @Override
    public Value value(GridKernalContext ctx) {
        return ValueBytes.getNoCopy((byte[])this.b);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("b", this.b)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.b = reader.readByteArray("b");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridH2Bytes.class);
    }

    public byte directType() {
        return -16;
    }

    public byte fieldsCount() {
        return 1;
    }

    public String toString() {
        return "b_" + StringUtils.convertBytesToHex((byte[])this.b);
    }
}

