/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep.msg;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ValueCacheObject;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessage;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.h2.value.Value;

public class GridH2CacheObject
extends GridH2ValueMessage {
    private int cacheId;
    private CacheObject obj;

    public GridH2CacheObject() {
    }

    public GridH2CacheObject(GridH2ValueCacheObject v) throws IgniteCheckedException {
        this.obj = v.getCacheObject();
        GridCacheContext<?, ?> cctx = v.getCacheContext();
        if (cctx != null) {
            this.cacheId = cctx.cacheId();
            this.obj.prepareMarshal(cctx.cacheObjectContext());
        }
    }

    @Override
    public Value value(GridKernalContext ctx) throws IgniteCheckedException {
        GridCacheContext cctx = null;
        if (ctx != null) {
            cctx = ctx.cache().context().cacheContext(this.cacheId);
            this.obj.finishUnmarshal(cctx.cacheObjectContext(), cctx.deploy().globalLoader());
        }
        return new GridH2ValueCacheObject(cctx, this.obj);
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.cacheId = reader.readInt("cacheId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.obj = (CacheObject)reader.readMessage("obj");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridH2CacheObject.class);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeInt("cacheId", this.cacheId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeMessage("obj", (Message)this.obj)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    public byte directType() {
        return -22;
    }

    public byte fieldsCount() {
        return 2;
    }

    public String toString() {
        return String.valueOf(this.obj);
    }
}

