/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep.msg;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessage;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.h2.value.Value;
import org.h2.value.ValueUuid;

public class GridH2Uuid
extends GridH2ValueMessage {
    private long high;
    private long low;

    public GridH2Uuid() {
    }

    public GridH2Uuid(Value val) {
        assert (val.getType() == 20) : val.getType();
        ValueUuid uuid = (ValueUuid)val;
        this.high = uuid.getHigh();
        this.low = uuid.getLow();
    }

    @Override
    public Value value(GridKernalContext ctx) {
        return ValueUuid.get((long)this.high, (long)this.low);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeLong("high", this.high)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeLong("low", this.low)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.high = reader.readLong("high");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.low = reader.readLong("low");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridH2Uuid.class);
    }

    public byte directType() {
        return -20;
    }

    public byte fieldsCount() {
        return 2;
    }

    public String toString() {
        return ValueUuid.get((long)this.high, (long)this.low).getString();
    }
}

