/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import java.util.Arrays;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.query.h2.database.InlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.opt.H2Row;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class InlineObjectBytesDetector
implements BPlusTree.TreeRowClosure<H2Row, H2Row> {
    private final int inlineSize;
    private final List<InlineIndexColumn> inlineCols;
    private boolean inlineObjSupported = true;
    private final String tblName;
    private final String idxName;
    private final IgniteLogger log;

    InlineObjectBytesDetector(int inlineSize, List<InlineIndexColumn> inlineCols, String tblName, String idxName, IgniteLogger log) {
        this.inlineSize = inlineSize;
        this.inlineCols = inlineCols;
        this.tblName = tblName;
        this.idxName = idxName;
        this.log = log;
    }

    public boolean apply(BPlusTree<H2Row, H2Row> tree, BPlusIO<H2Row> io, long pageAddr, int idx) throws IgniteCheckedException {
        H2Row r = (H2Row)tree.getRow(io, pageAddr, idx);
        int off = io.offset(idx);
        int fieldOff = 0;
        boolean varLenPresents = false;
        for (InlineIndexColumn ih : this.inlineCols) {
            if (fieldOff >= this.inlineSize) {
                return false;
            }
            if (ih.type() != 19) {
                if (ih.size() < 0) {
                    varLenPresents = true;
                }
                fieldOff += ih.fullSize(pageAddr, off + fieldOff);
                continue;
            }
            Value val = r.getValue(ih.columnIndex());
            if (val == ValueNull.INSTANCE) {
                return false;
            }
            byte type = PageUtils.getByte((long)pageAddr, (int)(off + fieldOff));
            if (type == 19) {
                int len = PageUtils.getShort((long)pageAddr, (int)(off + fieldOff + 1));
                byte[] originalObjBytes = val.getBytesNoCopy();
                if ((len &= Short.MAX_VALUE) > this.inlineSize - fieldOff - 3 || len > originalObjBytes.length) {
                    this.inlineObjectSupportedDecision(false, "length is big " + len);
                    return true;
                }
                byte[] inlineBytes = PageUtils.getBytes((long)pageAddr, (int)(off + fieldOff + 3), (int)len);
                if (!Arrays.equals(inlineBytes, originalObjBytes)) {
                    this.inlineObjectSupportedDecision(false, "byte compare");
                    return true;
                }
                this.inlineObjectSupportedDecision(true, len + " bytes compared");
                return true;
            }
            if (type == -1 && varLenPresents) {
                return false;
            }
            this.inlineObjectSupportedDecision(false, "inline type " + type);
            return true;
        }
        this.inlineObjectSupportedDecision(true, "no java objects for inlining");
        return true;
    }

    public boolean inlineObjectSupported() {
        return this.inlineObjSupported;
    }

    public static boolean objectMayBeInlined(int inlineSize, List<InlineIndexColumn> inlineCols) {
        int remainSize = inlineSize;
        for (InlineIndexColumn ih : inlineCols) {
            if (ih.type() == 19) break;
            remainSize -= ih.size() > 0 ? 1 + ih.size() : 1;
        }
        return remainSize >= 4;
    }

    private void inlineObjectSupportedDecision(boolean inlineObjSupported, String reason) {
        this.inlineObjSupported = inlineObjSupported;
        if (inlineObjSupported) {
            this.log.warning("Index supports JAVA_OBJECT type inlining [tblName=" + this.tblName + ", idxName=" + this.idxName + ", reason='" + reason + "']");
        } else {
            this.log.warning("Index doesn't support JAVA_OBJECT type inlining [tblName=" + this.tblName + ", idxName=" + this.idxName + ", reason='" + reason + "']");
        }
    }
}

