/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database.io;

import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusInnerIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.query.h2.database.H2Tree;
import org.apache.ignite.internal.processors.query.h2.database.InlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.InlineIndexColumnFactory;
import org.apache.ignite.internal.processors.query.h2.database.io.H2ExtrasInnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2IOUtils;
import org.apache.ignite.internal.processors.query.h2.database.io.H2InnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2MvccExtrasInnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2MvccInnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2RowLinkIO;
import org.apache.ignite.internal.processors.query.h2.opt.H2CacheRow;
import org.apache.ignite.internal.processors.query.h2.opt.H2Row;

public abstract class AbstractH2ExtrasInnerIO
extends BPlusInnerIO<H2Row>
implements H2RowLinkIO {
    protected final int payloadSize;

    public static void register() {
        AbstractH2ExtrasInnerIO.register(false);
        AbstractH2ExtrasInnerIO.register(true);
    }

    private static void register(boolean mvcc) {
        int type = mvcc ? 26000 : 20000;
        for (short payload = 1; payload <= 2048; payload = (short)(payload + 1)) {
            IOVersions<? extends AbstractH2ExtrasInnerIO> io = AbstractH2ExtrasInnerIO.getVersions((short)(type + payload - 1), payload, mvcc);
            PageIO.registerH2ExtraInner(io, (boolean)mvcc);
        }
    }

    public static IOVersions<? extends BPlusInnerIO<H2Row>> getVersions(int payload, boolean mvccEnabled) {
        assert (payload >= 0 && payload <= 2048);
        if (payload == 0) {
            return mvccEnabled ? H2MvccInnerIO.VERSIONS : H2InnerIO.VERSIONS;
        }
        return PageIO.getInnerVersions((int)((short)(payload - 1)), (boolean)mvccEnabled);
    }

    private static IOVersions<? extends AbstractH2ExtrasInnerIO> getVersions(short type, short payload, boolean mvcc) {
        return new IOVersions((PageIO[])new AbstractH2ExtrasInnerIO[]{mvcc ? new H2MvccExtrasInnerIO(type, 1, payload) : new H2ExtrasInnerIO(type, 1, payload)});
    }

    AbstractH2ExtrasInnerIO(short type, int ver, int itemSize, int payloadSize) {
        super((int)type, ver, true, itemSize + payloadSize);
        this.payloadSize = payloadSize;
    }

    public final void storeByOffset(long pageAddr, int off, H2Row row) {
        InlineIndexColumn idx;
        int size;
        H2CacheRow row0 = (H2CacheRow)row;
        assert (row0.link() != 0L) : row0;
        List<InlineIndexColumn> inlineIdxs = InlineIndexColumnFactory.getCurrentInlineIndexes();
        assert (inlineIdxs != null) : "no inline index helpers";
        int fieldOff = 0;
        for (int i = 0; i < inlineIdxs.size() && (size = (idx = inlineIdxs.get(i)).put(pageAddr, off + fieldOff, row.getValue(idx.columnIndex()), this.payloadSize - fieldOff)) != 0; ++i) {
            fieldOff += size;
        }
        H2IOUtils.storeRow(row0, pageAddr, off + this.payloadSize, this.storeMvccInfo());
    }

    public final H2Row getLookupRow(BPlusTree<H2Row, ?> tree, long pageAddr, int idx) throws IgniteCheckedException {
        long link = this.getLink(pageAddr, idx);
        assert (link != 0L);
        if (this.storeMvccInfo()) {
            long mvccCrdVer = this.getMvccCoordinatorVersion(pageAddr, idx);
            long mvccCntr = this.getMvccCounter(pageAddr, idx);
            int mvccOpCntr = this.getMvccOperationCounter(pageAddr, idx);
            return ((H2Tree)tree).createMvccRow(link, mvccCrdVer, mvccCntr, mvccOpCntr);
        }
        return ((H2Tree)tree).createRow(link);
    }

    public final void store(long dstPageAddr, int dstIdx, BPlusIO<H2Row> srcIo, long srcPageAddr, int srcIdx) {
        int srcOff = srcIo.offset(srcIdx);
        byte[] payload = PageUtils.getBytes((long)srcPageAddr, (int)srcOff, (int)this.payloadSize);
        long link = PageUtils.getLong((long)srcPageAddr, (int)(srcOff + this.payloadSize));
        assert (link != 0L);
        int dstOff = this.offset(dstIdx);
        PageUtils.putBytes((long)dstPageAddr, (int)dstOff, (byte[])payload);
        H2IOUtils.store(dstPageAddr, dstOff + this.payloadSize, srcIo, srcPageAddr, srcIdx, this.storeMvccInfo());
    }

    @Override
    public final long getLink(long pageAddr, int idx) {
        return PageUtils.getLong((long)pageAddr, (int)(this.offset(idx) + this.payloadSize));
    }

    @Override
    public int getPayloadSize() {
        return this.payloadSize;
    }
}

