/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.util.typedef.F;
import org.h2.index.BaseIndex;
import org.h2.index.IndexCondition;
import org.h2.index.IndexType;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;

public abstract class H2IndexCostedBase
extends BaseIndex {
    protected H2IndexCostedBase(GridH2Table tbl, String name, IndexColumn[] cols, IndexType type) {
        this.initBaseIndex((Table)tbl, 0, name, cols, type);
    }

    protected long getCostRangeIndexEx(int[] masks, long rowCount, TableFilter[] filters, int filter, SortOrder sortOrder, boolean isScanIndex, HashSet<Column> allColumnsSet) {
        TableFilter tableFilter;
        int totalSelectivity = 0;
        long rowsCost = rowCount += 1000L;
        if (masks != null) {
            int i = 0;
            int len = this.columns.length;
            while (i < len) {
                Column column;
                int index;
                int mask;
                if (((mask = masks[index = (column = this.columns[i++]).getColumnId()]) & 1) == 1) {
                    if (i == len && this.getIndexType().isUnique()) {
                        rowsCost = 3L;
                        break;
                    }
                    long distinctRows = rowCount * (long)(totalSelectivity = 100 - (100 - totalSelectivity) * (100 - column.getSelectivity()) / 100) / 100L;
                    if (distinctRows <= 0L) {
                        distinctRows = 1L;
                    }
                    rowsCost = Math.min(5L + Math.max(rowsCost / distinctRows, 1L), rowsCost - (long)(i > 0 ? 1 : 0));
                    continue;
                }
                if ((mask & 6) == 6) {
                    rowsCost = Math.min(5L + rowsCost / 4L, rowsCost - (long)(i > 0 ? 1 : 0));
                    break;
                }
                if ((mask & 2) == 2) {
                    rowsCost = Math.min(5L + rowsCost / 3L, rowsCost - (long)(i > 0 ? 1 : 0));
                    break;
                }
                if ((mask & 4) != 4) break;
                rowsCost = Math.min(rowsCost / 3L, rowsCost - (long)(i > 0 ? 1 : 0));
                break;
            }
        }
        long sortingCost = 0L;
        if (sortOrder != null) {
            sortingCost = 100L + rowCount / 10L;
        }
        if (sortOrder != null && !isScanIndex) {
            boolean sortOrderMatches = true;
            int coveringCount = 0;
            int[] sortTypes = sortOrder.getSortTypes();
            TableFilter tableFilter2 = filters == null ? null : filters[filter];
            int len = sortTypes.length;
            for (int i = 0; i < len && i < this.indexColumns.length; ++i) {
                Column col = sortOrder.getColumn(i, tableFilter2);
                if (col == null) {
                    sortOrderMatches = false;
                    break;
                }
                IndexColumn indexCol = this.indexColumns[i];
                if (!col.equals((Object)indexCol.column)) {
                    sortOrderMatches = false;
                    break;
                }
                int sortType = sortTypes[i];
                if (sortType != indexCol.sortType) {
                    sortOrderMatches = false;
                    break;
                }
                ++coveringCount;
            }
            if (sortOrderMatches) {
                sortingCost = 100 - coveringCount;
            }
        }
        boolean skipColumnsIntersection = false;
        if (filters != null && (tableFilter = filters[filter]) != null && this.columns != null) {
            skipColumnsIntersection = true;
            ArrayList idxConds = tableFilter.getIndexConditions();
            if (F.isEmpty((Collection)idxConds)) {
                skipColumnsIntersection = false;
            }
            for (IndexCondition cond : idxConds) {
                if (cond.getColumn() != this.columns[0]) continue;
                skipColumnsIntersection = false;
                break;
            }
        }
        boolean needsToReadFromScanIndex = true;
        if (!(isScanIndex || allColumnsSet == null || skipColumnsIntersection || allColumnsSet.isEmpty())) {
            boolean foundAllColumnsWeNeed = true;
            for (Column c : allColumnsSet) {
                boolean found = false;
                for (Column c2 : this.columns) {
                    if (c != c2) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                foundAllColumnsWeNeed = false;
                break;
            }
            if (foundAllColumnsWeNeed) {
                needsToReadFromScanIndex = false;
            }
        }
        long rc = isScanIndex ? rowsCost + sortingCost + 20L : (needsToReadFromScanIndex ? rowsCost + rowsCost + sortingCost + 20L : rowsCost + sortingCost + (long)this.columns.length);
        return rc;
    }
}

