/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.index;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowCompartorImpl;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyTypeRegistry;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.NullableInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKeyFactory;
import org.apache.ignite.internal.cache.query.index.sorted.keys.NullIndexKey;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.h2.engine.SessionInterface;
import org.h2.message.DbException;
import org.h2.value.DataType;
import org.h2.value.Value;

public class H2RowComparator
extends IndexRowCompartorImpl {
    private final CacheObjectContext coctx;
    private final GridH2Table table;
    private final SessionInterface ses;

    public H2RowComparator(GridH2Table table, IndexKeyTypeSettings keyTypeSettings) {
        super(keyTypeSettings);
        this.table = table;
        this.coctx = table.rowDescriptor().context().cacheObjectContext();
        this.ses = table.rowDescriptor().indexing().connections().jdbcConnection().getSession();
    }

    public int compareKey(long pageAddr, int off, int maxSize, IndexKey key, InlineIndexKeyType type) {
        int cmp = super.compareKey(pageAddr, off, maxSize, key, type);
        if (cmp != Integer.MIN_VALUE) {
            return cmp;
        }
        int objType = key == NullIndexKey.INSTANCE ? type.type() : key.type();
        int highOrder = Value.getHigherOrder((int)type.type(), (int)objType);
        if (highOrder != objType && highOrder == type.type()) {
            Value va = DataType.convertToValue((SessionInterface)this.ses, (Object)key.key(), (int)highOrder);
            IndexKey objHighOrder = IndexKeyFactory.wrap((Object)(va = va.convertTo(highOrder)).getObject(), (int)highOrder, (CacheObjectValueContext)this.coctx, (IndexKeyTypeSettings)this.keyTypeSettings);
            InlineIndexKeyType highType = InlineIndexKeyTypeRegistry.get((IndexKey)objHighOrder, (int)highOrder, (IndexKeyTypeSettings)this.keyTypeSettings);
            if (highType != null) {
                return ((NullableInlineIndexKeyType)highType).compare0(pageAddr, off, objHighOrder);
            }
        }
        return Integer.MIN_VALUE;
    }

    public int compareRow(IndexRow left, IndexRow right, int idx) throws IgniteCheckedException {
        int cmp = super.compareRow(left, right, idx);
        if (cmp != Integer.MIN_VALUE) {
            return cmp;
        }
        Object lobject = left.key(idx).key();
        Object robject = right.key(idx).key();
        int ltype = left.indexSearchRow() ? DataType.getTypeFromClass(lobject.getClass()) : ((IndexKeyDefinition)left.rowHandler().indexKeyDefinitions().get(idx)).idxType();
        int rtype = right.indexSearchRow() ? DataType.getTypeFromClass(robject.getClass()) : ((IndexKeyDefinition)right.rowHandler().indexKeyDefinitions().get(idx)).idxType();
        int c = this.compareValues(this.wrap(lobject, ltype), this.wrap(robject, rtype));
        return Integer.signum(c);
    }

    public int compareKey(IndexKey left, IndexKey right) throws IgniteCheckedException {
        int cmp = super.compareKey(left, right);
        if (cmp != Integer.MIN_VALUE) {
            return cmp;
        }
        int ltype = DataType.getTypeFromClass(left.key().getClass());
        int rtype = DataType.getTypeFromClass(right.key().getClass());
        int c = this.compareValues(this.wrap(left.key(), ltype), this.wrap(right.key(), rtype));
        return Integer.signum(c);
    }

    private Value wrap(Object val, int type) throws IgniteCheckedException {
        return H2Utils.wrap((CacheObjectValueContext)this.coctx, val, type);
    }

    public int compareValues(Value v1, Value v2) throws IgniteCheckedException {
        try {
            return this.table.compareTypeSafe(v1, v2);
        }
        catch (DbException ex) {
            throw new IgniteCheckedException("Rows cannot be compared", (Throwable)ex);
        }
    }
}

