/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.cache.query.index.Index;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.IndexPlainRowImpl;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowImpl;
import org.apache.ignite.internal.cache.query.index.sorted.IndexValueCursor;
import org.apache.ignite.internal.cache.query.index.sorted.InlineIndexRowHandler;
import org.apache.ignite.internal.cache.query.index.sorted.SortedIndexDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.inline.IndexQueryContext;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexImpl;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyTypeRegistry;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKeyFactory;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.query.h2.H2Cursor;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.H2CacheRow;
import org.apache.ignite.internal.processors.query.h2.opt.H2Row;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContextRegistry;
import org.apache.ignite.internal.processors.query.h2.opt.join.CursorIteratorWrapper;
import org.apache.ignite.internal.processors.query.h2.opt.join.DistributedJoinContext;
import org.apache.ignite.internal.processors.query.h2.opt.join.DistributedLookupBatch;
import org.apache.ignite.internal.processors.query.h2.opt.join.RangeSource;
import org.apache.ignite.internal.processors.query.h2.opt.join.RangeStream;
import org.apache.ignite.internal.processors.query.h2.opt.join.SegmentKey;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2IndexRangeRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2IndexRangeResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2RowMessage;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2RowRange;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2RowRangeBounds;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessage;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessageFactory;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.lang.IgniteInClosure2X;
import org.apache.ignite.internal.util.typedef.CIX2;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.indexing.IndexingQueryCacheFilter;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.IndexLookupBatch;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.SearchRow;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.jetbrains.annotations.NotNull;

public class H2TreeIndex
extends H2TreeIndexBase {
    private final InlineIndexImpl queryIndex;
    private final GridKernalContext ctx;
    private final GridCacheContext<?, ?> cctx;
    private final String tblName;
    private final String idxName;
    private final IgniteLogger log;
    private final Object msgTopic;
    private final QueryContextRegistry qryCtxRegistry;
    private final GridMessageListener msgLsnr;
    private final CIX2<ClusterNode, Message> locNodeHnd = new CIX2<ClusterNode, Message>(){

        public void applyx(ClusterNode locNode, Message msg) {
            H2TreeIndex.this.onMessage0(locNode.id(), msg);
        }
    };

    public H2TreeIndex(InlineIndexImpl queryIndex, final GridH2Table tbl, IndexColumn[] cols, boolean pk, IgniteLogger log) {
        super(tbl, queryIndex.name(), cols, pk ? IndexType.createPrimaryKey((boolean)false, (boolean)false) : IndexType.createNonUnique((boolean)false, (boolean)false, (boolean)false));
        this.cctx = tbl.cacheContext();
        this.ctx = this.cctx.kernalContext();
        this.tblName = tbl.getName();
        this.idxName = queryIndex.name();
        this.log = log;
        this.queryIndex = queryIndex;
        this.qryCtxRegistry = ((IgniteH2Indexing)this.ctx.query().getIndexing()).queryContextRegistry();
        this.msgTopic = new IgniteBiTuple((Object)GridTopic.TOPIC_QUERY, (Object)(tbl.identifierString() + '.' + this.getName()));
        this.msgLsnr = new GridMessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(UUID nodeId, Object msg, byte plc) {
                GridSpinBusyLock l = tbl.tableDescriptor().indexing().busyLock();
                if (!l.enterBusy()) {
                    return;
                }
                try {
                    H2TreeIndex.this.onMessage0(nodeId, msg);
                }
                finally {
                    l.leaveBusy();
                }
            }
        };
        this.ctx.io().addMessageListener(this.msgTopic, this.msgLsnr);
    }

    @Override
    public int inlineSize() {
        return this.queryIndex.inlineSize();
    }

    @Override
    public int segmentsCount() {
        return this.queryIndex.segmentsCount();
    }

    @Override
    public long totalRowCount(IndexingQueryCacheFilter partsFilter) {
        return 0L;
    }

    public Cursor find(Session ses, SearchRow lower, SearchRow upper) {
        assert (lower == null || lower instanceof H2Row) : lower;
        assert (upper == null || upper instanceof H2Row) : upper;
        try {
            T2<IndexRow, IndexRow> key = this.prepareIndexKeys(lower, upper);
            QueryContext qctx = ses != null ? H2Utils.context(ses) : null;
            GridCursor cursor = this.queryIndex.find((IndexRow)key.get1(), (IndexRow)key.get2(), true, true, this.segment(qctx), this.idxQryContext(qctx));
            IndexValueCursor h2cursor = new IndexValueCursor(cursor, this::mapIndexRow);
            return new H2Cursor((GridCursor<H2Row>)h2cursor);
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    private IndexQueryContext idxQryContext(QueryContext qctx) {
        assert (qctx != null || !this.cctx.mvccEnabled());
        if (qctx == null) {
            return null;
        }
        return new IndexQueryContext(qctx.filter(), null, qctx.mvccSnapshot());
    }

    private T2<IndexRow, IndexRow> prepareIndexKeys(SearchRow lower, SearchRow upper) {
        InlineIndexRowHandler rowHnd = this.queryIndex.segment(0).rowHandler();
        return new T2((Object)this.prepareIndexKey(lower, rowHnd), (Object)this.prepareIndexKey(upper, rowHnd));
    }

    private IndexRow prepareIndexKey(SearchRow row, InlineIndexRowHandler rowHnd) {
        if (row == null) {
            return null;
        }
        if (row instanceof H2CacheRow) {
            return new IndexRowImpl(rowHnd, (CacheDataRow)row, this.getCachedKeys((H2CacheRow)row));
        }
        return this.preparePlainIndexKey(row, rowHnd);
    }

    private IndexKey[] getCachedKeys(H2CacheRow row) {
        Value key;
        IndexKey[] cached = new IndexKey[this.columnIds.length];
        for (int i = 0; i < this.columnIds.length && (key = row.getCached(this.columnIds[i])) != null; ++i) {
            cached[i] = IndexKeyFactory.wrap((Object)key, (int)this.columns[i].getType(), (CacheObjectValueContext)this.cctx.cacheObjectContext(), (IndexKeyTypeSettings)this.queryIndex.keyTypeSettings());
        }
        return cached;
    }

    private IndexRow preparePlainIndexKey(SearchRow row, InlineIndexRowHandler rowHnd) {
        int idxColsLen = this.indexColumns.length;
        IndexKey[] keys = row == null ? null : new IndexKey[idxColsLen];
        for (int i = 0; i < idxColsLen; ++i) {
            int colId = this.indexColumns[i].column.getColumnId();
            Value v = row.getValue(colId);
            IndexKeyType colType = ((IndexKeyDefinition)rowHnd.indexKeyDefinitions().get(i)).idxType();
            if (v == null) break;
            if (colType.code() != v.getType()) {
                if (Value.getHigherOrder((int)colType.code(), (int)v.getType()) == colType.code()) {
                    v = v.convertTo(colType.code());
                } else {
                    IndexKey idxKey;
                    InlineIndexKeyType colKeyType = InlineIndexKeyTypeRegistry.get((IndexKeyType)colType, (IndexKeyTypeSettings)this.queryIndex.keyTypeSettings());
                    if (colKeyType.isComparableTo(idxKey = IndexKeyFactory.wrap((Object)v.getObject(), (int)v.getType(), (CacheObjectValueContext)this.cctx.cacheObjectContext(), (IndexKeyTypeSettings)this.queryIndex.keyTypeSettings()))) {
                        keys[i] = idxKey;
                        continue;
                    }
                    LT.warn((IgniteLogger)this.log, (String)("Provided value can't be used as index search bound due to column data type mismatch. This can lead to full index scans instead of range index scans. [index=" + this.idxName + ", colType=" + colType + ", valType=" + IndexKeyType.forCode((int)v.getType()) + ']'));
                    break;
                }
            }
            keys[i] = IndexKeyFactory.wrap((Object)v.getObject(), (int)v.getType(), (CacheObjectValueContext)this.cctx.cacheObjectContext(), (IndexKeyTypeSettings)this.queryIndex.keyTypeSettings());
        }
        return new IndexPlainRowImpl(keys, rowHnd);
    }

    private H2Row mapIndexRow(IndexRow row) {
        if (row == null) {
            return null;
        }
        return new H2CacheRow(this.rowDescriptor(), row.cacheDataRow());
    }

    public long getRowCount(Session ses) {
        try {
            QueryContext qctx = H2Utils.context(ses);
            return this.queryIndex.count(this.segment(qctx), this.idxQryContext(qctx));
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    public Cursor findFirstOrLast(Session ses, boolean b) {
        try {
            QueryContext qctx = H2Utils.context(ses);
            IndexQueryContext qryCtx = this.idxQryContext(qctx);
            GridCursor cursor = b ? this.queryIndex.findFirst(this.segment(qctx), qryCtx) : this.queryIndex.findLast(this.segment(qctx), qryCtx);
            return new H2Cursor((GridCursor<H2Row>)new IndexValueCursor(cursor, this::mapIndexRow));
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    private static boolean isExpired(@NotNull H2Row row) {
        return row.expireTime() > 0L && row.expireTime() <= U.currentTimeMillis();
    }

    @Override
    public void destroy() {
        try {
            super.destroy();
        }
        finally {
            if (this.msgLsnr != null) {
                this.ctx.io().removeMessageListener(this.msgTopic, this.msgLsnr);
            }
        }
    }

    @Override
    public H2CacheRow put(H2CacheRow row) {
        throw new IllegalStateException("Must not be invoked.");
    }

    @Override
    public boolean putx(H2CacheRow row) {
        throw new IllegalStateException("Must not be invoked.");
    }

    @Override
    public boolean removex(SearchRow row) {
        throw new IllegalStateException("Must not be invoked.");
    }

    public IndexLookupBatch createLookupBatch(TableFilter[] filters, int filter) {
        QueryContext qctx = H2Utils.context(filters[filter].getSession());
        if (qctx == null || qctx.distributedJoinContext() == null || !this.getTable().isPartitioned()) {
            return null;
        }
        IndexColumn affCol = this.getTable().getAffinityKeyColumn();
        GridH2RowDescriptor desc = this.getTable().rowDescriptor();
        int affColId = -1;
        boolean ucast = false;
        if (affCol != null) {
            affColId = affCol.column.getColumnId();
            int[] masks = filters[filter].getMasks();
            if (masks != null) {
                ucast = (masks[affColId] & 1) != 0 || (masks[0] & 1) != 0 || (masks[desc.getAlternativeColumnId(0)] & 1) != 0;
            }
        }
        return new DistributedLookupBatch(this, this.cctx, ucast, affColId);
    }

    public void send(Collection<ClusterNode> nodes, Message msg) {
        boolean res = this.getTable().tableDescriptor().indexing().send(this.msgTopic, -1, nodes, msg, null, (IgniteInClosure2X<ClusterNode, Message>)this.locNodeHnd, (byte)7, false);
        if (!res) {
            throw H2Utils.retryException("Failed to send message to nodes: " + nodes);
        }
    }

    private void onMessage0(UUID nodeId, Object msg) {
        block6: {
            ClusterNode node = this.ctx.discovery().node(nodeId);
            if (node == null) {
                return;
            }
            try {
                if (msg instanceof GridH2IndexRangeRequest) {
                    this.onIndexRangeRequest(node, (GridH2IndexRangeRequest)msg);
                } else if (msg instanceof GridH2IndexRangeResponse) {
                    this.onIndexRangeResponse(node, (GridH2IndexRangeResponse)msg);
                }
            }
            catch (Throwable th) {
                U.error((IgniteLogger)this.log, (Object)("Failed to handle message[nodeId=" + nodeId + ", msg=" + msg + "]"), (Throwable)th);
                if (!(th instanceof Error)) break block6;
                throw th;
            }
        }
    }

    private void onIndexRangeRequest(ClusterNode node, GridH2IndexRangeRequest msg) {
        Span span = MTC.span();
        try (MTC.TraceSurroundings trace = MTC.support((Span)this.ctx.tracing().create(SpanType.SQL_IDX_RANGE_REQ, MTC.span()));){
            span.addTag("sql.index", () -> this.idxName);
            span.addTag("sql.table", () -> this.tblName);
            GridH2IndexRangeResponse res = new GridH2IndexRangeResponse();
            res.originNodeId(msg.originNodeId());
            res.queryId(msg.queryId());
            res.originSegmentId(msg.originSegmentId());
            res.segment(msg.segment());
            res.batchLookupId(msg.batchLookupId());
            QueryContext qctx = this.qryCtxRegistry.getShared(msg.originNodeId(), msg.queryId(), msg.originSegmentId());
            if (qctx == null) {
                res.status((byte)2);
            } else {
                DistributedJoinContext joinCtx = qctx.distributedJoinContext();
                assert (joinCtx != null);
                try {
                    GridH2RowRange range;
                    RangeSource src;
                    if (msg.bounds() != null) {
                        assert (!msg.bounds().isEmpty()) : "empty bounds";
                        src = new RangeSource(this, msg.bounds(), msg.segment(), this.idxQryContext(qctx));
                    } else {
                        src = (RangeSource)joinCtx.getSource(node.id(), msg.segment(), msg.batchLookupId());
                        assert (src != null);
                    }
                    ArrayList<GridH2RowRange> ranges = new ArrayList<GridH2RowRange>();
                    int maxRows = joinCtx.pageSize();
                    assert (maxRows > 0) : maxRows;
                    while (maxRows > 0 && (range = src.next(maxRows)) != null) {
                        ranges.add(range);
                        if (range.rows() == null) continue;
                        maxRows -= range.rows().size();
                    }
                    assert (!ranges.isEmpty());
                    if (src.hasMoreRows()) {
                        if (msg.bounds() != null) {
                            joinCtx.putSource(node.id(), msg.segment(), msg.batchLookupId(), src);
                        }
                    } else if (msg.bounds() == null) {
                        joinCtx.putSource(node.id(), msg.segment(), msg.batchLookupId(), null);
                    }
                    res.ranges(ranges);
                    res.status((byte)0);
                    span.addTag("sql.index.range.rows", () -> Integer.toString(ranges.stream().mapToInt(GridH2RowRange::rowsSize).sum()));
                }
                catch (Throwable th) {
                    span.addTag("error", th::getMessage);
                    U.error((IgniteLogger)this.log, (Object)("Failed to process request: " + msg), (Throwable)th);
                    res.error(th.getClass() + ": " + th.getMessage());
                    res.status((byte)1);
                }
            }
            this.send(Collections.singletonList(node), res);
        }
    }

    private void onIndexRangeResponse(ClusterNode node, GridH2IndexRangeResponse msg) {
        try (MTC.TraceSurroundings ignored = MTC.support((Span)this.ctx.tracing().create(SpanType.SQL_IDX_RANGE_RESP, MTC.span()));){
            QueryContext qctx = this.qryCtxRegistry.getShared(msg.originNodeId(), msg.queryId(), msg.originSegmentId());
            if (qctx == null) {
                return;
            }
            DistributedJoinContext joinCtx = qctx.distributedJoinContext();
            assert (joinCtx != null);
            Map streams = (Map)joinCtx.getStreams(msg.batchLookupId());
            if (streams == null) {
                return;
            }
            RangeStream stream = (RangeStream)streams.get(new SegmentKey(node, msg.segment()));
            assert (stream != null);
            stream.onResponse(msg);
        }
    }

    public Iterator<H2Row> findForSegment(GridH2RowRangeBounds bounds, int segment, IndexQueryContext qryCtx) {
        SearchRow lower = this.toSearchRow(bounds.first());
        SearchRow upper = this.toSearchRow(bounds.last());
        T2<IndexRow, IndexRow> key = this.prepareIndexKeys(lower, upper);
        try {
            GridCursor range = this.queryIndex.find((IndexRow)key.get1(), (IndexRow)key.get2(), true, true, segment, qryCtx);
            if (range == null) {
                range = IndexValueCursor.EMPTY;
            }
            IndexValueCursor h2cursor = new IndexValueCursor(range, this::mapIndexRow);
            H2Cursor cur = new H2Cursor((GridCursor<H2Row>)h2cursor);
            return new CursorIteratorWrapper(cur);
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    private SearchRow toSearchRow(GridH2RowMessage msg) {
        if (msg == null) {
            return null;
        }
        Value[] vals = new Value[this.getTable().getColumns().length];
        assert (vals.length > 0);
        List<GridH2ValueMessage> msgVals = msg.values();
        for (int i = 0; i < this.indexColumns.length; ++i) {
            if (i >= msgVals.size()) continue;
            try {
                vals[this.indexColumns[i].column.getColumnId()] = msgVals.get(i).value(this.ctx);
                continue;
            }
            catch (IgniteCheckedException e) {
                throw new CacheException((Throwable)e);
            }
        }
        return this.database.createRow(vals, -1);
    }

    public GridH2RowMessage toSearchRowMessage(SearchRow row) {
        if (row == null) {
            return null;
        }
        ArrayList<GridH2ValueMessage> vals = new ArrayList<GridH2ValueMessage>(this.indexColumns.length);
        for (IndexColumn idxCol : this.indexColumns) {
            Value val = row.getValue(idxCol.column.getColumnId());
            if (val == null) break;
            try {
                vals.add(GridH2ValueMessageFactory.toMessage(val));
            }
            catch (IgniteCheckedException e) {
                throw new CacheException((Throwable)e);
            }
        }
        GridH2RowMessage res = new GridH2RowMessage();
        res.values(vals);
        return res;
    }

    public long size() throws IgniteCheckedException {
        return this.queryIndex.totalCount();
    }

    public H2TreeIndex createCopy(InlineIndexImpl inlineIndex, SortedIndexDefinition idxDef) throws IgniteCheckedException {
        return new H2TreeIndex(inlineIndex, this.tbl, this.indexColumns, idxDef.primary(), this.log);
    }

    public UUID indexId() {
        return this.queryIndex.id();
    }

    public InlineIndexImpl index() {
        return this.queryIndex;
    }

    @Override
    public <T extends Index> T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this.queryIndex)) {
            return (T)((Index)clazz.cast(this.queryIndex));
        }
        return super.unwrap(clazz);
    }
}

