/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheInvalidStateException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridReservable;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.PartitionsExchangeAware;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionsReservation;
import org.apache.ignite.internal.processors.query.h2.twostep.PartitionReservation;
import org.apache.ignite.internal.processors.query.h2.twostep.PartitionReservationKey;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.Nullable;

public class PartitionReservationManager
implements PartitionsExchangeAware {
    private static final ReplicatedReservable REPLICATED_RESERVABLE = new ReplicatedReservable();
    private final GridKernalContext ctx;
    private final ConcurrentMap<PartitionReservationKey, GridReservable> reservations = new ConcurrentHashMap<PartitionReservationKey, GridReservable>();
    private final IgniteLogger log;

    public PartitionReservationManager(GridKernalContext ctx) {
        this.ctx = ctx;
        this.log = ctx.log(PartitionReservationManager.class);
        ctx.cache().context().exchange().registerExchangeAwareComponent((PartitionsExchangeAware)this);
    }

    private static GridDhtLocalPartition partition(GridCacheContext<?, ?> cctx, int p) {
        return cctx.topology().localPartition(p, AffinityTopologyVersion.NONE, false);
    }

    public PartitionReservation reservePartitions(@Nullable List<Integer> cacheIds, AffinityTopologyVersion reqTopVer, int[] explicitParts, UUID nodeId, long reqId) throws IgniteCheckedException {
        try (MTC.TraceSurroundings ignored = MTC.support((Span)this.ctx.tracing().create(SpanType.SQL_PARTITIONS_RESERVE, MTC.span()));){
            Collection<Object> partIds;
            assert (reqTopVer != null);
            AffinityTopologyVersion topVer = this.ctx.cache().context().exchange().lastAffinityChangedTopologyVersion(reqTopVer);
            if (F.isEmpty(cacheIds)) {
                PartitionReservation partitionReservation = new PartitionReservation(Collections.emptyList());
                return partitionReservation;
            }
            if (explicitParts == null) {
                partIds = null;
            } else if (explicitParts.length == 0) {
                partIds = Collections.emptyList();
            } else {
                partIds = new ArrayList(explicitParts.length);
                for (int explicitPart : explicitParts) {
                    partIds.add(explicitPart);
                }
            }
            ArrayList<GridReservable> reserved = new ArrayList<GridReservable>();
            for (int i = 0; i < cacheIds.size(); ++i) {
                GridDhtPartitionsReservation grp;
                GridDhtLocalPartition part;
                GridCacheContext cctx = this.ctx.cache().context().cacheContext(cacheIds.get(i).intValue());
                if (cctx == null) {
                    PartitionReservation explicitPart = new PartitionReservation(reserved, String.format("Failed to reserve partitions for query (cache is not found on local node) [localNodeId=%s, rmtNodeId=%s, reqId=%s, affTopVer=%s, cacheId=%s]", this.ctx.localNodeId(), nodeId, reqId, topVer, cacheIds.get(i)));
                    return explicitPart;
                }
                if (!cctx.rebalanceEnabled()) continue;
                final PartitionReservationKey grpKey = new PartitionReservationKey(cctx.name(), cctx.isReplicated() ? null : topVer);
                GridReservable r = (GridReservable)this.reservations.get(grpKey);
                if (explicitParts == null && r != null) {
                    if (r == REPLICATED_RESERVABLE) continue;
                    if (!r.reserve()) {
                        PartitionReservation partitionReservation = new PartitionReservation(reserved, String.format("Failed to reserve partitions for query (group reservation failed) [localNodeId=%s, rmtNodeId=%s, reqId=%s, affTopVer=%s, cacheId=%s, cacheName=%s]", this.ctx.localNodeId(), nodeId, reqId, topVer, cacheIds.get(i), cctx.name()));
                        return partitionReservation;
                    }
                    reserved.add(r);
                    MTC.span().addLog(() -> "Cache partitions were reserved " + r);
                    continue;
                }
                int partsCnt = cctx.affinity().partitions();
                if (cctx.isReplicated()) {
                    if (r != null) continue;
                    for (int p = 0; p < partsCnt; ++p) {
                        GridDhtPartitionState partState;
                        part = PartitionReservationManager.partition(cctx, p);
                        GridDhtPartitionState gridDhtPartitionState = partState = part != null ? part.state() : null;
                        if (partState == GridDhtPartitionState.OWNING) continue;
                        PartitionReservation partitionReservation = new PartitionReservation(reserved, String.format("Failed to reserve partitions for query (partition of REPLICATED cache is not in OWNING state) [localNodeId=%s, rmtNodeId=%s, reqId=%s, affTopVer=%s, cacheId=%s, cacheName=%s, part=%s, partFound=%s, partState=%s]", this.ctx.localNodeId(), nodeId, reqId, topVer, cacheIds.get(i), cctx.name(), p, part != null, partState));
                        return partitionReservation;
                    }
                    this.reservations.putIfAbsent(grpKey, REPLICATED_RESERVABLE);
                    MTC.span().addLog(() -> "Cache partitions were reserved [cache=" + cctx.name() + ", partitions=[0.." + partsCnt + ']');
                    continue;
                }
                if (explicitParts == null) {
                    partIds = cctx.affinity().primaryPartitions(this.ctx.localNodeId(), topVer);
                }
                int reservedCnt = 0;
                part = partIds.iterator();
                while (part.hasNext()) {
                    GridDhtPartitionState partState;
                    int partId = (Integer)part.next();
                    GridDhtLocalPartition part2 = PartitionReservationManager.partition(cctx, partId);
                    GridDhtPartitionState gridDhtPartitionState = partState = part2 != null ? part2.state() : null;
                    if (partState != GridDhtPartitionState.OWNING) {
                        if (partState == GridDhtPartitionState.LOST) {
                            PartitionReservationManager.failQueryOnLostData(cctx, part2);
                        } else {
                            PartitionReservation partitionReservation = new PartitionReservation(reserved, String.format("Failed to reserve partitions for query (partition of PARTITIONED cache is not found or not in OWNING state) [localNodeId=%s, rmtNodeId=%s, reqId=%s, affTopVer=%s, cacheId=%s, cacheName=%s, part=%s, partFound=%s, partState=%s]", this.ctx.localNodeId(), nodeId, reqId, topVer, cacheIds.get(i), cctx.name(), partId, part2 != null, partState));
                            return partitionReservation;
                        }
                    }
                    if (!part2.reserve()) {
                        PartitionReservation partitionReservation = new PartitionReservation(reserved, String.format("Failed to reserve partitions for query (partition of PARTITIONED cache cannot be reserved) [localNodeId=%s, rmtNodeId=%s, reqId=%s, affTopVer=%s, cacheId=%s, cacheName=%s, part=%s, partFound=%s, partState=%s]", this.ctx.localNodeId(), nodeId, reqId, topVer, cacheIds.get(i), cctx.name(), partId, true, partState));
                        return partitionReservation;
                    }
                    reserved.add((GridReservable)part2);
                    ++reservedCnt;
                    partState = part2.state();
                    if (partState == GridDhtPartitionState.OWNING) continue;
                    if (partState == GridDhtPartitionState.LOST) {
                        PartitionReservationManager.failQueryOnLostData(cctx, part2);
                        continue;
                    }
                    PartitionReservation partitionReservation = new PartitionReservation(reserved, String.format("Failed to reserve partitions for query (partition of PARTITIONED cache is not in OWNING state after reservation) [localNodeId=%s, rmtNodeId=%s, reqId=%s, affTopVer=%s, cacheId=%s, cacheName=%s, part=%s, partState=%s]", this.ctx.localNodeId(), nodeId, reqId, topVer, cacheIds.get(i), cctx.name(), partId, partState));
                    return partitionReservation;
                }
                Collection<Object> finalPartIds = partIds;
                MTC.span().addLog(() -> "Cache partitions were reserved [cache=" + cctx.name() + ", partitions=" + finalPartIds + ", topology=" + topVer + ']');
                if (explicitParts != null || reservedCnt <= 0 || !(grp = new GridDhtPartitionsReservation(topVer, cctx, (Object)"SQL")).register(reserved.subList(reserved.size() - reservedCnt, reserved.size()))) continue;
                if (this.reservations.putIfAbsent(grpKey, (GridReservable)grp) != null) {
                    throw new IllegalStateException("Reservation already exists.");
                }
                grp.onPublish((CI1)new CI1<GridDhtPartitionsReservation>(){

                    public void apply(GridDhtPartitionsReservation r) {
                        PartitionReservationManager.this.reservations.remove(grpKey, r);
                    }
                });
            }
            PartitionReservation partitionReservation = new PartitionReservation(reserved);
            return partitionReservation;
        }
    }

    public void onCacheStop(String cacheName) {
        for (PartitionReservationKey grpKey : this.reservations.keySet()) {
            if (!F.eq((Object)grpKey.cacheName(), (Object)cacheName)) continue;
            this.reservations.remove(grpKey);
        }
    }

    private static void failQueryOnLostData(GridCacheContext cctx, GridDhtLocalPartition part) throws IgniteCheckedException {
        throw new CacheInvalidStateException("Failed to execute query because cache partition has been lost [cacheName=" + cctx.name() + ", part=" + part + ']');
    }

    public void onDoneAfterTopologyUnlock(final GridDhtPartitionsExchangeFuture fut) {
        try {
            this.ctx.closure().runLocal((Runnable)new GridPlainRunnable(){

                public void run() {
                    AffinityTopologyVersion topVer = PartitionReservationManager.this.ctx.cache().context().exchange().lastAffinityChangedTopologyVersion(fut.topologyVersion());
                    PartitionReservationManager.this.reservations.forEach((key, r) -> {
                        if (r != REPLICATED_RESERVABLE && !F.eq((Object)key.topologyVersion(), (Object)topVer)) {
                            assert (r instanceof GridDhtPartitionsReservation);
                            ((GridDhtPartitionsReservation)r).invalidate();
                        }
                    });
                }
            }, (byte)3);
        }
        catch (Throwable e) {
            this.log.error("Unexpected exception on start reservations cleanup.");
            this.ctx.failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
        }
    }

    private static class ReplicatedReservable
    implements GridReservable {
        private ReplicatedReservable() {
        }

        public boolean reserve() {
            throw new IllegalStateException();
        }

        public void release() {
            throw new IllegalStateException();
        }
    }
}

