/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javax.cache.CacheException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMergeIndex;
import org.h2.jdbc.JdbcConnection;
import org.jetbrains.annotations.Nullable;

class ReduceQueryRun {
    private final GridRunningQueryInfo qry;
    private final List<GridMergeIndex> idxs;
    private CountDownLatch latch;
    private final JdbcConnection conn;
    private final int pageSize;
    private final AtomicReference<Object> state = new AtomicReference();

    ReduceQueryRun(Long id, String qry, String schemaName, Connection conn, int idxsCnt, int pageSize, long startTime, GridQueryCancel cancel) {
        this.qry = new GridRunningQueryInfo(id, qry, GridCacheQueryType.SQL_FIELDS, schemaName, startTime, cancel, false);
        this.conn = (JdbcConnection)conn;
        this.idxs = new ArrayList<GridMergeIndex>(idxsCnt);
        this.pageSize = pageSize > 0 ? pageSize : 1000;
    }

    void state(Object o, @Nullable UUID nodeId) {
        assert (o != null);
        assert (o instanceof CacheException || o instanceof AffinityTopologyVersion) : o.getClass();
        if (!this.state.compareAndSet(null, o)) {
            return;
        }
        while (this.latch.getCount() != 0L) {
            this.latch.countDown();
        }
        CacheException e = o instanceof CacheException ? (CacheException)o : null;
        for (GridMergeIndex idx : this.idxs) {
            idx.fail(nodeId, e);
        }
    }

    void disconnected(CacheException e) {
        this.state(e, null);
    }

    GridRunningQueryInfo queryInfo() {
        return this.qry;
    }

    int pageSize() {
        return this.pageSize;
    }

    JdbcConnection connection() {
        return this.conn;
    }

    Object state() {
        return this.state.get();
    }

    List<GridMergeIndex> indexes() {
        return this.idxs;
    }

    CountDownLatch latch() {
        return this.latch;
    }

    void latch(CountDownLatch latch) {
        this.latch = latch;
    }
}

