/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxSelectForUpdateFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.TxTopologyVersionFuture;
import org.apache.ignite.internal.processors.cache.mvcc.MvccQueryTracker;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryMarshallable;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.processors.cache.query.GridCacheTwoStepQuery;
import org.apache.ignite.internal.processors.query.GridQueryCacheObjectsIterator;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.H2FieldsIterator;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.UpdateResult;
import org.apache.ignite.internal.processors.query.h2.opt.DistributedJoinMode;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2QueryType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuerySplitter;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSortColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlType;
import org.apache.ignite.internal.processors.query.h2.twostep.DistributedUpdateRun;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMergeIndex;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMergeIndexIterator;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMergeIndexSorted;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMergeIndexUnsorted;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMergeTable;
import org.apache.ignite.internal.processors.query.h2.twostep.GridResultPage;
import org.apache.ignite.internal.processors.query.h2.twostep.GridThreadLocalTable;
import org.apache.ignite.internal.processors.query.h2.twostep.ReduceQueryRun;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryCancelRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryFailResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2DmlRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2DmlResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2QueryRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2SelectForUpdateTxDetails;
import org.apache.ignite.internal.util.GridIntIterator;
import org.apache.ignite.internal.util.GridIntList;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.lang.IgniteInClosure2X;
import org.apache.ignite.internal.util.typedef.C2;
import org.apache.ignite.internal.util.typedef.CIX2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.transactions.TransactionException;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Session;
import org.h2.index.Index;
import org.h2.jdbc.JdbcConnection;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.IntArray;
import org.jetbrains.annotations.Nullable;

public class GridReduceQueryExecutor {
    public static final long DFLT_RETRY_TIMEOUT = 30000L;
    private static final String MERGE_INDEX_UNSORTED = "merge_scan";
    private static final String MERGE_INDEX_SORTED = "merge_sorted";
    private static final Set<ClusterNode> UNMAPPED_PARTS = Collections.emptySet();
    private GridKernalContext ctx;
    private IgniteH2Indexing h2;
    private IgniteLogger log;
    private final AtomicLong qryIdGen;
    private final ConcurrentMap<Long, ReduceQueryRun> runs = new ConcurrentHashMap<Long, ReduceQueryRun>();
    private final ConcurrentMap<Long, DistributedUpdateRun> updRuns = new ConcurrentHashMap<Long, DistributedUpdateRun>();
    private volatile List<GridThreadLocalTable> fakeTbls = Collections.emptyList();
    private final Lock fakeTblsLock = new ReentrantLock();
    private final GridSpinBusyLock busyLock;
    private final CIX2<ClusterNode, Message> locNodeHnd = new CIX2<ClusterNode, Message>(){

        public void applyx(ClusterNode locNode, Message msg) {
            GridReduceQueryExecutor.this.h2.mapQueryExecutor().onMessage(locNode.id(), msg);
        }
    };

    public GridReduceQueryExecutor(AtomicLong qryIdGen, GridSpinBusyLock busyLock) {
        this.qryIdGen = qryIdGen;
        this.busyLock = busyLock;
    }

    public void start(final GridKernalContext ctx, IgniteH2Indexing h2) throws IgniteCheckedException {
        this.ctx = ctx;
        this.h2 = h2;
        this.log = ctx.log(GridReduceQueryExecutor.class);
        ctx.io().addMessageListener(GridTopic.TOPIC_QUERY, new GridMessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(UUID nodeId, Object msg, byte plc) {
                if (!GridReduceQueryExecutor.this.busyLock.enterBusy()) {
                    return;
                }
                try {
                    if (msg instanceof GridCacheQueryMarshallable) {
                        ((GridCacheQueryMarshallable)msg).unmarshall(ctx.config().getMarshaller(), ctx);
                    }
                    GridReduceQueryExecutor.this.onMessage(nodeId, msg);
                }
                finally {
                    GridReduceQueryExecutor.this.busyLock.leaveBusy();
                }
            }
        });
        ctx.event().addLocalEventListener(new GridLocalEventListener(){

            public void onEvent(Event evt) {
                UUID nodeId = ((DiscoveryEvent)evt).eventNode().id();
                block0: for (Object r : GridReduceQueryExecutor.this.runs.values()) {
                    for (GridMergeIndex idx : ((ReduceQueryRun)r).indexes()) {
                        if (!idx.hasSource(nodeId)) continue;
                        GridReduceQueryExecutor.this.handleNodeLeft((ReduceQueryRun)r, nodeId);
                        continue block0;
                    }
                }
                for (Object r : GridReduceQueryExecutor.this.updRuns.values()) {
                    ((DistributedUpdateRun)r).handleNodeLeft(nodeId);
                }
            }
        }, 12, new int[]{11});
    }

    private void handleNodeLeft(ReduceQueryRun r, UUID nodeId) {
        r.setStateOnNodeLeave(nodeId, this.h2.readyTopologyVersion());
    }

    public void onMessage(UUID nodeId, Object msg) {
        try {
            assert (msg != null);
            ClusterNode node = this.ctx.discovery().node(nodeId);
            if (node == null) {
                return;
            }
            boolean processed = true;
            if (msg instanceof GridQueryNextPageResponse) {
                this.onNextPage(node, (GridQueryNextPageResponse)msg);
            } else if (msg instanceof GridQueryFailResponse) {
                this.onFail(node, (GridQueryFailResponse)msg);
            } else if (msg instanceof GridH2DmlResponse) {
                this.onDmlResponse(node, (GridH2DmlResponse)msg);
            } else {
                processed = false;
            }
            if (processed && this.log.isDebugEnabled()) {
                this.log.debug("Processed response: " + nodeId + "->" + this.ctx.localNodeId() + " " + msg);
            }
        }
        catch (Throwable th) {
            U.error((IgniteLogger)this.log, (Object)("Failed to process message: " + msg), (Throwable)th);
        }
    }

    private void onFail(ClusterNode node, GridQueryFailResponse msg) {
        ReduceQueryRun r = (ReduceQueryRun)this.runs.get(msg.queryRequestId());
        this.fail(r, node.id(), msg.error(), msg.failCode());
    }

    private void fail(ReduceQueryRun r, UUID nodeId, String msg, byte failCode) {
        if (r != null) {
            CacheException e = new CacheException("Failed to execute map query on remote node [nodeId=" + nodeId + ", errMsg=" + msg + ']');
            if (failCode == 1) {
                e.addSuppressed((Throwable)new QueryCancelledException());
            }
            r.setStateOnException(nodeId, e);
        }
    }

    private void onNextPage(final ClusterNode node, GridQueryNextPageResponse msg) {
        GridResultPage page;
        final long qryReqId = msg.queryRequestId();
        final int qry = msg.query();
        final int seg = msg.segmentId();
        final ReduceQueryRun r = (ReduceQueryRun)this.runs.get(qryReqId);
        if (r == null) {
            return;
        }
        final int pageSize = r.pageSize();
        GridMergeIndex idx = r.indexes().get(msg.query());
        try {
            page = new GridResultPage(this.ctx, node.id(), msg){

                @Override
                public void fetchNextPage() {
                    if (r.hasErrorOrRetry()) {
                        if (r.exception() != null) {
                            throw r.exception();
                        }
                        assert (r.retryCause() != null);
                        throw new CacheException(r.retryCause());
                    }
                    try {
                        GridQueryNextPageRequest msg0 = new GridQueryNextPageRequest(qryReqId, qry, seg, pageSize);
                        if (node.isLocal()) {
                            GridReduceQueryExecutor.this.h2.mapQueryExecutor().onMessage(GridReduceQueryExecutor.this.ctx.localNodeId(), msg0);
                        } else {
                            GridReduceQueryExecutor.this.ctx.io().sendToGridTopic(node, GridTopic.TOPIC_QUERY, (Message)msg0, (byte)10);
                        }
                    }
                    catch (IgniteCheckedException e) {
                        throw new CacheException("Failed to fetch data from node: " + node.id(), (Throwable)e);
                    }
                }
            };
        }
        catch (Exception e) {
            U.error((IgniteLogger)this.log, (Object)"Error in message.", (Throwable)e);
            this.fail(r, node.id(), "Error in message.", (byte)0);
            return;
        }
        idx.addPage(page);
        if (msg.retry() != null) {
            r.setStateOnRetry(node.id(), msg.retry(), msg.retryCause());
        } else if (msg.page() == 0) {
            r.latch().countDown();
            GridNearTxSelectForUpdateFuture sfuFut = r.selectForUpdateFuture();
            if (sfuFut != null) {
                sfuFut.onResult(node.id(), Long.valueOf(msg.allRows()), msg.removeMapping(), null);
            }
        }
    }

    private boolean isPreloadingActive(List<Integer> cacheIds) {
        for (Integer cacheId : cacheIds) {
            if (null == this.cacheContext(cacheId)) {
                throw new CacheException(String.format("Cache not found on local node [cacheId=%d]", cacheId));
            }
            if (!this.hasMovingPartitions(this.cacheContext(cacheId))) continue;
            return true;
        }
        return false;
    }

    private boolean hasMovingPartitions(GridCacheContext<?, ?> cctx) {
        assert (cctx != null);
        return !cctx.isLocal() && cctx.topology().hasMovingPartitions();
    }

    private GridCacheContext<?, ?> cacheContext(Integer cacheId) {
        return this.ctx.cache().context().cacheContext(cacheId.intValue());
    }

    private Map<ClusterNode, IntArray> stableDataNodesMap(AffinityTopologyVersion topVer, GridCacheContext<?, ?> cctx, @Nullable int[] parts) {
        GridIntIterator iter;
        HashMap<ClusterNode, IntArray> mapping = new HashMap<ClusterNode, IntArray>();
        if (cctx.isReplicated()) {
            for (ClusterNode clusterNode : cctx.affinity().assignment(topVer).nodes()) {
                mapping.put(clusterNode, null);
            }
            return mapping;
        }
        List assignment = cctx.affinity().assignment(topVer).assignment();
        boolean needPartsFilter = parts != null;
        GridIntIterator gridIntIterator = iter = needPartsFilter ? new GridIntList(parts).iterator() : U.forRange((int)0, (int)cctx.affinity().partitions());
        while (iter.hasNext()) {
            int partId = iter.next();
            List partNodes = (List)assignment.get(partId);
            if (partNodes.isEmpty()) continue;
            ClusterNode prim = (ClusterNode)partNodes.get(0);
            if (!needPartsFilter) {
                mapping.put(prim, null);
                continue;
            }
            IntArray partIds = (IntArray)mapping.get(prim);
            if (partIds == null) {
                partIds = new IntArray();
                mapping.put(prim, partIds);
            }
            partIds.add(partId);
        }
        return mapping;
    }

    private void logRetry(String msg) {
        this.log.info(msg);
    }

    private Map<ClusterNode, IntArray> stableDataNodes(boolean isReplicatedOnly, AffinityTopologyVersion topVer, List<Integer> cacheIds, int[] parts, long qryId) {
        GridCacheContext<?, ?> cctx = this.cacheContext(cacheIds.get(0));
        if (!cctx.isPartitioned()) {
            for (int cacheId = 1; cacheId < cacheIds.size(); ++cacheId) {
                GridCacheContext<?, ?> currCctx = this.cacheContext(cacheIds.get(cacheId));
                if (!currCctx.isPartitioned()) continue;
                Collections.swap(cacheIds, 0, cacheId);
                cctx = currCctx;
                break;
            }
        }
        Map<ClusterNode, IntArray> map = this.stableDataNodesMap(topVer, cctx, parts);
        Set<ClusterNode> nodes = map.keySet();
        if (F.isEmpty(map)) {
            throw new CacheException("Failed to find data nodes for cache: " + cctx.name());
        }
        for (int i = 1; i < cacheIds.size(); ++i) {
            boolean disjoint;
            GridCacheContext<?, ?> extraCctx = this.cacheContext(cacheIds.get(i));
            String extraCacheName = extraCctx.name();
            if (extraCctx.isLocal()) continue;
            if (isReplicatedOnly && !extraCctx.isReplicated()) {
                throw new CacheException("Queries running on replicated cache should not contain JOINs with partitioned tables [replicatedCache=" + cctx.name() + ", partitionedCache=" + extraCacheName + "]");
            }
            Set<ClusterNode> extraNodes = this.stableDataNodesMap(topVer, extraCctx, parts).keySet();
            if (F.isEmpty(extraNodes)) {
                throw new CacheException("Failed to find data nodes for cache: " + extraCacheName);
            }
            if (extraCctx.isReplicated()) {
                if (isReplicatedOnly) {
                    nodes.retainAll(extraNodes);
                    disjoint = map.isEmpty();
                } else {
                    disjoint = !extraNodes.containsAll(nodes);
                }
            } else {
                boolean bl = disjoint = !extraNodes.equals(nodes);
            }
            if (!disjoint) continue;
            if (this.isPreloadingActive(cacheIds)) {
                this.logRetry("Failed to calculate nodes for SQL query (got disjoint node map during rebalance) [qryId=" + qryId + ", affTopVer=" + topVer + ", cacheIds=" + cacheIds + ", parts=" + (parts == null ? "[]" : Arrays.toString(parts)) + ", replicatedOnly=" + isReplicatedOnly + ", lastCache=" + extraCctx.name() + ", lastCacheId=" + extraCctx.cacheId() + ']');
                return null;
            }
            throw new CacheException("Caches have distinct sets of data nodes [cache1=" + cctx.name() + ", cache2=" + extraCacheName + "]");
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Iterator<List<?>> query(String schemaName, GridCacheTwoStepQuery qry, boolean keepBinary, boolean enforceJoinOrder, int timeoutMillis, GridQueryCancel cancel, Object[] params, int[] parts, boolean lazy, MvccQueryTracker mvccTracker) {
        if (!GridReduceQueryExecutor.$assertionsDisabled && qry.mvccEnabled() && mvccTracker == null) {
            throw new AssertionError();
        }
        if (F.isEmpty((Object[])params)) {
            params = GridCacheSqlQuery.EMPTY_PARAMS;
        }
        isReplicatedOnly = qry.isReplicatedOnly();
        retryTimeout = GridReduceQueryExecutor.retryTimeout(timeoutMillis);
        startTime = U.currentTimeMillis();
        lastRun = null;
        attempt = 0;
        while (true) {
            block77: {
                block78: {
                    if (attempt > 0 && retryTimeout > 0L && U.currentTimeMillis() - startTime > retryTimeout) {
                        retryNodeId = lastRun.retryNodeId();
                        retryCause = lastRun.retryCause();
                        if (!GridReduceQueryExecutor.$assertionsDisabled && F.isEmpty((String)retryCause)) {
                            throw new AssertionError();
                        }
                        throw new CacheException("Failed to map SQL query to topology on data node [dataNodeId=" + retryNodeId + ", msg=" + retryCause + ']');
                    }
                    if (attempt != 0) {
                        try {
                            Thread.sleep(attempt * 10);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new CacheException("Query was interrupted.", (Throwable)e);
                        }
                    }
                    qryReqId = this.qryIdGen.incrementAndGet();
                    cacheIds = qry.cacheIds();
                    mvccEnabled = MvccUtils.mvccEnabled((GridKernalContext)this.ctx);
                    v0 = curTx = mvccEnabled != false ? MvccUtils.checkActive((GridNearTxLocal)MvccUtils.tx((GridKernalContext)this.ctx)) : null;
                    if (qry.forUpdate()) {
                        if (!(GridReduceQueryExecutor.$assertionsDisabled || mvccEnabled && curTx != null)) {
                            throw new AssertionError();
                        }
                        try {
                            topFut = new TxTopologyVersionFuture(curTx, mvccTracker.context());
                            topVer = (AffinityTopologyVersion)topFut.get();
                            clientFirst = topFut.clientFirst();
                        }
                        catch (IgniteCheckedException e) {
                            throw new IgniteSQLException("Failed to map SELECT FOR UPDATE query on topology.", (Throwable)e);
                        }
                        sfuFut = new GridNearTxSelectForUpdateFuture(mvccTracker.context(), curTx, (long)timeoutMillis);
                    } else {
                        sfuFut = null;
                        clientFirst = false;
                        topVer = this.h2.readyTopologyVersion();
                        if (this.h2.serverTopologyChanged(topVer) && this.ctx.cache().context().lockedTopologyVersion(null) != null) {
                            throw new CacheException((Throwable)new TransactionException("Server topology is changed during query execution inside a transaction. It's recommended to rollback and retry transaction."));
                        }
                    }
                    r = new ReduceQueryRun(qryReqId, qry.originalSql(), schemaName, this.h2.connectionForSchema(schemaName), qry.mapQueries().size(), qry.pageSize(), U.currentTimeMillis(), sfuFut, cancel);
                    partsMap = null;
                    qryMap = null;
                    if (parts != null) {
                        replicatedOnly = true;
                        for (Integer cacheId : cacheIds) {
                            if (this.cacheContext(cacheId).isReplicated()) continue;
                            replicatedOnly = false;
                            break;
                        }
                        if (replicatedOnly) {
                            throw new CacheException("Partitions are not supported for replicated caches");
                        }
                    }
                    if (!qry.isLocal()) break block78;
                    nodes = Collections.singletonList(this.ctx.discovery().localNode());
                    ** GOTO lbl74
                }
                nodesParts = this.nodesForPartitions(cacheIds, topVer, parts, isReplicatedOnly, qryReqId);
                nodes = nodesParts.nodes();
                partsMap = nodesParts.partitionsMap();
                qryMap = nodesParts.queryPartitionsMap();
                if (nodes == null) {
                    if (sfuFut != null) {
                        sfuFut.onDone((Object)0L, null);
                    }
                } else {
                    if (!GridReduceQueryExecutor.$assertionsDisabled && nodes.isEmpty()) {
                        throw new AssertionError();
                    }
                    if (isReplicatedOnly || qry.explain()) {
                        locNode = this.ctx.discovery().localNode();
                        nodes = nodes.contains(locNode) != false ? Collections.singletonList(locNode) : Collections.singletonList(F.rand(nodes));
                    }
lbl74:
                    // 4 sources

                    if (sfuFut != null && !sfuFut.isFailed()) {
                        sfuFut.init(topVer, nodes);
                    }
                    tblIdx = 0;
                    skipMergeTbl = qry.explain() == false && qry.skipMergeTable() != false;
                    segmentsPerIndex = qry.explain() != false || isReplicatedOnly != false ? 1 : this.findFirstPartitioned(cacheIds).config().getQueryParallelism();
                    replicatedQrysCnt = 0;
                    finalNodes = nodes;
                    for (GridCacheSqlQuery mapQry : qry.mapQueries()) {
                        if (!skipMergeTbl) {
                            try {
                                tbl = this.createMergeTable(r.connection(), mapQry, qry.explain());
                            }
                            catch (IgniteCheckedException e) {
                                throw new IgniteException((Throwable)e);
                            }
                            idx = tbl.getMergeIndex();
                            this.fakeTable((Connection)r.connection(), tblIdx++).innerTable((Table)tbl);
                        } else {
                            idx = GridMergeIndexUnsorted.createDummy(this.ctx);
                        }
                        if (!mapQry.isPartitioned()) {
                            node = (ClusterNode)F.rand(nodes);
                            mapQry.node(node.id());
                            ++replicatedQrysCnt;
                            idx.setSources(Collections.singletonList(node), 1);
                        } else {
                            idx.setSources(nodes, segmentsPerIndex);
                        }
                        idx.setPageSize(r.pageSize());
                        r.indexes().add((GridMergeIndex)idx);
                    }
                    r.latch(new CountDownLatch(isReplicatedOnly != false ? 1 : (r.indexes().size() - replicatedQrysCnt) * nodes.size() * segmentsPerIndex + replicatedQrysCnt));
                    this.runs.put(qryReqId, r);
                    release = true;
                    try {
                        cancel.checkCancelled();
                        if (this.ctx.clientDisconnected()) {
                            throw new CacheException("Query was cancelled, client node disconnected.", (Throwable)new IgniteClientDisconnectedException(this.ctx.cluster().clientReconnectFuture(), "Client node disconnected."));
                        }
                        mapQrys = qry.mapQueries();
                        if (qry.explain()) {
                            mapQrys = new ArrayList<GridCacheSqlQuery>(qry.mapQueries().size());
                            for (GridCacheSqlQuery mapQry : qry.mapQueries()) {
                                mapQrys.add(new GridCacheSqlQuery("EXPLAIN " + mapQry.query()).parameterIndexes(mapQry.parameterIndexes()));
                            }
                        }
                        distributedJoins = qry.distributedJoins();
                        qryReqId0 = qryReqId;
                        cancel.set(new Runnable(){

                            @Override
                            public void run() {
                                GridReduceQueryExecutor.this.send(finalNodes, (Message)new GridQueryCancelRequest(qryReqId0), null, false);
                            }
                        });
                        retry = false;
                        flags = 2;
                        if (distributedJoins) {
                            flags |= 1;
                        }
                        if (qry.isLocal()) {
                            flags |= 4;
                        }
                        if (qry.explain()) {
                            flags |= 8;
                        }
                        if (isReplicatedOnly) {
                            flags |= 16;
                        }
                        if (lazy && mapQrys.size() == 1) {
                            flags |= 32;
                        }
                        req = new GridH2QueryRequest().requestId(qryReqId).topologyVersion(topVer).pageSize(r.pageSize()).caches(qry.cacheIds()).tables(distributedJoins != false ? qry.tables() : null).partitions(GridReduceQueryExecutor.convert(partsMap)).queries(mapQrys).parameters(params).flags(flags).timeout(timeoutMillis).schemaName(schemaName);
                        if (curTx != null && curTx.mvccSnapshot() != null) {
                            req.mvccSnapshot(curTx.mvccSnapshot());
                        } else if (mvccTracker != null) {
                            req.mvccSnapshot(mvccTracker.snapshot());
                        }
                        v1 = pspec = parts == null ? null : new ExplicitPartitionsSpecializer(qryMap);
                        if (qry.forUpdate()) {
                            cnt = new AtomicInteger();
                            spec /* !! */  = new C2<ClusterNode, Message, Message>(){

                                public Message apply(ClusterNode clusterNode, Message msg) {
                                    assert (msg instanceof GridH2QueryRequest);
                                    GridH2QueryRequest res = pspec != null ? (GridH2QueryRequest)pspec.apply((Object)clusterNode, (Object)msg) : new GridH2QueryRequest((GridH2QueryRequest)msg);
                                    GridH2SelectForUpdateTxDetails txReq = new GridH2SelectForUpdateTxDetails(curTx.threadId(), IgniteUuid.randomUuid(), cnt.incrementAndGet(), curTx.subjectId(), curTx.xidVersion(), curTx.taskNameHash(), clientFirst, curTx.remainingTime());
                                    res.txDetails(txReq);
                                    return res;
                                }
                            };
                        } else {
                            spec /* !! */  = pspec;
                        }
                        if (this.send(nodes, req, (IgniteBiClosure<ClusterNode, Message, Message>)spec /* !! */ , false)) {
                            this.awaitAllReplies(r, nodes, cancel);
                            if (r.hasErrorOrRetry()) {
                                err = r.exception();
                                if (err != null) {
                                    if (err.getCause() instanceof IgniteClientDisconnectedException) {
                                        throw err;
                                    }
                                    if (this.wasCancelled(err)) {
                                        throw new QueryCancelledException();
                                    }
                                    throw err;
                                }
                                retry = true;
                                if (!GridReduceQueryExecutor.$assertionsDisabled && sfuFut != null) {
                                    throw new AssertionError();
                                }
                                this.h2.awaitForReadyTopologyVersion(r.retryTopologyVersion());
                            }
                        } else {
                            retry = true;
                        }
                        resIter /* !! */  = null;
                        if (retry) {
                            if (!GridReduceQueryExecutor.$assertionsDisabled && r == null) {
                                throw new AssertionError();
                            }
                            lastRun = r;
                            if (Thread.currentThread().isInterrupted()) {
                                throw new IgniteInterruptedCheckedException("Query was interrupted.");
                            }
                            if (sfuFut != null) {
                                sfuFut.onDone((Object)0L);
                            }
                            break block77;
                        }
                        if (skipMergeTbl) {
                            resIter /* !! */  = new GridMergeIndexIterator(this, finalNodes, r, qryReqId, qry.distributedJoins(), mvccTracker);
                            release = false;
                        } else {
                            cancel.checkCancelled();
                            locNodeId = this.ctx.localNodeId();
                            H2Utils.setupConnection((Connection)r.connection(), false, enforceJoinOrder);
                            GridH2QueryContext.set(new GridH2QueryContext(locNodeId, locNodeId, qryReqId, GridH2QueryType.REDUCE).pageSize(r.pageSize()).distributedJoinMode(DistributedJoinMode.OFF));
                            try {
                                if (qry.explain()) {
                                    var47_58 = this.explainPlan(r.connection(), qry, params);
                                    return var47_58;
                                }
                                rdc = qry.reduceQuery();
                                res = this.h2.executeSqlQueryWithTimer((Connection)r.connection(), rdc.query(), F.asList((Object[])rdc.parameters(params)), false, timeoutMillis, cancel);
                                resIter /* !! */  = new H2FieldsIterator(res, mvccTracker, false);
                                mvccTracker = null;
                            }
                            finally {
                                GridH2QueryContext.clearThreadLocal();
                            }
                        }
                        if (sfuFut != null) {
                            sfuFut.get();
                        }
                        var46_56 = new GridQueryCacheObjectsIterator((Iterator)resIter /* !! */ , this.h2.objectContext(), keepBinary);
                        return var46_56;
                    }
                    catch (RuntimeException | IgniteCheckedException e) {
                        release = true;
                        U.closeQuiet((AutoCloseable)r.connection());
                        resEx = null;
                        if (e instanceof CacheException) {
                            resEx = this.wasCancelled((CacheException)e) != false ? new CacheException("Failed to run reduce query locally.", (Throwable)new QueryCancelledException()) : (CacheException)e;
                        }
                        if (resEx != null) {
                            if (sfuFut != null) {
                                sfuFut.onDone(resEx);
                            }
                            throw resEx;
                        }
                        cause = e;
                        if (e instanceof IgniteCheckedException && (disconnectedErr = ((IgniteCheckedException)e).getCause(IgniteClientDisconnectedException.class)) != null) {
                            cause = disconnectedErr;
                        }
                        resEx = new CacheException("Failed to run reduce query locally.", cause);
                        if (sfuFut != null) {
                            sfuFut.onDone((Throwable)resEx);
                        }
                        throw resEx;
                    }
                    finally {
                        if (release) {
                            this.releaseRemoteResources(finalNodes, r, qryReqId, qry.distributedJoins(), mvccTracker);
                            if (!skipMergeTbl) {
                                mapQrys = qry.mapQueries().size();
                                for (i = 0; i < mapQrys; ++i) {
                                    this.fakeTable(null, i).innerTable(null);
                                }
                            }
                        }
                    }
                }
            }
            ++attempt;
        }
    }

    public UpdateResult update(String schemaName, List<Integer> cacheIds, String selectQry, Object[] params, boolean enforceJoinOrder, int pageSize, int timeoutMillis, int[] parts, boolean isReplicatedOnly, GridQueryCancel cancel) {
        int flags;
        AffinityTopologyVersion topVer = this.h2.readyTopologyVersion();
        final long reqId = this.qryIdGen.incrementAndGet();
        NodesForPartitionsResult nodesParts = this.nodesForPartitions(cacheIds, topVer, parts, isReplicatedOnly, reqId);
        GridRunningQueryInfo qryInfo = new GridRunningQueryInfo(Long.valueOf(reqId), selectQry, GridCacheQueryType.SQL_FIELDS, schemaName, U.currentTimeMillis(), cancel, false);
        Collection<ClusterNode> nodes = nodesParts.nodes();
        if (nodes == null) {
            throw new CacheException("Failed to determine nodes participating in the update. Explanation (Retry update once topology recovers).");
        }
        if (isReplicatedOnly) {
            ClusterNode locNode = this.ctx.discovery().localNode();
            nodes = nodes.contains(locNode) ? Collections.singletonList(locNode) : Collections.singletonList(F.rand(nodes));
        }
        for (ClusterNode n : nodes) {
            if (n.version().greaterThanEqual(2, 3, 0)) continue;
            this.log.warning("Server-side DML optimization is skipped because map node does not support it. Falling back to normal DML. [node=" + n.id() + ", v=" + n.version() + "].");
            return null;
        }
        final DistributedUpdateRun r = new DistributedUpdateRun(nodes.size(), qryInfo);
        int n = flags = enforceJoinOrder ? 2 : 0;
        if (isReplicatedOnly) {
            flags |= 0x10;
        }
        GridH2DmlRequest req = new GridH2DmlRequest().requestId(reqId).topologyVersion(topVer).caches(cacheIds).schemaName(schemaName).query(selectQry).pageSize(pageSize).parameters(params).timeout(timeoutMillis).flags(flags);
        this.updRuns.put(reqId, r);
        boolean release = false;
        try {
            Map<ClusterNode, IntArray> partsMap = nodesParts.queryPartitionsMap() != null ? nodesParts.queryPartitionsMap() : nodesParts.partitionsMap();
            ExplicitPartitionsSpecializer partsSpec = parts == null ? null : new ExplicitPartitionsSpecializer(partsMap);
            final Collection<ClusterNode> finalNodes = nodes;
            cancel.set(new Runnable(){

                @Override
                public void run() {
                    r.future().onCancelled();
                    GridReduceQueryExecutor.this.send(finalNodes, (Message)new GridQueryCancelRequest(reqId), null, false);
                }
            });
            if (this.send(nodes, req, (IgniteBiClosure<ClusterNode, Message, Message>)partsSpec, false)) {
                UpdateResult updateResult = (UpdateResult)r.future().get();
                return updateResult;
            }
            try {
                throw new CacheException("Failed to send update request to participating nodes.");
            }
            catch (RuntimeException | IgniteCheckedException e) {
                release = true;
                U.error((IgniteLogger)this.log, (Object)("Error during update [localNodeId=" + this.ctx.localNodeId() + "]"), (Throwable)e);
                throw new CacheException("Failed to run update. " + e.getMessage(), e);
            }
        }
        finally {
            if (release) {
                this.send(nodes, (Message)new GridQueryCancelRequest(reqId), null, false);
            }
            if (!this.updRuns.remove(reqId, r)) {
                U.warn((IgniteLogger)this.log, (Object)("Update run was already removed: " + reqId));
            }
        }
    }

    private void onDmlResponse(ClusterNode node, GridH2DmlResponse msg) {
        try {
            long reqId = msg.requestId();
            DistributedUpdateRun r = (DistributedUpdateRun)this.updRuns.get(reqId);
            if (r == null) {
                U.warn((IgniteLogger)this.log, (Object)("Unexpected dml response (will ignore). [localNodeId=" + this.ctx.localNodeId() + ", nodeId=" + node.id() + ", msg=" + msg.toString() + ']'));
                return;
            }
            r.handleResponse(node.id(), msg);
        }
        catch (Exception e) {
            U.error((IgniteLogger)this.log, (Object)("Error in dml response processing. [localNodeId=" + this.ctx.localNodeId() + ", nodeId=" + node.id() + ", msg=" + msg.toString() + ']'), (Throwable)e);
        }
    }

    private GridCacheContext<?, ?> findFirstPartitioned(List<Integer> cacheIds) {
        for (int i = 0; i < cacheIds.size(); ++i) {
            GridCacheContext<?, ?> cctx = this.cacheContext(cacheIds.get(i));
            if (i == 0 && cctx.isLocal()) {
                throw new CacheException("Cache is LOCAL: " + cctx.name());
            }
            if (cctx.isReplicated() || cctx.isLocal()) continue;
            return cctx;
        }
        throw new IllegalStateException("Failed to find partitioned cache.");
    }

    private boolean wasCancelled(CacheException e) {
        return X.hasSuppressed((Throwable)e, QueryCancelledException.class);
    }

    public void releaseRemoteResources(Collection<ClusterNode> nodes, ReduceQueryRun r, long qryReqId, boolean distributedJoins, MvccQueryTracker mvccTracker) {
        if (distributedJoins) {
            this.send(nodes, (Message)new GridQueryCancelRequest(qryReqId), null, false);
        } else {
            for (GridMergeIndex idx : r.indexes()) {
                if (idx.fetchedAll()) continue;
                this.send(nodes, (Message)new GridQueryCancelRequest(qryReqId), null, false);
                break;
            }
        }
        if (!this.runs.remove(qryReqId, r)) {
            U.warn((IgniteLogger)this.log, (Object)("Query run was already removed: " + qryReqId));
        } else if (mvccTracker != null) {
            mvccTracker.onDone();
        }
    }

    private void awaitAllReplies(ReduceQueryRun r, Collection<ClusterNode> nodes, GridQueryCancel cancel) throws IgniteInterruptedCheckedException, QueryCancelledException {
        while (!U.await((CountDownLatch)r.latch(), (long)500L, (TimeUnit)TimeUnit.MILLISECONDS)) {
            cancel.checkCancelled();
            for (ClusterNode node : nodes) {
                if (this.ctx.discovery().alive(node)) continue;
                this.handleNodeLeft(r, node.id());
                assert (r.latch().getCount() == 0L);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GridThreadLocalTable fakeTable(Connection c, int idx) {
        List<GridThreadLocalTable> tbls;
        block19: {
            tbls = this.fakeTbls;
            assert (tbls.size() >= idx);
            if (tbls.size() == idx) {
                this.fakeTblsLock.lock();
                try {
                    tbls = this.fakeTbls;
                    if (tbls.size() != idx) break block19;
                    try (Statement stmt = c.createStatement();){
                        stmt.executeUpdate("CREATE TABLE " + GridSqlQuerySplitter.mergeTableIdentifier(idx) + "(fake BOOL) ENGINE \"" + GridThreadLocalTable.Engine.class.getName() + '\"');
                    }
                    catch (SQLException e) {
                        throw new IllegalStateException(e);
                    }
                    ArrayList<GridThreadLocalTable> newTbls = new ArrayList<GridThreadLocalTable>(tbls.size() + 1);
                    newTbls.addAll(tbls);
                    newTbls.add(GridThreadLocalTable.Engine.getCreated());
                    this.fakeTbls = tbls = newTbls;
                }
                finally {
                    this.fakeTblsLock.unlock();
                }
            }
        }
        return tbls.get(idx);
    }

    private Collection<ClusterNode> replicatedUnstableDataNodes(List<Integer> cacheIds, long qryId) {
        Set<ClusterNode> nodes;
        GridCacheContext<?, ?> cctx;
        int i = 0;
        if (!(cctx = this.cacheContext(cacheIds.get(i++))).isReplicated()) {
            assert (cacheIds.size() > 1) : "no extra replicated caches with partitioned main cache";
            cctx = this.cacheContext(cacheIds.get(i++));
            assert (cctx.isReplicated()) : "all the extra caches must be replicated here";
        }
        if (F.isEmpty(nodes = this.replicatedUnstableDataNodes(cctx, qryId))) {
            return null;
        }
        while (i < cacheIds.size()) {
            GridCacheContext<?, ?> extraCctx = this.cacheContext(cacheIds.get(i));
            if (!extraCctx.isLocal()) {
                if (!extraCctx.isReplicated()) {
                    throw new CacheException("Queries running on replicated cache should not contain JOINs with tables in partitioned caches [replicatedCache=" + cctx.name() + ", partitionedCache=" + extraCctx.name() + "]");
                }
                Set<ClusterNode> extraOwners = this.replicatedUnstableDataNodes(extraCctx, qryId);
                if (F.isEmpty(extraOwners)) {
                    return null;
                }
                nodes.retainAll(extraOwners);
                if (nodes.isEmpty()) {
                    this.logRetry("Failed to calculate nodes for SQL query (got disjoint node map for REPLICATED caches during rebalance) [qryId=" + qryId + ", cacheIds=" + cacheIds + ", lastCache=" + extraCctx.name() + ", lastCacheId=" + extraCctx.cacheId() + ']');
                    return null;
                }
            }
            ++i;
        }
        return nodes;
    }

    private Collection<ClusterNode> dataNodes(int grpId, AffinityTopologyVersion topVer) {
        Set<ClusterNode> res = this.ctx.discovery().cacheGroupAffinityNodes(grpId, topVer);
        return res != null ? res : Collections.emptySet();
    }

    private Set<ClusterNode> replicatedUnstableDataNodes(GridCacheContext<?, ?> cctx, long qryId) {
        assert (cctx.isReplicated()) : cctx.name() + " must be replicated";
        String cacheName = cctx.name();
        HashSet<ClusterNode> dataNodes = new HashSet<ClusterNode>(this.dataNodes(cctx.groupId(), AffinityTopologyVersion.NONE));
        if (dataNodes.isEmpty()) {
            throw new CacheException("Failed to find data nodes for cache: " + cacheName);
        }
        int parts = cctx.affinity().partitions();
        for (int p = 0; p < parts; ++p) {
            List owners = cctx.topology().owners(p);
            if (F.isEmpty((Collection)owners)) {
                this.logRetry("Failed to calculate nodes for SQL query (partition of a REPLICATED cache has no owners) [qryId=" + qryId + ", cacheName=" + cctx.name() + ", cacheId=" + cctx.cacheId() + ", part=" + p + ']');
                return null;
            }
            dataNodes.retainAll(owners);
            if (!dataNodes.isEmpty()) continue;
            this.logRetry("Failed to calculate nodes for SQL query (partitions of a REPLICATED has no common owners) [qryId=" + qryId + ", cacheName=" + cctx.name() + ", cacheId=" + cctx.cacheId() + ", lastPart=" + p + ']');
            return null;
        }
        return dataNodes;
    }

    private Map<ClusterNode, IntArray> partitionedUnstableDataNodes(List<Integer> cacheIds, long qryId) {
        GridCacheContext<?, ?> cctx = this.findFirstPartitioned(cacheIds);
        int partsCnt = cctx.affinity().partitions();
        if (cacheIds.size() > 1) {
            for (Integer cacheId : cacheIds) {
                int parts;
                GridCacheContext<?, ?> extraCctx = this.cacheContext(cacheId);
                if (extraCctx.isReplicated() || extraCctx.isLocal() || (parts = extraCctx.affinity().partitions()) == partsCnt) continue;
                throw new CacheException("Number of partitions must be the same for correct collocation [cache1=" + cctx.name() + ", parts1=" + partsCnt + ", cache2=" + extraCctx.name() + ", parts2=" + parts + "]");
            }
        }
        Set[] partLocs = new Set[partsCnt];
        for (int p = 0; p < partsCnt; ++p) {
            List owners = cctx.topology().owners(p);
            if (F.isEmpty((Collection)owners)) {
                if (F.isEmpty((Collection)cctx.affinity().assignment(AffinityTopologyVersion.NONE).get(p))) {
                    partLocs[p] = UNMAPPED_PARTS;
                    continue;
                }
                if (!F.isEmpty(this.dataNodes(cctx.groupId(), AffinityTopologyVersion.NONE))) {
                    this.logRetry("Failed to calculate nodes for SQL query (partition has no owners, but corresponding cache group has data nodes) [qryId=" + qryId + ", cacheIds=" + cacheIds + ", cacheName=" + cctx.name() + ", cacheId=" + cctx.cacheId() + ", part=" + p + ", cacheGroupId=" + cctx.groupId() + ']');
                    return null;
                }
                throw new CacheException("Failed to find data nodes [cache=" + cctx.name() + ", part=" + p + "]");
            }
            partLocs[p] = new HashSet(owners);
        }
        if (cacheIds.size() > 1) {
            for (Integer cacheId : cacheIds) {
                GridCacheContext<?, ?> extraCctx = this.cacheContext(cacheId);
                if (cctx == extraCctx || extraCctx.isReplicated() || extraCctx.isLocal()) continue;
                int parts = extraCctx.affinity().partitions();
                for (int p = 0; p < parts; ++p) {
                    List owners = extraCctx.topology().owners(p);
                    if (partLocs[p] == UNMAPPED_PARTS) continue;
                    if (F.isEmpty((Collection)owners)) {
                        if (!F.isEmpty(this.dataNodes(extraCctx.groupId(), AffinityTopologyVersion.NONE))) {
                            this.logRetry("Failed to calculate nodes for SQL query (partition has no owners, but corresponding cache group has data nodes) [qryId=" + qryId + ", cacheIds=" + cacheIds + ", cacheName=" + extraCctx.name() + ", cacheId=" + extraCctx.cacheId() + ", part=" + p + ", cacheGroupId=" + extraCctx.groupId() + ']');
                            return null;
                        }
                        throw new CacheException("Failed to find data nodes [cache=" + extraCctx.name() + ", part=" + p + "]");
                    }
                    if (partLocs[p] == null) {
                        partLocs[p] = new HashSet(owners);
                        continue;
                    }
                    partLocs[p].retainAll(owners);
                    if (!partLocs[p].isEmpty()) continue;
                    this.logRetry("Failed to calculate nodes for SQL query (caches have no common data nodes for partition) [qryId=" + qryId + ", cacheIds=" + cacheIds + ", lastCacheName=" + extraCctx.name() + ", lastCacheId=" + extraCctx.cacheId() + ", part=" + p + ']');
                    return null;
                }
            }
            for (Integer cacheId : cacheIds) {
                GridCacheContext<?, ?> extraCctx = this.cacheContext(cacheId);
                if (!extraCctx.isReplicated()) continue;
                Set<ClusterNode> dataNodes = this.replicatedUnstableDataNodes(extraCctx, qryId);
                if (F.isEmpty(dataNodes)) {
                    return null;
                }
                int part = 0;
                for (Set partLoc : partLocs) {
                    if (partLoc == UNMAPPED_PARTS) continue;
                    partLoc.retainAll(dataNodes);
                    if (partLoc.isEmpty()) {
                        this.logRetry("Failed to calculate nodes for SQL query (caches have no common data nodes for partition) [qryId=" + qryId + ", cacheIds=" + cacheIds + ", lastReplicatedCacheName=" + extraCctx.name() + ", lastReplicatedCacheId=" + extraCctx.cacheId() + ", part=" + part + ']');
                        return null;
                    }
                    ++part;
                }
            }
        }
        HashMap<ClusterNode, IntArray> res = new HashMap<ClusterNode, IntArray>();
        for (int p = 0; p < partLocs.length; ++p) {
            Set pl = partLocs[p];
            if (pl == UNMAPPED_PARTS) continue;
            assert (!F.isEmpty((Collection)pl)) : pl;
            ClusterNode n = pl.size() == 1 ? (ClusterNode)F.first((Iterable)pl) : (ClusterNode)F.rand((Collection)pl);
            IntArray parts = (IntArray)res.get(n);
            if (parts == null) {
                parts = new IntArray();
                res.put(n, parts);
            }
            parts.add(p);
        }
        return res;
    }

    private Iterator<List<?>> explainPlan(JdbcConnection c, GridCacheTwoStepQuery qry, Object[] params) throws IgniteCheckedException {
        ResultSet rs;
        ArrayList<List> lists = new ArrayList<List>();
        int mapQrys = qry.mapQueries().size();
        for (int i = 0; i < mapQrys; ++i) {
            rs = this.h2.executeSqlQueryWithTimer((Connection)c, "SELECT PLAN FROM " + GridSqlQuerySplitter.mergeTableIdentifier(i), null, false, 0, null);
            lists.add(F.asList((Object)this.getPlan(rs)));
        }
        int tblIdx = 0;
        for (GridCacheSqlQuery mapQry : qry.mapQueries()) {
            GridMergeTable tbl = this.createMergeTable(c, mapQry, false);
            this.fakeTable((Connection)c, tblIdx++).innerTable((Table)tbl);
        }
        GridCacheSqlQuery rdc = qry.reduceQuery();
        rs = this.h2.executeSqlQueryWithTimer((Connection)c, "EXPLAIN " + rdc.query(), F.asList((Object[])rdc.parameters(params)), false, 0, null);
        lists.add(F.asList((Object)this.getPlan(rs)));
        return lists.iterator();
    }

    private String getPlan(ResultSet rs) throws IgniteCheckedException {
        try {
            if (!rs.next()) {
                throw new IllegalStateException();
            }
            return rs.getString(1);
        }
        catch (SQLException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    public boolean send(Collection<ClusterNode> nodes, Message msg, @Nullable IgniteBiClosure<ClusterNode, Message, Message> specialize, boolean runLocParallel) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending: [msg=" + msg + ", nodes=" + nodes + ", specialize=" + specialize + "]");
        }
        return this.h2.send(GridTopic.TOPIC_QUERY, GridTopic.TOPIC_QUERY.ordinal(), nodes, msg, specialize, (IgniteInClosure2X<ClusterNode, Message>)this.locNodeHnd, (byte)10, runLocParallel);
    }

    public static int[] toArray(IntArray ints) {
        int[] res = new int[ints.size()];
        ints.toArray(res);
        return res;
    }

    private static Map<UUID, int[]> convert(Map<ClusterNode, IntArray> m) {
        if (m == null) {
            return null;
        }
        HashMap res = U.newHashMap((int)m.size());
        for (Map.Entry<ClusterNode, IntArray> entry : m.entrySet()) {
            res.put(entry.getKey().id(), GridReduceQueryExecutor.toArray(entry.getValue()));
        }
        return res;
    }

    private NodesForPartitionsResult nodesForPartitions(List<Integer> cacheIds, AffinityTopologyVersion topVer, int[] parts, boolean isReplicatedOnly, long qryId) {
        Collection<ClusterNode> nodes = null;
        Map<ClusterNode, IntArray> partsMap = null;
        Map<ClusterNode, IntArray> qryMap = null;
        if (this.isPreloadingActive(cacheIds)) {
            if (isReplicatedOnly) {
                nodes = this.replicatedUnstableDataNodes(cacheIds, qryId);
            } else {
                partsMap = this.partitionedUnstableDataNodes(cacheIds, qryId);
                if (partsMap != null) {
                    qryMap = this.narrowForQuery(partsMap, parts);
                    nodes = qryMap == null ? null : qryMap.keySet();
                }
            }
        } else {
            qryMap = this.stableDataNodes(isReplicatedOnly, topVer, cacheIds, parts, qryId);
            if (qryMap != null) {
                nodes = qryMap.keySet();
            }
        }
        return new NodesForPartitionsResult(nodes, partsMap, qryMap);
    }

    private GridMergeTable createMergeTable(JdbcConnection conn, GridCacheSqlQuery qry, boolean explain) throws IgniteCheckedException {
        try {
            Session ses = (Session)conn.getSession();
            CreateTableData data = new CreateTableData();
            data.tableName = "T___";
            data.schema = ses.getDatabase().getSchema(ses.getCurrentSchemaName());
            data.create = true;
            if (!explain) {
                LinkedHashMap colsMap = qry.columns();
                assert (colsMap != null);
                ArrayList<Column> cols = new ArrayList<Column>(colsMap.size());
                for (Map.Entry e : colsMap.entrySet()) {
                    String alias = (String)e.getKey();
                    GridSqlType t = (GridSqlType)e.getValue();
                    assert (!F.isEmpty((String)alias));
                    Column c = new Column(alias, t.type(), t.precision(), t.scale(), t.displaySize());
                    cols.add(c);
                }
                data.columns = cols;
            } else {
                data.columns = GridReduceQueryExecutor.planColumns();
            }
            boolean sortedIndex = !F.isEmpty((Collection)qry.sortColumns());
            GridMergeTable tbl = new GridMergeTable(data);
            ArrayList<Index> idxs = new ArrayList<Index>(2);
            if (explain) {
                idxs.add((Index)new GridMergeIndexUnsorted(this.ctx, tbl, sortedIndex ? MERGE_INDEX_SORTED : MERGE_INDEX_UNSORTED));
            } else if (sortedIndex) {
                List sortCols = qry.sortColumns();
                GridMergeIndexSorted sortedMergeIdx = new GridMergeIndexSorted(this.ctx, tbl, MERGE_INDEX_SORTED, GridSqlSortColumn.toIndexColumns((Table)tbl, sortCols));
                idxs.add((Index)GridMergeTable.createScanIndex(sortedMergeIdx));
                idxs.add((Index)sortedMergeIdx);
            } else {
                idxs.add((Index)new GridMergeIndexUnsorted(this.ctx, tbl, MERGE_INDEX_UNSORTED));
            }
            tbl.indexes(idxs);
            return tbl;
        }
        catch (Exception e) {
            U.closeQuiet((AutoCloseable)conn);
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    private static ArrayList<Column> planColumns() {
        ArrayList<Column> res = new ArrayList<Column>(1);
        res.add(new Column("PLAN", 13));
        return res;
    }

    public void onDisconnected(IgniteFuture<?> reconnectFut) {
        CacheException err = new CacheException("Query was cancelled, client node disconnected.", (Throwable)new IgniteClientDisconnectedException(reconnectFut, "Client node disconnected."));
        for (Map.Entry e : this.runs.entrySet()) {
            ((ReduceQueryRun)e.getValue()).disconnected(err);
        }
        for (DistributedUpdateRun r : this.updRuns.values()) {
            r.handleDisconnect(err);
        }
    }

    public Collection<GridRunningQueryInfo> longRunningQueries(long duration) {
        ArrayList<GridRunningQueryInfo> res = new ArrayList<GridRunningQueryInfo>();
        long curTime = U.currentTimeMillis();
        for (ReduceQueryRun run : this.runs.values()) {
            if (!run.queryInfo().longQuery(curTime, duration)) continue;
            res.add(run.queryInfo());
        }
        for (DistributedUpdateRun upd : this.updRuns.values()) {
            if (!upd.queryInfo().longQuery(curTime, duration)) continue;
            res.add(upd.queryInfo());
        }
        return res;
    }

    public void cancelQueries(Collection<Long> queries) {
        for (Long qryId : queries) {
            ReduceQueryRun run = (ReduceQueryRun)this.runs.get(qryId);
            if (run != null) {
                run.queryInfo().cancel();
                continue;
            }
            DistributedUpdateRun upd = (DistributedUpdateRun)this.updRuns.get(qryId);
            if (upd == null) continue;
            upd.queryInfo().cancel();
        }
    }

    private Map<ClusterNode, IntArray> narrowForQuery(Map<ClusterNode, IntArray> partsMap, int[] parts) {
        if (parts == null) {
            return partsMap;
        }
        HashMap cp = U.newHashMap((int)partsMap.size());
        for (Map.Entry<ClusterNode, IntArray> entry : partsMap.entrySet()) {
            IntArray filtered = new IntArray(parts.length);
            IntArray orig = entry.getValue();
            for (int i = 0; i < orig.size(); ++i) {
                int p = orig.get(i);
                if (Arrays.binarySearch(parts, p) < 0) continue;
                filtered.add(p);
            }
            if (filtered.size() <= 0) continue;
            cp.put(entry.getKey(), filtered);
        }
        return cp.isEmpty() ? null : cp;
    }

    private static long retryTimeout(long qryTimeout) {
        if (qryTimeout > 0L) {
            return qryTimeout;
        }
        return IgniteSystemProperties.getLong((String)"IGNITE_SQL_RETRY_TIMEOUT", (long)30000L);
    }

    static class NodesForPartitionsResult {
        final Collection<ClusterNode> nodes;
        final Map<ClusterNode, IntArray> partsMap;
        final Map<ClusterNode, IntArray> qryMap;

        NodesForPartitionsResult(Collection<ClusterNode> nodes, Map<ClusterNode, IntArray> partsMap, Map<ClusterNode, IntArray> qryMap) {
            this.nodes = nodes;
            this.partsMap = partsMap;
            this.qryMap = qryMap;
        }

        Collection<ClusterNode> nodes() {
            return this.nodes;
        }

        Map<ClusterNode, IntArray> partitionsMap() {
            return this.partsMap;
        }

        Map<ClusterNode, IntArray> queryPartitionsMap() {
            return this.qryMap;
        }
    }

    private static class ExplicitPartitionsSpecializer
    implements C2<ClusterNode, Message, Message> {
        private final Map<ClusterNode, IntArray> partsMap;

        public ExplicitPartitionsSpecializer(Map<ClusterNode, IntArray> partsMap) {
            this.partsMap = partsMap;
        }

        public Message apply(ClusterNode node, Message msg) {
            if (msg instanceof GridH2QueryRequest) {
                GridH2QueryRequest rq = new GridH2QueryRequest((GridH2QueryRequest)msg);
                rq.queryPartitions(GridReduceQueryExecutor.toArray(this.partsMap.get(node)));
                return rq;
            }
            if (msg instanceof GridH2DmlRequest) {
                GridH2DmlRequest rq = new GridH2DmlRequest((GridH2DmlRequest)msg);
                rq.queryPartitions(GridReduceQueryExecutor.toArray(this.partsMap.get(node)));
                return rq;
            }
            return msg;
        }
    }
}

