/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.query.h2.opt.join.DistributedJoinContext;
import org.apache.ignite.internal.processors.query.h2.twostep.PartitionReservation;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.jetbrains.annotations.Nullable;

public class QueryContext {
    private final int segment;
    private final IndexingQueryFilter filter;
    private final DistributedJoinContext distributedJoinCtx;
    private final MvccSnapshot mvccSnapshot;
    private final PartitionReservation reservations;
    private final boolean loc;

    public QueryContext(int segment, @Nullable IndexingQueryFilter filter, @Nullable DistributedJoinContext distributedJoinCtx, @Nullable MvccSnapshot mvccSnapshot, @Nullable PartitionReservation reservations, boolean loc) {
        this.segment = segment;
        this.filter = filter;
        this.distributedJoinCtx = distributedJoinCtx;
        this.mvccSnapshot = mvccSnapshot;
        this.reservations = reservations;
        this.loc = loc;
    }

    @Nullable
    public MvccSnapshot mvccSnapshot() {
        return this.mvccSnapshot;
    }

    @Nullable
    public DistributedJoinContext distributedJoinContext() {
        return this.distributedJoinCtx;
    }

    public int segment() {
        return this.segment;
    }

    public void clearContext(boolean nodeStop) {
        if (this.distributedJoinCtx != null) {
            this.distributedJoinCtx.cancel();
        }
        if (!nodeStop && this.reservations != null) {
            this.reservations.release();
        }
    }

    public IndexingQueryFilter filter() {
        return this.filter;
    }

    public boolean local() {
        return this.loc;
    }

    public String toString() {
        return S.toString(QueryContext.class, (Object)this);
    }
}

