/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.processors.cache.query.QueryTable;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionResult;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;

public class GridCacheTwoStepQuery {
    @GridToStringInclude
    private final List<GridCacheSqlQuery> mapQrys;
    @GridToStringInclude
    private final GridCacheSqlQuery rdc;
    private final boolean explain;
    private final String originalSql;
    private final Set<QueryTable> tbls;
    private final boolean distributedJoins;
    private final boolean skipMergeTbl;
    private final List<Integer> cacheIds;
    private final boolean locSplit;
    private final PartitionResult derivedPartitions;
    private final boolean mvccEnabled;
    private final int paramsCnt;

    public GridCacheTwoStepQuery(String originalSql, int paramsCnt, Set<QueryTable> tbls, GridCacheSqlQuery rdc, List<GridCacheSqlQuery> mapQrys, boolean skipMergeTbl, boolean explain, boolean distributedJoins, PartitionResult derivedPartitions, List<Integer> cacheIds, boolean mvccEnabled, boolean locSplit) {
        this.originalSql = originalSql;
        this.paramsCnt = paramsCnt;
        this.tbls = tbls;
        this.rdc = rdc;
        this.mapQrys = F.isEmpty(mapQrys) ? Collections.emptyList() : mapQrys;
        this.skipMergeTbl = skipMergeTbl;
        this.explain = explain;
        this.distributedJoins = distributedJoins;
        this.derivedPartitions = derivedPartitions;
        this.cacheIds = cacheIds;
        this.mvccEnabled = mvccEnabled;
        this.locSplit = locSplit;
    }

    public boolean distributedJoins() {
        return this.distributedJoins;
    }

    public boolean skipMergeTable() {
        return this.skipMergeTbl;
    }

    public boolean explain() {
        return this.explain;
    }

    public boolean isReplicatedOnly() {
        assert (!this.mapQrys.isEmpty());
        for (GridCacheSqlQuery mapQry : this.mapQrys) {
            if (!mapQry.isPartitioned()) continue;
            return false;
        }
        return true;
    }

    public GridCacheSqlQuery reduceQuery() {
        return this.rdc;
    }

    public List<GridCacheSqlQuery> mapQueries() {
        return this.mapQrys;
    }

    public List<Integer> cacheIds() {
        return this.cacheIds;
    }

    public boolean hasCacheIds() {
        return !F.isEmpty(this.cacheIds);
    }

    public String originalSql() {
        return this.originalSql;
    }

    public boolean isLocal() {
        return F.isEmpty(this.cacheIds) || this.locSplit;
    }

    public boolean isLocalSplit() {
        return this.locSplit;
    }

    public PartitionResult derivedPartitions() {
        return this.derivedPartitions;
    }

    public int tablesCount() {
        return this.tbls.size();
    }

    public Set<QueryTable> tables() {
        return this.tbls;
    }

    public boolean mvccEnabled() {
        return this.mvccEnabled;
    }

    public int parametersCount() {
        return this.paramsCnt;
    }

    public String toString() {
        return S.toString(GridCacheTwoStepQuery.class, (Object)this);
    }
}

