/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database.inlinecolumn;

import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.AbstractInlineIndexColumn;
import org.h2.table.Column;
import org.h2.value.Value;
import org.h2.value.ValueDouble;

public class DoubleInlineIndexColumn
extends AbstractInlineIndexColumn {
    DoubleInlineIndexColumn(Column col) {
        super(col, 7, (short)8);
    }

    @Override
    protected int compare0(long pageAddr, int off, Value v, int type) {
        if (this.type() != type) {
            return Integer.MIN_VALUE;
        }
        double val1 = Double.longBitsToDouble(PageUtils.getLong((long)pageAddr, (int)(off + 1)));
        double val2 = v.getDouble();
        return Integer.signum(Double.compare(val1, val2));
    }

    @Override
    protected int put0(long pageAddr, int off, Value val, int maxSize) {
        assert (this.type() == val.getType());
        PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
        PageUtils.putLong((long)pageAddr, (int)(off + 1), (long)Double.doubleToLongBits(val.getDouble()));
        return this.size() + 1;
    }

    @Override
    protected Value get0(long pageAddr, int off) {
        return ValueDouble.get((double)Double.longBitsToDouble(PageUtils.getLong((long)pageAddr, (int)(off + 1))));
    }

    @Override
    protected int inlineSizeOf0(Value val) {
        assert (val.getType() == this.type());
        return this.size() + 1;
    }
}

