/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.h2.H2TableDescriptor;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.opt.H2CacheRow;
import org.apache.ignite.internal.processors.query.h2.opt.H2PlainRowFactory;
import org.h2.message.DbException;
import org.h2.result.SearchRow;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public class GridH2RowDescriptor {
    public static final int COL_NOT_EXISTS = -1;
    private final H2TableDescriptor tbl;
    private final GridQueryTypeDescriptor type;
    private volatile String[] fields;
    private volatile int[] fieldTypes;
    private final int keyType;
    private final int valType;
    private volatile GridQueryProperty[] props;
    private volatile int keyAliasColId;
    private volatile int valAliasColId;

    public GridH2RowDescriptor(H2TableDescriptor tbl, GridQueryTypeDescriptor type) {
        assert (type != null);
        this.tbl = tbl;
        this.type = type;
        this.keyType = DataType.getTypeFromClass((Class)type.keyClass());
        this.valType = DataType.getTypeFromClass((Class)type.valueClass());
        this.refreshMetadataFromTypeDescriptor();
    }

    public H2TableDescriptor tableDescriptor() {
        return this.tbl;
    }

    public final void refreshMetadataFromTypeDescriptor() {
        int i;
        LinkedHashMap allFields = new LinkedHashMap(this.type.fields());
        this.fields = allFields.keySet().toArray(new String[allFields.size()]);
        this.fieldTypes = new int[this.fields.length];
        Class[] classes = allFields.values().toArray(new Class[this.fields.length]);
        for (i = 0; i < this.fieldTypes.length; ++i) {
            this.fieldTypes[i] = DataType.getTypeFromClass((Class)classes[i]);
        }
        this.props = new GridQueryProperty[this.fields.length];
        for (i = 0; i < this.fields.length; ++i) {
            GridQueryProperty p = this.type.property(this.fields[i]);
            assert (p != null) : this.fields[i];
            this.props[i] = p;
        }
        List<String> fieldsList = Arrays.asList(this.fields);
        this.keyAliasColId = this.type.keyFieldName() != null ? 2 + fieldsList.indexOf(this.type.keyFieldAlias()) : -1;
        this.valAliasColId = this.type.valueFieldName() != null ? 2 + fieldsList.indexOf(this.type.valueFieldAlias()) : -1;
    }

    public IgniteH2Indexing indexing() {
        return this.tbl.indexing();
    }

    public GridQueryTypeDescriptor type() {
        return this.type;
    }

    public GridCacheContextInfo<?, ?> cacheInfo() {
        return this.tbl.cacheInfo();
    }

    @Nullable
    public GridCacheContext<?, ?> context() {
        return this.tbl.cache();
    }

    public H2CacheRow createRow(CacheDataRow dataRow) throws IgniteCheckedException {
        H2CacheRow row;
        try {
            row = new H2CacheRow(this, dataRow);
        }
        catch (ClassCastException e) {
            throw new IgniteCheckedException("Failed to convert key to SQL type. Please make sure that you always store each value type with the same key type or configure key type as common super class for all actual keys for this value type.", (Throwable)e);
        }
        return row;
    }

    public int keyType() {
        return this.keyType;
    }

    public int valueType() {
        return this.valType;
    }

    public int fieldsCount() {
        return this.fields.length;
    }

    public int fieldType(int col) {
        return this.fieldTypes[col];
    }

    public Object columnValue(Object key, Object val, int col) {
        try {
            return this.props[col].value(key, val);
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    public void setColumnValue(Object key, Object val, Object colVal, int col) {
        try {
            this.props[col].setValue(key, val, colVal);
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    public boolean isColumnKeyProperty(int col) {
        return this.props[col].key();
    }

    public boolean isKeyColumn(int colId) {
        assert (colId >= 0);
        return colId == 0 || colId == this.keyAliasColId;
    }

    public boolean isKeyAliasColumn(int colId) {
        assert (colId >= 0);
        return colId == this.keyAliasColId;
    }

    public boolean isValueColumn(int colId) {
        assert (colId >= 0);
        return colId == 1 || colId == this.valAliasColId;
    }

    public boolean isValueAliasColumn(int colId) {
        assert (colId >= 0);
        return colId == this.valAliasColId;
    }

    public boolean isKeyValueOrVersionColumn(int colId) {
        assert (colId >= 0);
        if (colId < 2) {
            return true;
        }
        if (colId == this.keyAliasColId) {
            return true;
        }
        return colId == this.valAliasColId;
    }

    public boolean checkKeyIndexCondition(int[] masks, int mask) {
        assert (masks != null);
        assert (masks.length > 0);
        if (this.keyAliasColId < 0) {
            return (masks[0] & mask) != 0;
        }
        return (masks[0] & mask) != 0 || (masks[this.keyAliasColId] & mask) != 0;
    }

    public SearchRow prepareProxyIndexRow(SearchRow row) {
        if (row == null) {
            return null;
        }
        Value[] data = new Value[row.getColumnCount()];
        for (int idx = 0; idx < data.length; ++idx) {
            data[idx] = row.getValue(idx);
        }
        this.copyAliasColumnData(data, 0, this.keyAliasColId);
        this.copyAliasColumnData(data, 1, this.valAliasColId);
        return H2PlainRowFactory.create(data);
    }

    private void copyAliasColumnData(Value[] data, int colId, int aliasColId) {
        if (aliasColId <= 0) {
            return;
        }
        if (data[aliasColId] == null && data[colId] != null) {
            data[aliasColId] = data[colId];
        }
        if (data[colId] == null && data[aliasColId] != null) {
            data[colId] = data[aliasColId];
        }
    }

    public int getAlternativeColumnId(int colId) {
        if (this.keyAliasColId > 0) {
            if (colId == 0) {
                return this.keyAliasColId;
            }
            if (colId == this.keyAliasColId) {
                return 0;
            }
        }
        if (this.valAliasColId > 0) {
            if (colId == 1) {
                return this.valAliasColId;
            }
            if (colId == this.valAliasColId) {
                return 1;
            }
        }
        return colId;
    }
}

