/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Cursor;
import org.apache.ignite.internal.processors.query.h2.opt.H2PlainRowFactory;
import org.apache.ignite.internal.processors.query.h2.twostep.AbstractReducer;
import org.apache.ignite.internal.processors.query.h2.twostep.ReduceResultPage;
import org.h2.index.Cursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public class UnsortedReducer
extends AbstractReducer {
    private final PollableQueue<ReduceResultPage> queue = new PollableQueue();
    private final AtomicInteger activeSourcesCnt = new AtomicInteger(-1);
    private Iterator<Value[]> iter = Collections.emptyIterator();

    public UnsortedReducer(GridKernalContext ctx) {
        super(ctx);
    }

    public static UnsortedReducer createDummy(GridKernalContext ctx) {
        return new UnsortedReducer(ctx);
    }

    @Override
    public void setSources(Collection<ClusterNode> nodes, int segmentsCnt) {
        super.setSources(nodes, segmentsCnt);
        int x = this.srcNodes.size() * segmentsCnt;
        assert (x > 0) : x;
        this.activeSourcesCnt.set(x);
    }

    @Override
    public boolean fetchedAll() {
        int x = this.activeSourcesCnt.get();
        assert (x >= 0) : x;
        return x == 0 && this.queue.isEmpty();
    }

    @Override
    protected void addPage0(ReduceResultPage page) {
        assert (page.rowsInPage() > 0 || page.isLast() || page.isFail());
        if (page.rowsInPage() != 0 || page.isFail()) {
            this.queue.add(page);
        }
        if (page.isLast()) {
            int x = this.activeSourcesCnt.decrementAndGet();
            assert (x >= 0) : x;
            if (x == 0) {
                this.queue.add(this.createDummyLastPage(page));
            }
        }
    }

    @Override
    protected Cursor findAllFetched(List<Row> fetched, @Nullable SearchRow first, @Nullable SearchRow last) {
        return new GridH2Cursor(fetched.iterator());
    }

    @Override
    protected Cursor findInStream(SearchRow first, SearchRow last) {
        return new FetchingCursor(new Iterator<Row>(){

            @Override
            public boolean hasNext() {
                UnsortedReducer.this.iter = UnsortedReducer.this.pollNextIterator(UnsortedReducer.this.queue, UnsortedReducer.this.iter);
                return UnsortedReducer.this.iter.hasNext();
            }

            @Override
            public Row next() {
                return H2PlainRowFactory.create((Value[])UnsortedReducer.this.iter.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
    }

    private static class PollableQueue<X>
    extends LinkedBlockingQueue<X>
    implements AbstractReducer.Pollable<X> {
        private PollableQueue() {
        }
    }

    private class FetchingCursor
    implements Cursor {
        private Iterator<Row> stream;
        private List<Row> rows;
        private int cur;

        FetchingCursor(Iterator<Row> stream) {
            assert (stream != null);
            this.rows = UnsortedReducer.this.fetched;
            this.stream = stream;
            --this.cur;
        }

        private void fetchRows() {
            this.rows = UnsortedReducer.this.fetched.lastBlock();
            this.cur = this.rows.size();
            if (this.stream.hasNext()) {
                UnsortedReducer.this.fetched.add(Objects.requireNonNull(this.stream.next()));
                if (UnsortedReducer.this.fetched.size() == AbstractReducer.MAX_FETCH_SIZE) {
                    UnsortedReducer.this.onBlockEvict(UnsortedReducer.this.fetched.evictFirstBlock());
                    assert (UnsortedReducer.this.fetched.size() < AbstractReducer.MAX_FETCH_SIZE);
                }
            }
            if (this.cur == this.rows.size()) {
                this.cur = Integer.MAX_VALUE;
            }
        }

        public boolean next() {
            if (this.cur == Integer.MAX_VALUE) {
                return false;
            }
            if (++this.cur == this.rows.size()) {
                this.fetchRows();
            }
            return this.cur < Integer.MAX_VALUE;
        }

        public Row get() {
            return this.rows.get(this.cur);
        }

        public SearchRow getSearchRow() {
            return this.get();
        }

        public boolean previous() {
            throw DbException.getUnsupportedException((String)"previous");
        }
    }
}

