/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.stream.kafka.connect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.stream.kafka.connect.IgniteSinkTask;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkConnector;

public class IgniteSinkConnector
extends SinkConnector {
    private Map<String, String> configProps;

    public String version() {
        return AppInfoParser.getVersion();
    }

    public void start(Map<String, String> props) {
        this.configProps = props;
        try {
            A.notNullOrEmpty((String)this.configProps.get("topics"), (String)"topics");
            A.notNullOrEmpty((String)this.configProps.get("cacheName"), (String)"cache name");
            A.notNullOrEmpty((String)this.configProps.get("igniteCfg"), (String)"path to cache config file");
        }
        catch (IllegalArgumentException e) {
            throw new ConnectException("Cannot start IgniteSinkConnector due to configuration error", (Throwable)e);
        }
    }

    public Class<? extends Task> taskClass() {
        return IgniteSinkTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        ArrayList<Map<String, String>> taskConfigs = new ArrayList<Map<String, String>>();
        HashMap<String, String> taskProps = new HashMap<String, String>();
        taskProps.putAll(this.configProps);
        for (int i = 0; i < maxTasks; ++i) {
            taskConfigs.add(taskProps);
        }
        return taskConfigs;
    }

    public void stop() {
    }
}

