/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.dataset.feature;

import java.io.Serializable;
import org.apache.ignite.ml.dataset.feature.FeatureMeta;

public class BucketMeta
implements Serializable {
    private static final long serialVersionUID = 7827158624437006995L;
    private final FeatureMeta featureMeta;
    private double bucketSize;
    private double minVal;

    public BucketMeta(FeatureMeta featureMeta) {
        this.featureMeta = featureMeta;
    }

    public int getBucketId(Double val) {
        if (this.featureMeta.isCategoricalFeature()) {
            return (int)Math.rint(val);
        }
        return (int)Math.rint((val - this.minVal) / this.bucketSize);
    }

    public double bucketIdToValue(int bucketId) {
        if (this.featureMeta.isCategoricalFeature()) {
            return bucketId;
        }
        return this.minVal + ((double)bucketId + 0.5) * this.bucketSize;
    }

    public void setMinVal(double minVal) {
        this.minVal = minVal;
    }

    public void setBucketSize(double bucketSize) {
        this.bucketSize = bucketSize;
    }

    public FeatureMeta getFeatureMeta() {
        return this.featureMeta;
    }
}

