/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.dataset.feature.extractor;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.ml.dataset.feature.extractor.Vectorizer;

public class ExtractionUtils {

    public static abstract class ArrayLikeVectorizer<K, V>
    extends IntCoordVectorizer<K, V> {
        private static final long serialVersionUID = 5383770258177577358L;

        public ArrayLikeVectorizer(Integer ... coords) {
            super(coords);
        }

        protected abstract int sizeOf(K var1, V var2);

        @Override
        protected List<Integer> allCoords(K key, V value) {
            return IntStream.range(0, this.sizeOf(key, value)).boxed().collect(Collectors.toList());
        }
    }

    public static abstract class IntCoordVectorizer<K, V>
    extends DefaultLabelVectorizer<K, V, Integer> {
        private static final long serialVersionUID = -1734141133396507699L;

        public IntCoordVectorizer(Integer ... coords) {
            super((Serializable[])coords);
        }
    }

    public static abstract class StringCoordVectorizer<K, V>
    extends DefaultLabelVectorizer<K, V, String> {
        private static final long serialVersionUID = 6989473570977667636L;

        public StringCoordVectorizer(String ... coords) {
            super((Serializable[])coords);
        }
    }

    public static abstract class ArrayLikeObjectLabelVectorizer<K, V>
    extends IntCoordObjectLabelVectorizer<K, V> {
        private static final long serialVersionUID = 5383770258177533358L;

        public ArrayLikeObjectLabelVectorizer(Integer ... coords) {
            super(coords);
        }

        protected abstract int sizeOf(K var1, V var2);

        @Override
        protected List<Integer> allCoords(K key, V value) {
            return IntStream.range(0, this.sizeOf(key, value)).boxed().collect(Collectors.toList());
        }
    }

    public static abstract class IntCoordObjectLabelVectorizer<K, V>
    extends ObjectLabelVectorizer<K, V, Integer> {
        private static final long serialVersionUID = -2834141133396507699L;

        public IntCoordObjectLabelVectorizer(Integer ... coords) {
            super((Serializable[])coords);
        }
    }

    public static abstract class ObjectLabelVectorizer<K, V, C extends Serializable>
    extends Vectorizer<K, V, C, Object> {
        private static final long serialVersionUID = 2226703640636013770L;

        public ObjectLabelVectorizer(C ... coords) {
            super(coords);
        }

        @Override
        protected Object label(C coord, K key, V value) {
            return this.feature(coord, key, value);
        }

        @Override
        protected Object zero() {
            return "default";
        }
    }

    public static abstract class DefaultLabelVectorizer<K, V, C extends Serializable>
    extends Vectorizer<K, V, C, Double> {
        private static final long serialVersionUID = 2876703640636013770L;

        public DefaultLabelVectorizer(C ... coords) {
            super(coords);
        }

        @Override
        protected Double label(C coord, K key, V value) {
            return (Double)this.feature(coord, key, value);
        }

        @Override
        protected Double zero() {
            return 0.0;
        }
    }
}

